import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import vue from '@vitejs/plugin-vue';
import { VitePWA } from 'vite-plugin-pwa';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/js/clientes-pwa/main.js'
            ],
            refresh: true,
        }),
        tailwindcss(),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
        VitePWA({
            registerType: 'autoUpdate',
            devOptions: {
                enabled: true
            },
            manifest: {
                name: 'Tienda de Pedidos',
                short_name: 'Pedidos',
                description: 'Aplicación móvil para gestionar pedidos',
                theme_color: '#3b82f6',
                background_color: '#f8fafc',
                display: 'standalone',
                icon: 'resources/js/clientes-pwa/assets/img/icon-512x512.png',
                icons: [
                    {
                        src: 'resources/js/clientes-pwa/assets/img/icon-192x192.png',
                        sizes: '192x192',
                        type: 'image/png'
                    },
                    {
                        src: 'resources/js/clientes-pwa/assets/img/icon-512x512.png',
                        sizes: '512x512',
                        type: 'image/png'
                    }
                ]
            }
        })
    ],
});
