<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Obtener el primer usuario
$user = \App\Models\User::first();
echo "Usuario: " . $user->name . PHP_EOL;
echo "Email: " . $user->email . PHP_EOL;
echo "Token: " . $user->api_token . PHP_EOL;
echo "HasRole Admin: " . ($user->hasRole('admin') ? 'Sí' : 'No') . PHP_EOL;
echo "HasRole Super-Admin: " . ($user->hasRole('super-admin') ? 'Sí' : 'No') . PHP_EOL;

// Verificar si el token existe
if (empty($user->api_token)) {
    echo "ERROR: El usuario no tiene token!" . PHP_EOL;
} else {
    echo "Token verification test: PASSED" . PHP_EOL;
}
