<?php

// Test script para verificar el nuevo formulario de creación de pedidos

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Producto;
use App\Models\Cliente;

echo "=== Test de Nuevo Formulario de Creación de Pedidos ===\n\n";

// 1. Verificar que hay productos disponibles
echo "1. Verificando productos disponibles...\n";
$productos = Producto::where('status', true)->limit(5)->get();
if ($productos->count() > 0) {
    echo "✓ Hay " . $productos->count() . " productos activos disponibles\n";
    foreach ($productos as $producto) {
        echo "  - {$producto->nombre} (Stock: {$producto->stock}, Precio: \${$producto->precio})\n";
    }
} else {
    echo "✗ No hay productos activos disponibles\n";
}

// 2. Verificar que hay clientes
echo "\n2. Verificando clientes disponibles...\n";
$clientes = Cliente::limit(3)->get();
if ($clientes->count() > 0) {
    echo "✓ Hay " . $clientes->count() . " clientes registrados\n";
    foreach ($clientes as $cliente) {
        echo "  - {$cliente->nombres} {$cliente->apellidos} (ID: {$cliente->id})\n";
    }
} else {
    echo "✗ No hay clientes registrados\n";
}

// 3. Verificar que el componente Livewire existe
echo "\n3. Verificando componente Livewire...\n";
$componentPath = __DIR__ . '/app/Livewire/Admin/Pedidos/Create.php';
if (file_exists($componentPath)) {
    echo "✓ Componente Livewire Create.php encontrado\n";
    
    $content = file_get_contents($componentPath);
    if (strpos($content, 'create-mejorado') !== false) {
        echo "✓ Componente configurado para usar la vista mejorada\n";
    } else {
        echo "✗ Componente no está configurado para usar la vista mejorada\n";
    }
} else {
    echo "✗ Componente Livewire Create.php no encontrado\n";
}

// 4. Verificar que la vista mejorada existe
echo "\n4. Verificando vista mejorada...\n";
$viewPath = __DIR__ . '/resources/views/livewire/admin/pedidos/create-mejorado.blade.php';
if (file_exists($viewPath)) {
    echo "✓ Vista mejorada create-mejorado.blade.php encontrada\n";
    
    $viewContent = file_get_contents($viewPath);
    $features = [
        'búsqueda en tiempo real' => 'searchTerm',
        'resultados de búsqueda' => 'searchResults',
        'diseño con gradientes' => 'bg-gradient',
        'progress steps' => 'step-item',
        'imágenes de productos' => 'producto->image',
        'validación mejorada' => 'is-invalid',
        'tooltips' => 'data-bs-toggle="tooltip"'
    ];
    
    foreach ($features as $feature => $searchTerm) {
        if (strpos($viewContent, $searchTerm) !== false) {
            echo "  ✓ {$feature} implementado\n";
        } else {
            echo "  ✗ {$feature} no encontrado\n";
        }
    }
} else {
    echo "✗ Vista mejorada no encontrada\n";
}

echo "\n=== Resumen ===\n";
echo "El nuevo formulario de creación de pedidos ha sido implementado con:\n";
echo "• Diseño profesional con gradientes y animaciones\n";
echo "• Búsqueda de productos en tiempo real\n";
echo "• Vista previa de productos con imágenes\n";
echo "• Progress steps para mejor UX\n";
echo "• Validación mejorada con feedback visual\n";
echo "• Tabla de carrito mejorada con imágenes\n";
echo "• Botones de acción mejorados\n";
echo "\nPara acceder al formulario, visita: /admin/pedidos/create\n";

echo "\n=== Próximos pasos ===\n";
echo "1. Verificar que la ruta /admin/pedidos/create esté funcionando\n";
echo "2. Probar la búsqueda de productos en tiempo real\n";
echo "3. Verificar que las imágenes de productos se muestren correctamente\n";
echo "4. Probar la creación de un pedido completo\n";