<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use App\Models\User;

// Obtener un usuario administrador
$adminUser = User::whereHas('roles', function ($query) {
    $query->where('name', 'Administrador');
})->first();

if (!$adminUser) {
    echo "No se encontró usuario con rol Administrador\n";
    exit;
}

echo "Usuario encontrado: {$adminUser->name}\n";
echo "Email: {$adminUser->email}\n";
echo "Rol: " . $adminUser->roles->first()->name . "\n";
echo "Token actual: " . ($adminUser->api_token ?: "No tiene token") . "\n";

// Simular que el usuario no tiene token
$originalToken = $adminUser->api_token;
$adminUser->api_token = null;
$adminUser->save();

echo "\nToken eliminado temporalmente para prueba\n";

// Ahora simular el proceso de login
if ($adminUser->hasRole(['Administrador', 'Super Administrador'])) {
    if (empty($adminUser->api_token)) {
        $adminUser->api_token = \Illuminate\Support\Str::random(80);
        $adminUser->save();
        echo "✅ Token generado automáticamente: {$adminUser->api_token}\n";
    } else {
        echo "El usuario ya tiene token\n";
    }
} else {
    echo "Este usuario no es administrador\n";
}

// Restaurar token original si lo tenía
if ($originalToken) {
    $adminUser->api_token = $originalToken;
    $adminUser->save();
    echo "\nToken original restaurado\n";
}
