<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\Caja;

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=== PRUEBA DE EXPORTACIÓN DE CAJA ===\n\n";

$caja = Caja::first();

if ($caja) {
    echo "✓ Caja encontrada ID: {$caja->id}\n";
    echo "✓ Total ingresos: {$caja->total_ingresos}\n";
    echo "✓ Total pedidoPagos: {$caja->pedidoPagos()->count()}\n";
    
    // Verificar la relación con pedidos confirmados
    $pagosConfirmados = $caja->pedidoPagos()->whereHas('pedido', function($query) {
        $query->where('estado', 'pagado');
    })->get();
    
    echo "✓ Pagos de pedidos confirmados: {$pagosConfirmados->count()}\n";
    
    if ($pagosConfirmados->isNotEmpty()) {
        echo "\n=== EJEMPLOS DE PAGOS ===\n";
        foreach ($pagosConfirmados->take(3) as $pago) {
            echo "- Pedido ID: #{$pago->pedidoId}\n";
            echo "  Método: {$pago->metodo_pago}\n";
            echo "  Total USD: {$pago->total_usd}\n";
            echo "  Usuario: " . ($pago->pedido->user->name ?? 'N/A') . "\n";
            echo "  Estado pedido: {$pago->pedido->estado}\n\n";
        }
    }
    
    echo "✓ Controlador de exportación listo para usar pedidoPagos\n";
    
} else {
    echo "✗ No hay cajas disponibles\n";
}