<?php

require __DIR__.'/vendor/autoload.php';
$app = require __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Buscar cualquier caja existente
$caja = \App\Models\Caja::with(['pedidoPagos.pedido', 'usuario', 'sucursal'])->first();

if($caja) {
    echo "✅ Usando Caja ID: {$caja->id}\n";
    echo "Caja ID: " . $caja->id . PHP_EOL;
    echo "Estado: " . $caja->estado . PHP_EOL;
    echo "Total Ingresos ANTES: " . $caja->total_ingresos . PHP_EOL;

    // Calcular totales
    $caja->calcularTotales();
    $caja->refresh();

    echo "Total Ingresos DESPUÉS: " . $caja->total_ingresos . PHP_EOL;
    echo "Pedidos Pagos totales: " . $caja->pedidoPagos()->count() . PHP_EOL;
    echo "Pedidos Pagos confirmados: " . $caja->pedidoPagos()->whereHas('pedido', function($q) {
        $q->where('estado', 'pagado');
    })->count() . PHP_EOL;

    // Ver algunos ejemplos
    echo "\nEjemplos de pedidos y sus estados:\n";
    $pagos = $caja->pedidoPagos()->with('pedido')->limit(5)->get();
    foreach($pagos as $pago) {
        echo "Pago ID: " . $pago->id . ", Pedido ID: " . $pago->pedidoId . ", Estado pedido: " . ($pago->pedido ? $pago->pedido->estado : 'Sin pedido') . ", Total USD: " . $pago->total_usd . PHP_EOL;
    }

    // Ver el detalle del cálculo
    echo "\nDetalle del cálculo:\n";
    $pedidoPagos = $caja->pedidoPagos()
        ->whereHas('pedido', function($query) {
            $query->where('estado', 'pagado');
        })
        ->get();

    $totalEfectivo = 0;
    $totalTransferencias = 0;
    $totalTarjetas = 0;

    foreach ($pedidoPagos as $pago) {
        $metodo = strtolower(trim($pago->metodo_pago));
        echo "Pago ID: " . $pago->id . ", Método: " . $pago->metodo_pago . " (normalizado: " . $metodo . "), Total USD: " . $pago->total_usd . PHP_EOL;
        switch ($metodo) {
            case 'efectivo':
            case 'efectivo bs':
            case 'efectivo $':
                $totalEfectivo += $pago->total_usd;
                break;
            case 'transferencia':
            case 'pago_movil':
            case 'pago móvil':
                $totalTransferencias += $pago->total_usd;
                break;
            case 'tarjeta':
                $totalTarjetas += $pago->total_usd;
                break;
            case 'punto_de_venta':
                $totalTarjetas += $pago->total_usd;
                break;
        }
    }

    echo "Total Efectivo: " . $totalEfectivo . PHP_EOL;
    echo "Total Transferencias: " . $totalTransferencias . PHP_EOL;
    echo "Total Tarjetas: " . $totalTarjetas . PHP_EOL;
    echo "Suma total: " . ($totalEfectivo + $totalTransferencias + $totalTarjetas) . PHP_EOL;

    // Verificar todos los pagos
    echo "💰 Pagos relacionados (sin filtro):\n";
    $allPagos = $caja->pedidoPagos;
    echo "- Total de pagos: {$allPagos->count()}\n";

    foreach ($allPagos as $pago) {
        $pedidoEstado = $pago->pedido ? $pago->pedido->estado : 'N/A';
        echo "  - Pago ID: {$pago->id}, Pedido ID: {$pago->pedidoId}, Estado pedido: {$pedidoEstado}, Método: {$pago->metodo_pago}, Total USD: {$pago->total_usd}\n";
    }

    echo "\n🔍 Pagos con filtro 'pagado' o 'entregado':\n";
$pagosFiltrados = $caja->pedidoPagos()
    ->whereHas('pedido', function($query) {
        $query->whereIn('estado', ['pagado', 'entregado']);
    })
    ->get();

echo "- Total de pagos filtrados: {$pagosFiltrados->count()}\n";

foreach ($pagosFiltrados as $pago) {
    $pedidoEstado = $pago->pedido ? $pago->pedido->estado : 'N/A';
    echo "  - Pago ID: {$pago->id}, Pedido ID: {$pago->pedidoId}, Estado pedido: {$pedidoEstado}, Método: {$pago->metodo_pago}, Total USD: {$pago->total_usd}\n";
}

echo "\n📊 Resumen por método de pago (filtrado 'pagado' o 'entregado'):\n";
$resumenMetodos = $caja->pedidoPagos()
    ->whereHas('pedido', function($query) {
        $query->whereIn('estado', ['pagado', 'entregado']);
    })
    ->selectRaw('metodo_pago, COUNT(*) as cantidad, SUM(total_usd) as total')
    ->groupBy('metodo_pago')
    ->get();

foreach ($resumenMetodos as $item) {
    echo "- Método: {$item->metodo_pago}, Cantidad: {$item->cantidad}, Total: {$item->total}\n";
}

echo "\n📊 Resumen por concepto (filtrado 'pagado' o 'entregado'):\n";
$resumenConceptos = $caja->pedidoPagos()
    ->whereHas('pedido', function($query) {
        $query->whereIn('estado', ['pagado', 'entregado']);
    })
    ->selectRaw('metodo_pago as concepto, COUNT(*) as cantidad, SUM(total_usd) as total')
    ->groupBy('metodo_pago')
    ->get();

foreach ($resumenConceptos as $item) {
    echo "- Concepto: {$item->concepto}, Cantidad: {$item->cantidad}, Total: {$item->total}\n";
}
} else {
    echo "No hay caja abierta" . PHP_EOL;

    // Ver si hay alguna caja
    $caja = \App\Models\Caja::latest()->first();
    if($caja) {
        echo "Última caja encontrada - ID: " . $caja->id . ", Estado: " . $caja->estado . PHP_EOL;
    }
}
