<?php

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=== Test de Búsqueda de Productos ===\n\n";

try {
    // Obtener algunos productos para probar
    $productos = \App\Models\Producto::where('status', 1)->limit(3)->get();
    
    if ($productos->isEmpty()) {
        echo "⚠️  No hay productos disponibles para probar\n";
        exit(1);
    }
    
    echo "✓ Productos disponibles para prueba:\n";
    foreach ($productos as $producto) {
        echo "  - ID: {$producto->id} | Nombre: {$producto->name} | Stock: {$producto->quantity} | Precio: {$producto->price}\n";
    }
    
    // Probar búsqueda con el primer producto
    $productoTest = $productos->first();
    $terminoBusqueda = substr($productoTest->name, 0, 3); // Primeros 3 caracteres
    
    echo "\n🔍 Probando búsqueda con término: '{$terminoBusqueda}'\n";
    
    // Simular la consulta que hace el componente Livewire
    $resultados = \App\Models\Producto::where('status', 1)
        ->where(function($query) use ($terminoBusqueda) {
            $query->where('name', 'like', '%' . $terminoBusqueda . '%')
                  ->orWhere('description', 'like', '%' . $terminoBusqueda . '%')
                  ->orWhere('code', 'like', '%' . $terminoBusqueda . '%');
        })
        ->with(['featuredImage', 'categoria'])
        ->limit(8)
        ->get();
    
    echo "✓ Se encontraron {$resultados->count()} productos\n";
    
    if ($resultados->count() > 0) {
        echo "  Resultados:\n";
        foreach ($resultados as $resultado) {
            $imagen = $resultado->featuredImage ? '✓' : '✗';
            $categoria = $resultado->categoria ? $resultado->categoria->name : 'Sin categoría';
            echo "    - {$resultado->name} (Stock: {$resultado->quantity}, Imagen: {$imagen}, Categoría: {$categoria})\n";
        }
    }
    
    // Probar búsqueda que no debería tener resultados
    echo "\n🔍 Probando búsqueda con término que no existe: 'xyz123'\n";
    $resultadosVacios = \App\Models\Producto::where('status', 1)
        ->where(function($query) {
            $query->where('name', 'like', '%xyz123%')
                  ->orWhere('description', 'like', '%xyz123%')
                  ->orWhere('code', 'like', '%xyz123%');
        })
        ->with(['featuredImage', 'categoria'])
        ->limit(8)
        ->get();
    
    echo "✓ Se encontraron {$resultadosVacios->count()} productos (debería ser 0)\n";
    
    echo "\n✅ Test completado exitosamente!\n";
    echo "\nEl sistema de búsqueda está funcionando correctamente.\n";
    echo "Los campos se han corregido: name, description, code, quantity, featuredImage\n";
    
} catch (\Exception $e) {
    echo "❌ Error durante el test: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
    exit(1);
}