<?php

require_once 'vendor/autoload.php';

use App\Services\WhatsAppService;

// Cargar configuración de Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🧪 Probando envío de mensaje WhatsApp...\n\n";

$whatsappService = new WhatsAppService();

// Probar conectividad
echo "1. Probando conectividad...\n";
$connection = $whatsappService->testConnection();
echo "   Resultado: " . ($connection['success'] ? '✅ Conectado' : '❌ ' . $connection['error']) . "\n\n";

// Probar estado
echo "2. Obteniendo estado...\n";
$status = $whatsappService->getStatus();
echo "   Estado: " . ($status['success'] ? $status['status'] : $status['error']) . "\n";
echo "   Listo: " . ($status['isReady'] ?? false ? 'Sí' : 'No') . "\n\n";

// Probar envío (solo si está listo)
if ($status['success'] && ($status['isReady'] ?? false)) {
    echo "3. Enviando mensaje de prueba...\n";
    
    // Número y mensaje de prueba
    $testNumber = '+584242115948';
    $testMessage = 'Mensaje de prueba desde Laravel - ' . date('Y-m-d H:i:s');
    
    $result = $whatsappService->sendMessage($testNumber, $testMessage);
    
    echo "   Resultado: " . ($result['success'] ? '✅ Enviado' : '❌ ' . $result['error']) . "\n";
    if ($result['success']) {
        echo "   ID: " . ($result['id'] ?? 'N/A') . "\n";
    }
} else {
    echo "3. ⚠️  WhatsApp no está listo para enviar mensajes\n";
    if (isset($status['qr'])) {
        echo "   Necesitas escanear el código QR primero\n";
    }
}

echo "\n✅ Prueba completada\n";