<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "📱 Probando WhatsApp con JWT habilitado...\n\n";

try {
    $whatsappService = new \App\Services\WhatsAppService();
    
    // Probar conexión
    echo "1. Probando conexión...\n";
    $connection = $whatsappService->testConnection();
    echo "   Resultado: " . ($connection['success'] ? '✅ Conectado' : '❌ ' . $connection['error']) . "\n\n";
    
    // Probar estado
    echo "2. Obteniendo estado...\n";
    $status = $whatsappService->getStatus();
    echo "   Estado: " . ($status['success'] ? '✅ OK' : '❌ ' . $status['error']) . "\n";
    if (isset($status['status'])) {
        echo "   WhatsApp: " . $status['status'] . "\n";
        echo "   Listo: " . ($status['isReady'] ? 'Sí' : 'No') . "\n";
    }
    echo "\n";
    
    // Probar envío de mensaje (solo si está conectado)
    if ($connection['success'] && isset($status['isReady']) && $status['isReady']) {
        echo "3. Enviando mensaje de prueba...\n";
        $result = $whatsappService->sendMessage('584241234567', 'Mensaje de prueba con JWT habilitado');
        
        if ($result['success']) {
            echo "   ✅ Mensaje enviado exitosamente\n";
            if (isset($result['jwt_authenticated'])) {
                echo "   🔐 JWT: " . ($result['jwt_authenticated'] ? 'Autenticado' : 'No autenticado') . "\n";
            }
            if (isset($result['jwt_user'])) {
                echo "   👤 Usuario JWT: " . $result['jwt_user']['name'] . "\n";
            }
        } else {
            echo "   ❌ Error: " . $result['error'] . "\n";
        }
    } else {
        echo "3. ⚠️  WhatsApp no está listo, omitiendo envío de mensaje\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}