<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "📱 Probando mensaje de bienvenida...\n\n";

try {
    // Simular un usuario recién registrado
    $testUser = new stdClass();
    $testUser->name = 'Juan Pérez';
    $testUser->telefono = '584241234567';
    
    $whatsappService = new \App\Services\WhatsAppService();
    
    // Crear el mensaje de bienvenida
    $message = "🎉 *¡Bienvenido a nuestra tienda!* 🎉\n\n";
    $message .= "*Hola {$testUser->name}!*\n\n";
    $message .= "Gracias por registrarte en nuestra plataforma. Ahora puedes:\n\n";
    $message .= "🛒 Realizar pedidos fácilmente\n";
    $message .= "📱 Recibir notificaciones de tus pedidos\n";
    $message .= "⭐ Guardar productos en favoritos\n";
    $message .= "🚚 Seguimiento de entregas\n\n";
    $message .= "¡Esperamos que disfrutes de tu experiencia de compra!\n\n";
    $message .= "Si tienes alguna pregunta, no dudes en contactarnos.";
    
    echo "Mensaje a enviar:\n";
    echo "==================\n";
    echo $message . "\n";
    echo "==================\n\n";
    
    // Verificar estado de WhatsApp
    $status = $whatsappService->getStatus();
    if (!$status['success'] || !$status['isReady']) {
        echo "⚠️  WhatsApp no está listo. Estado: " . ($status['status'] ?? 'desconocido') . "\n";
        echo "Simulando envío...\n";
    } else {
        echo "📤 Enviando mensaje de bienvenida...\n";
        $result = $whatsappService->sendMessage($testUser->telefono, $message);
        
        if ($result['success']) {
            echo "✅ Mensaje de bienvenida enviado exitosamente\n";
            if (isset($result['simulated']) && $result['simulated']) {
                echo "   (Modo simulado - API externa no disponible)\n";
            }
        } else {
            echo "❌ Error enviando mensaje: " . $result['error'] . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}