<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔍 Diagnosticando envío para +584242115948...\n\n";

$phoneNumber = '+584242115948';

try {
    // 1. Probar formateo del número
    function formatPhoneNumber($phoneNumber) {
        $empresa = \App\Models\Empresa::where('status', 1)->first();
        if (!$empresa || !$empresa->pais) {
            return $phoneNumber;
        }

        $pais = $empresa->pais;
        $codigoPais = $pais->codigo_telefonico ?? '+58';
        $codigoLimpio = str_replace('+', '', $codigoPais);
        $cleanNumber = preg_replace('/[\s\-\(\)\+]/', '', $phoneNumber);
        
        if (substr($cleanNumber, 0, strlen($codigoLimpio)) === $codigoLimpio) {
            return $cleanNumber;
        }
        
        if (substr($cleanNumber, 0, 1) === '0') {
            $cleanNumber = substr($cleanNumber, 1);
        }
        
        return $codigoLimpio . $cleanNumber;
    }
    
    $formattedNumber = formatPhoneNumber($phoneNumber);
    echo "1. Número original: {$phoneNumber}\n";
    echo "   Número formateado: {$formattedNumber}\n\n";
    
    // 2. Verificar estado de WhatsApp
    echo "2. Verificando estado de WhatsApp...\n";
    $whatsappService = new \App\Services\WhatsAppService();
    $status = $whatsappService->getStatus();
    
    echo "   Estado: " . ($status['success'] ? 'Conectado' : 'Desconectado') . "\n";
    if (isset($status['isReady'])) {
        echo "   Listo: " . ($status['isReady'] ? 'Sí' : 'No') . "\n";
    }
    if (isset($status['status'])) {
        echo "   Estado WhatsApp: " . $status['status'] . "\n";
    }
    echo "\n";
    
    // 3. Probar envío directo
    echo "3. Probando envío directo...\n";
    $testMessage = "🧪 Mensaje de prueba para diagnóstico\nNúmero: {$phoneNumber}\nFormateado: {$formattedNumber}";
    
    $result = $whatsappService->sendMessage($formattedNumber, $testMessage);
    
    if ($result['success']) {
        echo "   ✅ Mensaje enviado exitosamente\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "   ⚠️  Modo simulado (API no disponible)\n";
        }
        if (isset($result['jwt_authenticated'])) {
            echo "   🔐 JWT: " . ($result['jwt_authenticated'] ? 'Autenticado' : 'No autenticado') . "\n";
        }
    } else {
        echo "   ❌ Error: " . $result['error'] . "\n";
    }
    echo "\n";
    
    // 4. Verificar logs
    echo "4. Verificando logs recientes...\n";
    $logFile = storage_path('logs/laravel.log');
    if (file_exists($logFile)) {
        $logs = file_get_contents($logFile);
        $recentLogs = array_slice(explode("\n", $logs), -20);
        
        $whatsappLogs = array_filter($recentLogs, function($line) {
            return strpos($line, 'WhatsApp') !== false || strpos($line, 'SendWelcome') !== false;
        });
        
        if (!empty($whatsappLogs)) {
            echo "   Logs relacionados con WhatsApp:\n";
            foreach ($whatsappLogs as $log) {
                echo "   " . trim($log) . "\n";
            }
        } else {
            echo "   No se encontraron logs recientes de WhatsApp\n";
        }
    } else {
        echo "   Archivo de log no encontrado\n";
    }
    echo "\n";
    
    // 5. Verificar Jobs en cola
    echo "5. Información sobre Jobs:\n";
    echo "   Para verificar si el Job se ejecutó, revisa:\n";
    echo "   - php artisan queue:work (para procesar jobs)\n";
    echo "   - Logs de Laravel para errores del Job\n";
    
} catch (Exception $e) {
    echo "❌ Error durante diagnóstico: " . $e->getMessage() . "\n";
}