<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "👤 Probando registro con formateo de teléfono...\n\n";

// Función de formateo (copiada del componente)
function formatPhoneNumber($phoneNumber) {
    // Obtener empresa activa y su país
    $empresa = \App\Models\Empresa::where('status', 1)->first();
    if (!$empresa || !$empresa->pais) {
        return $phoneNumber; // Retornar sin cambios si no hay empresa o país
    }

    $pais = $empresa->pais;
    $codigoPais = $pais->codigo_telefonico ?? '+58'; // Default Venezuela
    
    // Remover el símbolo + del código de país para comparaciones
    $codigoLimpio = str_replace('+', '', $codigoPais);
    
    // Limpiar el número (remover espacios, guiones, paréntesis, +)
    $cleanNumber = preg_replace('/[\s\-\(\)\+]/', '', $phoneNumber);
    
    // Si el número ya tiene el código de país, devolverlo
    if (substr($cleanNumber, 0, strlen($codigoLimpio)) === $codigoLimpio) {
        return $cleanNumber;
    }
    
    // Si empieza con 0, removerlo (formato local)
    if (substr($cleanNumber, 0, 1) === '0') {
        $cleanNumber = substr($cleanNumber, 1);
    }
    
    // Agregar código de país (sin el símbolo +)
    return $codigoLimpio . $cleanNumber;
}

try {
    // Simular datos de registro
    $telefonoOriginal = '0424-123-4567';
    $telefonoFormateado = formatPhoneNumber($telefonoOriginal);
    
    echo "Teléfono original: {$telefonoOriginal}\n";
    echo "Teléfono formateado: {$telefonoFormateado}\n\n";
    
    // Probar el servicio de WhatsApp con el número formateado
    $whatsappService = new \App\Services\WhatsAppService();
    
    $message = "🎉 *¡Bienvenido a nuestra tienda!* 🎉\n\n";
    $message .= "*Hola Usuario de Prueba!*\n\n";
    $message .= "Tu número fue formateado correctamente de {$telefonoOriginal} a {$telefonoFormateado}\n\n";
    $message .= "Gracias por registrarte en nuestra plataforma.";
    
    echo "Enviando mensaje de prueba...\n";
    $result = $whatsappService->sendMessage($telefonoFormateado, $message);
    
    if ($result['success']) {
        echo "✅ Mensaje enviado exitosamente\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "   (Modo simulado - API externa no disponible)\n";
        }
    } else {
        echo "❌ Error enviando mensaje: " . $result['error'] . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}