<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "📞 Probando formateo de números de teléfono...\n\n";

// Función de formateo (copiada del componente)
function formatPhoneNumber($phoneNumber) {
    // Obtener empresa activa y su país
    $empresa = \App\Models\Empresa::where('status', 1)->first();
    if (!$empresa || !$empresa->pais) {
        return $phoneNumber; // Retornar sin cambios si no hay empresa o país
    }

    $pais = $empresa->pais;
    $codigoPais = $pais->codigo_telefonico ?? '+58'; // Default Venezuela
    
    // Remover el símbolo + del código de país para comparaciones
    $codigoLimpio = str_replace('+', '', $codigoPais);
    
    // Limpiar el número (remover espacios, guiones, paréntesis, +)
    $cleanNumber = preg_replace('/[\s\-\(\)\+]/', '', $phoneNumber);
    
    // Si el número ya tiene el código de país, devolverlo
    if (substr($cleanNumber, 0, strlen($codigoLimpio)) === $codigoLimpio) {
        return $cleanNumber;
    }
    
    // Si empieza con 0, removerlo (formato local)
    if (substr($cleanNumber, 0, 1) === '0') {
        $cleanNumber = substr($cleanNumber, 1);
    }
    
    // Agregar código de país (sin el símbolo +)
    return $codigoLimpio . $cleanNumber;
}

// Obtener información de la empresa y país
$empresa = \App\Models\Empresa::where('status', 1)->first();
if ($empresa && $empresa->pais) {
    echo "Empresa: {$empresa->name}\n";
    echo "País: {$empresa->pais->nombre}\n";
    echo "Código telefónico: {$empresa->pais->codigo_telefonico}\n\n";
} else {
    echo "⚠️  No se encontró empresa activa o país configurado\n\n";
}

// Casos de prueba
$testNumbers = [
    '04241234567',      // Formato local venezolano
    '0424-123-4567',    // Con guiones
    '0424 123 4567',    // Con espacios
    '(0424) 123-4567',  // Con paréntesis
    '584241234567',     // Ya con código de país
    '+584241234567',    // Con símbolo +
    '4241234567',       // Sin 0 inicial
];

echo "Probando diferentes formatos de números:\n";
echo "========================================\n";

foreach ($testNumbers as $number) {
    $formatted = formatPhoneNumber($number);
    echo "Original: {$number} → Formateado: {$formatted}\n";
}

echo "\n✅ Prueba completada\n";