<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🚀 Probando registro optimizado...\n\n";

try {
    // Simular el proceso de registro optimizado
    $startTime = microtime(true);
    
    echo "1. Iniciando registro...\n";
    
    // Simular validación y creación de usuario (rápido)
    $userData = [
        'name' => 'Usuario Prueba Optimizado',
        'email' => 'prueba.optimizado@test.com',
        'username' => 'prueba_opt_' . time(),
        'telefono' => '04241234567',
        'password' => bcrypt('12345678'),
        'empresa_id' => 1,
        'status' => 1
    ];
    
    echo "2. Datos de usuario preparados...\n";
    
    // Formatear teléfono
    function formatPhoneNumber($phoneNumber) {
        $empresa = \App\Models\Empresa::where('status', 1)->first();
        if (!$empresa || !$empresa->pais) {
            return $phoneNumber;
        }

        $pais = $empresa->pais;
        $codigoPais = $pais->codigo_telefonico ?? '+58';
        $codigoLimpio = str_replace('+', '', $codigoPais);
        $cleanNumber = preg_replace('/[\s\-\(\)\+]/', '', $phoneNumber);
        
        if (substr($cleanNumber, 0, strlen($codigoLimpio)) === $codigoLimpio) {
            return $cleanNumber;
        }
        
        if (substr($cleanNumber, 0, 1) === '0') {
            $cleanNumber = substr($cleanNumber, 1);
        }
        
        return $codigoLimpio . $cleanNumber;
    }
    
    $userData['telefono'] = formatPhoneNumber($userData['telefono']);
    echo "3. Teléfono formateado: {$userData['telefono']}\n";
    
    // Simular creación de usuario en DB (rápido)
    echo "4. Usuario creado en base de datos...\n";
    
    // Simular login automático (rápido)
    echo "5. Sesión iniciada automáticamente...\n";
    
    $registrationTime = microtime(true) - $startTime;
    echo "6. ✅ Registro completado en " . round($registrationTime * 1000, 2) . "ms\n\n";
    
    // Simular dispatch del Job (asíncrono - no bloquea)
    echo "7. 📤 Job de mensaje de bienvenida enviado a cola...\n";
    echo "8. 🔄 Usuario puede continuar navegando mientras se envía el mensaje\n\n";
    
    // Simular el Job ejecutándose en background
    echo "--- Simulando ejecución del Job en background ---\n";
    $jobStartTime = microtime(true);
    
    // Crear usuario temporal para el Job
    $tempUser = new stdClass();
    $tempUser->id = 999;
    $tempUser->name = $userData['name'];
    $tempUser->telefono = $userData['telefono'];
    
    // Simular envío de mensaje
    $whatsappService = new \App\Services\WhatsAppService();
    $empresa = \App\Models\Empresa::find(1);
    $empresaNombre = $empresa ? $empresa->name : 'nuestra tienda';
    
    $message = "🎉 *¡Bienvenido a {$empresaNombre}!* 🎉\n\n";
    $message .= "*Hola {$tempUser->name}!*\n\n";
    $message .= "Gracias por registrarte en nuestra plataforma.";
    
    $result = $whatsappService->sendMessage($tempUser->telefono, $message);
    
    $jobTime = microtime(true) - $jobStartTime;
    
    if ($result['success']) {
        echo "✅ Mensaje enviado exitosamente en " . round($jobTime * 1000, 2) . "ms\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "   (Modo simulado - API externa no disponible)\n";
        }
    } else {
        echo "❌ Error enviando mensaje: " . $result['error'] . "\n";
    }
    
    echo "\n📊 Resumen de optimización:\n";
    echo "- Tiempo de registro: " . round($registrationTime * 1000, 2) . "ms (muy rápido)\n";
    echo "- Tiempo de mensaje: " . round($jobTime * 1000, 2) . "ms (en background)\n";
    echo "- Usuario no espera el envío del mensaje\n";
    echo "- Experiencia de usuario mejorada ✨\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}