<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔐 Probando verificación JWT...\n\n";

// Leer el token del archivo de configuración
$configFile = 'whatsapp-service-config.env';
$token = null;

if (file_exists($configFile)) {
    $lines = file($configFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, 'LARAVEL_API_KEY=') === 0) {
            $token = trim(substr($line, strlen('LARAVEL_API_KEY=')));
            break;
        }
    }
}

if (!$token) {
    echo "❌ No se encontró token en el archivo de configuración\n";
    exit(1);
}

echo "Token encontrado: " . substr($token, 0, 50) . "...\n\n";

// Probar la verificación usando cURL
$url = 'http://localhost:8000/api/verify-token';

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer ' . $token,
        'Accept: application/json',
        'Content-Type: application/json'
    ],
    CURLOPT_TIMEOUT => 10,
]);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo "❌ Error de conexión: {$err}\n";
    exit(1);
}

echo "Código HTTP: {$httpCode}\n";
echo "Respuesta: {$response}\n\n";

$decodedResponse = json_decode($response, true);

if ($httpCode === 200 && isset($decodedResponse['message']) && $decodedResponse['message'] === 'Token válido') {
    echo "✅ Verificación JWT exitosa!\n";
    echo "Usuario: " . $decodedResponse['user']['name'] . "\n";
    echo "Email: " . $decodedResponse['user']['email'] . "\n";
} else {
    echo "❌ Verificación JWT falló\n";
    if (isset($decodedResponse['error'])) {
        echo "Error: " . $decodedResponse['error'] . "\n";
    }
}