<?php

$apiUrl = 'http://localhost:3000';
$postData = [
    'phone' => '+584242115948',
    'message' => 'Test message'
];

echo "🧪 Probando parsing JSON...\n\n";

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $apiUrl . '/api/test-json',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($postData),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_TIMEOUT => 10
]);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$error = curl_error($curl);

curl_close($curl);

echo "HTTP Code: {$httpCode}\n";
echo "Error: " . ($error ?: 'Ninguno') . "\n";
echo "Respuesta: {$response}\n";

if ($response) {
    $decoded = json_decode($response, true);
    if ($decoded) {
        echo "\nRespuesta decodificada:\n";
        print_r($decoded);
    }
}