<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🚀 PROBANDO MEJORAS DEL FRONT\n";
echo "=============================\n\n";

// 1. Verificar migración de reseñas
echo "1. 📊 SISTEMA DE RESEÑAS:\n";
echo "   ----------------------\n";

$migrationFile = 'database/migrations/2025_11_26_220850_create_product_reviews_table.php';
if (file_exists($migrationFile)) {
    echo "   ✅ Migración de reseñas creada\n";
    
    // Verificar estructura de la migración
    $content = file_get_contents($migrationFile);
    $features = [
        'rating' => strpos($content, 'rating') !== false,
        'comment' => strpos($content, 'comment') !== false,
        'verified_purchase' => strpos($content, 'verified_purchase') !== false,
        'is_approved' => strpos($content, 'is_approved') !== false
    ];
    
    foreach ($features as $feature => $exists) {
        echo "   " . ($exists ? '✅' : '❌') . " Campo {$feature}\n";
    }
} else {
    echo "   ❌ Migración no encontrada\n";
}

echo "\n";

// 2. Verificar mejoras en el componente
echo "2. 🛒 CARRITO PERSISTENTE:\n";
echo "   ----------------------\n";

$indexFile = file_get_contents('app/Livewire/Front/Index.php');

$cart_features = [
    'cartCount property' => strpos($indexFile, '$cartCount') !== false,
    'updateCartCount method' => strpos($indexFile, 'updateCartCount') !== false,
    'Cart count in mount' => strpos($indexFile, 'updateCartCount()') !== false
];

foreach ($cart_features as $feature => $exists) {
    echo "   " . ($exists ? '✅' : '❌') . " {$feature}\n";
}

echo "\n";

// 3. Verificar búsqueda mejorada
echo "3. 🔍 BÚSQUEDA MEJORADA:\n";
echo "   --------------------\n";

$search_features = [
    'Búsqueda en productos' => strpos($indexFile, 'productos') !== false,
    'Búsqueda en categorías' => strpos($indexFile, 'categorias') !== false,
    'Tipos de sugerencias' => strpos($indexFile, 'type') !== false,
    'Límite de resultados' => strpos($indexFile, 'limit(3)') !== false
];

foreach ($search_features as $feature => $exists) {
    echo "   " . ($exists ? '✅' : '❌') . " {$feature}\n";
}

echo "\n";

// 4. Verificar filtros con contadores
echo "4. 📊 FILTROS CON CONTADORES:\n";
echo "   --------------------------\n";

$filter_features = [
    'getCategoriasWithCount' => strpos($indexFile, 'getCategoriasWithCount') !== false,
    'getMarcasWithCount' => strpos($indexFile, 'getMarcasWithCount') !== false,
    'withCount query' => strpos($indexFile, 'withCount') !== false,
    'productos_count filter' => strpos($indexFile, 'productos_count') !== false
];

foreach ($filter_features as $feature => $exists) {
    echo "   " . ($exists ? '✅' : '❌') . " {$feature}\n";
}

echo "\n";

// 5. Verificar mini carrito
echo "5. 🛒 MINI CARRITO FLOTANTE:\n";
echo "   -------------------------\n";

$miniCartFile = 'resources/views/livewire/front/mini-cart.blade.php';
$modalsFile = 'resources/views/livewire/front/modals.blade.php';

if (file_exists($miniCartFile)) {
    echo "   ✅ Archivo mini-cart.blade.php creado\n";
    
    $miniCartContent = file_get_contents($miniCartFile);
    $mini_features = [
        'Botón flotante' => strpos($miniCartContent, 'position-fixed') !== false,
        'Contador de items' => strpos($miniCartContent, 'cartCount') !== false,
        'Offcanvas' => strpos($miniCartContent, 'offcanvas') !== false,
        'Lista de productos' => strpos($miniCartContent, 'cartItems') !== false,
        'Total del carrito' => strpos($miniCartContent, 'getTotal') !== false
    ];
    
    foreach ($mini_features as $feature => $exists) {
        echo "   " . ($exists ? '✅' : '❌') . " {$feature}\n";
    }
    
    // Verificar inclusión en modals
    $modalsContent = file_get_contents($modalsFile);
    $included = strpos($modalsContent, 'mini-cart') !== false;
    echo "   " . ($included ? '✅' : '❌') . " Incluido en modals.blade.php\n";
    
} else {
    echo "   ❌ Archivo mini-cart.blade.php no encontrado\n";
}

echo "\n";

// 6. Verificar validación mejorada
echo "6. 📱 VALIDACIÓN MEJORADA:\n";
echo "   -----------------------\n";

$validation_features = [
    'isValidPhoneNumber method' => strpos($indexFile, 'isValidPhoneNumber') !== false,
    'Custom validation rule' => strpos($indexFile, 'function($attribute') !== false,
    'Venezuela regex' => strpos($indexFile, '[24]\\d{9}') !== false,
    'Generic validation' => strpos($indexFile, 'strlen($cleanNumber)') !== false
];

foreach ($validation_features as $feature => $exists) {
    echo "   " . ($exists ? '✅' : '❌') . " {$feature}\n";
}

echo "\n";

// 7. Resumen de mejoras
echo "📈 RESUMEN DE MEJORAS IMPLEMENTADAS:\n";
echo "===================================\n";

$total_improvements = 0;
$implemented_improvements = 0;

$all_features = array_merge($cart_features, $search_features, $filter_features, $validation_features);

foreach ($all_features as $feature => $exists) {
    $total_improvements++;
    if ($exists) $implemented_improvements++;
}

$completion_rate = ($implemented_improvements / $total_improvements) * 100;

echo "• Mejoras implementadas: {$implemented_improvements}/{$total_improvements} (" . round($completion_rate) . "%)\n";
echo "• Sistema de reseñas: " . (file_exists($migrationFile) ? '✅ Preparado' : '❌ Pendiente') . "\n";
echo "• Mini carrito: " . (file_exists($miniCartFile) ? '✅ Implementado' : '❌ Pendiente') . "\n";
echo "• Estado general: " . ($completion_rate >= 80 ? '🟢 EXCELENTE' : ($completion_rate >= 60 ? '🟡 BUENO' : '🔴 NECESITA TRABAJO')) . "\n";

echo "\n🎯 PRÓXIMOS PASOS:\n";
echo "==================\n";
echo "1. 🗄️  Ejecutar migración: php artisan migrate\n";
echo "2. 🎨 Actualizar vista con contadores en filtros\n";
echo "3. ⭐ Implementar componente de reseñas\n";
echo "4. 🔄 Añadir productos relacionados\n";
echo "5. 🌙 Implementar modo oscuro\n";

echo "\n=============================\n";