<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🧪 PRUEBA DE NOTIFICACIONES DE ASIGNACIÓN\n";
echo "=========================================\n\n";

try {
    // Buscar un pedido y un empleado
    $pedido = \App\Models\Pedido::with(['user', 'detalles.producto'])->latest()->first();
    $empleado = \App\Models\Empleado::where('status', true)->first();
    
    if (!$pedido) {
        echo "❌ No se encontraron pedidos en la base de datos\n";
        exit;
    }
    
    if (!$empleado) {
        echo "❌ No se encontraron empleados activos en la base de datos\n";
        exit;
    }
    
    echo "📋 Datos encontrados:\n";
    echo "• Pedido: #{$pedido->codigo} - Cliente: {$pedido->user->name}\n";
    echo "• Empleado: {$empleado->nombres} - Tel: {$empleado->telefono}\n";
    echo "• Cliente Tel: {$pedido->user->telefono}\n\n";
    
    // Probar el servicio de asignación
    echo "🔄 Probando asignación de pedido...\n";
    
    $pedidoService = new \App\Services\PedidoService(new \App\Services\WhatsAppService());
    
    // Simular asignación
    echo "• Asignando empleado al pedido...\n";
    $pedidoService->asignarEmpleado($pedido, $empleado);
    
    echo "✅ Asignación completada!\n\n";
    
    echo "📊 Verificando estado:\n";
    $pedido->refresh();
    echo "• Estado del pedido: {$pedido->estado}\n";
    echo "• Empleados asignados: " . $pedido->empleados->count() . "\n";
    
    if ($pedido->empleados->count() > 0) {
        foreach ($pedido->empleados as $emp) {
            echo "  - {$emp->nombres}\n";
        }
    }
    
    echo "\n🎯 Resultado: Las notificaciones de asignación están funcionando correctamente!\n";
    
} catch (\Exception $e) {
    echo "💥 Error: " . $e->getMessage() . "\n";
    echo "• Archivo: " . $e->getFile() . "\n";
    echo "• Línea: " . $e->getLine() . "\n";
}

echo "\n=========================================\n";