# WhatsApp Business Integration

## Configuración

### 1. Configurar la API de WhatsApp

1. Navega al directorio `whatsapp-api/`
2. Instala las dependencias:
   ```bash
   cd whatsapp-api
   npm install
   ```

3. Configura el archivo `.env`:
   ```env
   PORT=3000
   NODE_ENV=development
   ALLOWED_ORIGINS=http://localhost:8000,http://127.0.0.1:8000
   ```

4. Inicia el servidor:
   ```bash
   npm start
   ```

### 2. Configurar Laravel

1. Agrega la URL de la API en tu archivo `.env`:
   ```env
   WHATSAPP_API_URL=http://localhost:3000/api/whatsapp
   ```

2. Ejecuta las migraciones si es necesario:
   ```bash
   php artisan migrate
   ```

## Uso de la Interfaz

### Acceso
- Ve a `/admin/whatsapp` en tu aplicación Laravel
- Necesitas estar autenticado como administrador

### Funcionalidades

#### 1. Conexión
- Al acceder por primera vez, verás el estado "Desconectado"
- Haz clic en "Actualizar Estado" para verificar la conexión
- Si aparece un código QR, escanéalo con WhatsApp en tu teléfono
- Una vez conectado, el estado cambiará a "Conectado"

#### 2. Envío de Mensajes
- Ingresa el número de teléfono (formato: 584121234567)
- Escribe tu mensaje en el área de texto
- Presiona Enter o haz clic en el botón de enviar
- Los mensajes aparecerán en el área de chat

#### 3. Gestión de Sesión
- Usa "Cerrar Sesión" para desconectar WhatsApp
- Usa "Actualizar Estado" para verificar el estado actual

## API Endpoints

### Webhooks
- `POST /api/whatsapp/webhook` - Recibe eventos de WhatsApp
- `GET /api/whatsapp/status` - Obtiene el estado actual
- `POST /api/whatsapp/send` - Envía mensajes (requiere autenticación)

### Eventos Soportados
- `message` - Mensaje entrante
- `qr` - Código QR generado
- `ready` - WhatsApp listo
- `disconnected` - Desconectado

## Estructura de Archivos

```
app/
├── Livewire/Admin/WhatsAppChat.php          # Componente principal
├── Services/WhatsAppService.php             # Servicio de WhatsApp
└── Http/Controllers/Api/WhatsAppController.php # Controlador API

resources/views/livewire/admin/whats-app-chat.blade.php # Vista

public/css/whatsapp-chat.css                 # Estilos personalizados

whatsapp-api/                                # API Node.js
├── server.js                               # Servidor principal
├── routes/whatsapp.js                      # Rutas
└── services/WhatsAppService.js             # Servicio WhatsApp
```

## Personalización

### Estilos
- Modifica `public/css/whatsapp-chat.css` para cambiar la apariencia
- Los colores principales son:
  - Verde WhatsApp: `#25D366`
  - Verde oscuro: `#128C7E`

### Funcionalidades
- Extiende `WhatsAppService.php` para agregar más métodos
- Modifica `WhatsAppChat.php` para agregar más funcionalidades
- Usa los webhooks para procesar mensajes entrantes automáticamente

## Troubleshooting

### Problemas Comunes

1. **Error de conexión con la API**
   - Verifica que el servidor Node.js esté ejecutándose
   - Revisa la URL en `WHATSAPP_API_URL`

2. **QR no aparece**
   - Reinicia el servidor Node.js
   - Limpia las sesiones en `whatsapp-api/sessions/`

3. **Mensajes no se envían**
   - Verifica que WhatsApp esté conectado
   - Revisa los logs en `whatsapp-api/logs/`

### Logs
- Laravel: `storage/logs/laravel.log`
- WhatsApp API: `whatsapp-api/logs/combined.log`

## Seguridad

- Los webhooks están protegidos por rate limiting
- Las rutas de envío requieren autenticación
- Los logs no contienen información sensible
- Las sesiones se almacenan localmente

## Próximas Mejoras

- [ ] Historial de mensajes en base de datos
- [ ] Envío de archivos multimedia
- [ ] Plantillas de mensajes
- [ ] Respuestas automáticas
- [ ] Métricas y reportes
- [ ] Integración con CRM