<?php

require __DIR__.'/vendor/autoload.php';

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Services\WhatsAppService;
use App\Services\TemporaryTokenService;

echo "=== PRUEBA DE MENSAJE DE BIENVENIDA WHATSAPP SINCRÓNICO ===\n";

try {
    // Número de prueba
    $telefonoPrueba = '04242115948';
    $usernamePrueba = 'test_cliente_' . time();
    $emailPrueba = 'test_' . time() . '@ejemplo.com';
    
    echo "Creando cliente de prueba...\n";
    echo "Teléfono: $telefonoPrueba\n";
    echo "Usuario: $usernamePrueba\n";
    echo "Email: $emailPrueba\n\n";
    
    // Crear usuario de prueba
    $user = new User();
    $user->name = 'Cliente Prueba WhatsApp';
    $user->email = $emailPrueba;
    $user->username = $usernamePrueba;
    $user->telefono = $telefonoPrueba;
    $user->password = Hash::make('test123456');
    $user->empresa_id = 1;
    $user->sucursal_id = 1;
    $user->email_verified_at = now();
    $user->status = 1;
    $user->save();
    $user->assignRole('Cliente');
    
    echo "✅ Cliente creado exitosamente!\n";
    echo "ID: {$user->id}\n";
    echo "Nombre: {$user->name}\n";
    echo "Teléfono original: {$user->telefono}\n\n";
    
    // Probar el formateo de número
    $whatsappService = new WhatsAppService();
    $telefonoFormateado = $whatsappService->cleanPhoneNumber($user->telefono);
    
    echo "=== PROBANDO FORMATEO DE NÚMERO ===\n";
    echo "Teléfono original: {$user->telefono}\n";
    echo "Teléfono formateado: {$telefonoFormateado}\n\n";
    
    // Generar token temporal
    $credentialToken = TemporaryTokenService::generateCredentialToken(
        $user->id, $user->username, 'test123456'
    );
    
    echo "=== GENERANDO TOKEN ===\n";
    echo "Token generado: {$credentialToken}\n\n";
    
    // Crear mensaje de bienvenida
    $message = "🎉 *¡Bienvenido {$user->name}!*\n\n";
    $message .= "Gracias por registrarte en nuestro sistema de pedidos.\n\n";
    $message .= "📱 *Tus credenciales de acceso:*\n";
    $message .= "Usuario: {$user->username}\n";
    $message .= "Contraseña: test123456\n";
    $message .= "Token de acceso: {$credentialToken}\n\n";
    $message .= "Ingresa a nuestro sistema y realiza tus pedidos de manera fácil y rápida.\n\n";
    $message .= "¿Necesitas ayuda? No dudes en contactarnos.\n\n";
    $message .= "¡Bienvenido a bordo! 🚀";
    
    echo "=== MENSAJE A ENVIAR ===\n";
    echo $message . "\n\n";
    
    // Enviar mensaje
    echo "=== ENVIANDO MENSAJE ===\n";
    echo "Enviando mensaje a: {$telefonoFormateado}\n";
    $result = $whatsappService->sendMessage($telefonoFormateado, $message);
    
    if ($result && ($result['success'] || isset($result['simulated']))) {
        echo "✅ MENSAJE ENVIADO EXITOSAMENTE!\n";
        echo "Respuesta del servicio: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    } else {
        echo "❌ ERROR AL ENVIAR MENSAJE\n";
        echo "Respuesta: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    }
    
    // Limpiar usuario de prueba
    echo "\n=== LIMPIEZA ===\n";
    $user->delete();
    echo "✅ Usuario de prueba eliminado.\n";
    
} catch (Exception $e) {
    echo "❌ ERROR EN LA PRUEBA: " . $e->getMessage() . "\n";
    echo "Archivo: " . $e->getFile() . "\n";
    echo "Línea: " . $e->getLine() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== PRUEBA FINALIZADA ===\n";