<div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Cajas</h6>
                            <h2 class="mb-0"><?php echo e(number_format($this->stats['total'])); ?></h2>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class="ri-inbox-line  text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Cajas Abiertas</h6>
                            <h2 class="mb-0"><?php echo e(number_format($this->stats['abiertas'])); ?></h2>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="ri-inbox-unarchive-line  text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Cajas Cerradas</h6>
                            <h2 class="mb-0"><?php echo e(number_format($this->stats['cerradas'])); ?></h2>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="ri-lock-line  text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Ingresos Hoy</h6>
                            <h2 class="mb-0"><?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $this->stats['ingresos_hoy']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($this->stats['ingresos_hoy'])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?></h2>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="ri-money-dollar-circle-line  text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">Lista de Cajas</h5>
                            <p class="mb-0">Administra las cajas diarias del sistema</p>
                        </div>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create cajas')): ?>
                        <div>
                            <a href="<?php echo e(route('admin.cajas.create')); ?>" class="btn btn-primary">
                                <i class="ri-inbox-unarchive-line "></i> Abrir Caja
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Filtros -->
                <div class="card-header border-bottom">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Buscar</label>
                            <input type="text" class="form-control" placeholder="Fecha o usuario..."
                                   wire:model.live.debounce.300ms="search">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Estado</label>
                            <select class="form-select" wire:model.live="status">
                                <option value="">Todos los estados</option>
                                <option value="abierta">Abierta</option>
                                <option value="cerrada">Cerrada</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Mostrar</label>
                            <select class="form-select" wire:model.live="perPage">
                                <option value="10">10 por página</option>
                                <option value="25">25 por página</option>
                                <option value="50">50 por página</option>
                                <option value="100">100 por página</option>
                            </select>
                        </div>
                        <div class="col-md-3 d-flex align-items-end gap-2">
                            <button type="button" class="btn btn-label-secondary" wire:click="clearFilters">
                                <i class="ri-refresh-line "></i> Limpiar
                            </button>
                            <button type="button" class="btn btn-label-success" wire:click="export">
                                <i class="ri-download-line "></i> Exportar
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-datatable table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th wire:click="sortBy('fecha')" style="cursor: pointer;">
                                    Fecha
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'fecha'): ?>
                                        <i class=" ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </th>
                                <th>Usuario</th>
                                <th>Monto Inicial</th>
                                <th>Total Ingresos</th>
                                <th>Monto Final</th>
                                <th wire:click="sortBy('estado')" style="cursor: pointer;">
                                    Estado
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'estado'): ?>
                                        <i class=" ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $cajas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $caja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div><?php echo e(format_date($caja->fecha)); ?></div>
                                        <small class="text-muted"><?php echo e($caja->fecha_apertura->format('H:i')); ?></small>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm me-2">
                                                <span class="avatar-initial rounded bg-label-primary"><?php echo e(substr($caja->usuario->name ?? '', 0, 1)); ?></span>
                                            </div>
                                            <div>
                                                <h6 class="mb-0"><?php echo e($caja->usuario->name ?? ''); ?></h6>
                                                <small class="text-muted"><?php echo e($caja->usuario->email ?? ''); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo is_venezuela_company() ? '$' . number_format((float)($caja->monto_inicial), 2, '.', ',') : format_money($caja->monto_inicial, true); ?></td>
                                    <td>
                                        <div class="fw-semibold"><?php echo is_venezuela_company() ? '$' . number_format((float)($caja->total_ingresos), 2, '.', ',') : format_money($caja->total_ingresos, true); ?></div>
                                        <small class="text-muted d-inline">
                                            E: <?php echo is_venezuela_company() ? '$' . number_format((float)($caja->total_efectivo), 2, '.', ',') : format_money($caja->total_efectivo, true); ?> | T: <?php echo is_venezuela_company() ? '$' . number_format((float)($caja->total_transferencias), 2, '.', ',') : format_money($caja->total_transferencias, true); ?> | TC: <?php echo is_venezuela_company() ? '$' . number_format((float)($caja->total_tarjetas), 2, '.', ',') : format_money($caja->total_tarjetas, true); ?>
                                        </small>
                                    </td>
                                    <td><?php echo is_venezuela_company() ? '$' . number_format((float)($caja->monto_final), 2, '.', ',') : format_money($caja->monto_final, true); ?></td>
                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($caja->estado === 'abierta'): ?>
                                            <span class="badge bg-success">Abierta</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Cerrada</span>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($caja->fecha_cierre): ?>
                                                <small class="d-block text-muted"><?php echo e(format_datetime($caja->fecha_cierre, false)); ?></small>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                <i class=" ri-more-2-line"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view cajas')): ?>
                                                <a class="dropdown-item" href="<?php echo e(route('admin.cajas.show', $caja)); ?>">
                                                    <i class="ri-eye-line me-1"></i> Ver Detalle
                                                </a>
                                                <?php endif; ?>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($caja->estado === 'abierta'): ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit cajas')): ?>
                                                    <button type="button" class="dropdown-item"
                                                            wire:click="cerrarCaja(<?php echo e($caja->id); ?>)">
                                                        <i class="ri-lock-line me-1"></i> Cerrar Caja
                                                    </button>
                                                    <?php endif; ?>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">No se encontraron cajas que coincidan con los filtros</td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Paginación -->
                <div class="card-footer">
                   <?php echo e($cajas->links('livewire.pagination')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/cajas/index.blade.php ENDPATH**/ ?>