
<div>
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h4 class="fw-bold py-3 mb-0">Editar Producto</h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-style1">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('admin.productos.index')); ?>">Productos</a>
                            </li>
                            <li class="breadcrumb-item active">Editar</li>
                        </ol>
                    </nav>
                </div>
                <div>

                    <a href="<?php echo e(route('admin.productos.index')); ?>" class="btn btn-outline-secondary">
                        <i class="ri-arrow-left-line me-1"></i>
                        Volver
                    </a>
                </div>
            </div>
        </div>
    </div>

    <form wire:submit.prevent="update">
        <!-- Tabs de navegación -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <ul class="nav nav-pills" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if($activeTab == 'basic'): ?> active <?php endif; ?>"
                                        wire:click="changeTab('basic')" type="button">
                                    <i class="ri-information-line me-1"></i>
                                    Información Básica
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if($activeTab == 'media'): ?> active <?php endif; ?>"
                                        wire:click="changeTab('media')" type="button">
                                    <i class="ri-image-line me-1"></i>
                                    Imágenes
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if($activeTab == 'variants'): ?> active <?php endif; ?>"
                                        wire:click="changeTab('variants')" type="button">
                                    <i class="ri-palette-line me-1"></i>
                                    Variantes
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if($activeTab == 'inventory'): ?> active <?php endif; ?>"
                                        wire:click="changeTab('inventory')" type="button">
                                    <i class="ri-box-3-line me-1"></i>
                                    Inventario
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php if($activeTab == 'seo'): ?> active <?php endif; ?>"
                                        wire:click="changeTab('seo')" type="button">
                                    <i class="ri-search-eye-line me-1"></i>
                                    SEO
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contenido de las tabs -->
        <div class="row mt-4">
            <div class="col-12">


                <!-- Información Básica -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab == 'basic'): ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Información del Producto</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Código y SKU -->
                            <div class="col-md-4 mb-3">
                                <label class="form-label" for="code">Código del Producto *</label>
                                <div class="input-group">
                                    <input type="text" wire:model="code" id="code" class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <button type="button" wire:click="generateCode" class="btn btn-outline-secondary">
                                        <i class="ri-refresh-line"></i>
                                    </button>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label" for="sku">SKU</label>
                                <div class="input-group">
                                    <input type="text" wire:model="sku" id="sku" class="form-control <?php $__errorArgs = ['sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <button type="button" wire:click="generateSKU" class="btn btn-outline-secondary" title="Generar SKU automáticamente">
                                        <i class="ri-magic-line"></i>
                                    </button>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($has_variants && !empty($variants)): ?>
                                    <button type="button" wire:click="syncVariantSKUs" class="btn btn-outline-primary" title="Sincronizar SKU con variantes">
                                        <i class="ri-refresh-line"></i>
                                    </button>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($has_variants && !empty($variants)): ?>
                                <small class="text-muted">El SKU se sincronizará automáticamente con las variantes</small>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label" for="barcode">Código de Barras</label>
                                <input type="text" wire:model="barcode" id="barcode" class="form-control <?php $__errorArgs = ['barcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['barcode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Nombre -->
                            <div class="col-12 mb-3">
                                <label class="form-label" for="name">Nombre del Producto *</label>
                                <input type="text" wire:model="name" id="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Ingrese el nombre del producto">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Precio y Cantidad -->
                            <div class="col-md-3 mb-3">
                                <label class="form-label" for="price">Precio *</label>
                                <div class="input-group">
                                    <span class="input-group-text">$</span>
                                    <input type="number" wire:model="price" id="price" class="form-control <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" step="0.01" min="0">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <!-- Precio en Bolívares (solo para Venezuela) -->
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->esVenezuela): ?>
                            <div class="col-md-3 mb-3">
                                <label class="form-label" for="precio_bs">Precio en Bolívares</label>
                                <div class="input-group">
                                    <span class="input-group-text">Bs.</span>
                                    <input type="number" wire:model="precio_bs" id="precio_bs" class="form-control <?php $__errorArgs = ['precio_bs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" step="0.01" min="0">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['precio_bs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <div class="col-md-3 mb-3">
                                <label class="form-label" for="quantity">Cantidad en Stock *</label>
                                <input type="number" wire:model="quantity" id="quantity" class="form-control <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label class="form-label" for="quantity_alert">Alerta de Stock *</label>
                                <input type="number" wire:model="quantity_alert" id="quantity_alert" class="form-control <?php $__errorArgs = ['quantity_alert'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['quantity_alert'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label" for="weight">Peso (kg)</label>
                                <input type="number" wire:model="weight" id="weight" class="form-control <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" step="0.001" min="0">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Categoría y Marca -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label" for="categoria_id">Categoría *</label>
                                <select wire:model="categoria_id" id="categoria_id" class="form-select <?php $__errorArgs = ['categoria_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">Seleccione una categoría</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['categoria_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label" for="marca_id">Marca *</label>
                                <select wire:model="marca_id" id="marca_id" class="form-select <?php $__errorArgs = ['marca_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">Seleccione una marca</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $marca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($marca->id); ?>"><?php echo e($marca->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['marca_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Descripción -->
                            <div class="col-12 mb-3">
                                <label class="form-label" for="description">Descripción</label>
                                <textarea wire:model="description" id="description" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4" placeholder="Ingrese la descripción del producto"></textarea>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Etiquetas -->
                            <div class="col-12 mb-3">
                                <label class="form-label" for="tags">Etiquetas</label>
                                <input type="text" wire:model="tags" id="tags" class="form-control <?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Ej: ropa, verano, casual (separadas por comas)">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Opciones -->
                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch mb-2">
                                    <input type="checkbox" wire:model="status" id="status" class="form-check-input">
                                    <label class="form-check-label" for="status">Producto Activo</label>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch mb-2">
                                    <input type="checkbox" wire:model="featured" id="featured" class="form-check-input">
                                    <label class="form-check-label" for="featured">Producto Destacado</label>
                                </div>
                            </div>

                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch mb-2">
                                    <input type="checkbox" wire:model="has_variants" id="has_variants" class="form-check-input">
                                    <label class="form-check-label" for="has_variants">Tiene Variantes</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- Imágenes -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab == 'media'): ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Imágenes del Producto</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="dropzone border-2 border-dashed rounded p-4 text-center"
                                     x-data="{
                                         uploading: false,
                                         progress: 0
                                     }"
                                     @dragover.prevent
                                     @drop.prevent="$wire.images = Array.from($event.dataTransfer.files)">

                                    <div x-show="!uploading">
                                        <i class="ri-upload-cloud-2-line text-primary ri-3x mb-3"></i>
                                        <h6>Arrastra las imágenes aquí o haz clic para seleccionar</h6>
                                        <p class="text-muted">Formatos permitidos: JPG, PNG, GIF. Tamaño máximo: 2MB por imagen.</p>
                                        <input type="file" wire:model="images" multiple accept="image/*" class="d-none" id="image-input">
                                        <button type="button" onclick="document.getElementById('image-input').click()" class="btn btn-primary">
                                            <i class="ri-image-add-line me-1"></i>
                                            Seleccionar Imágenes
                                        </button>
                                    </div>

                                    <div x-show="uploading">
                                        <div class="spinner-border text-primary mb-3" role="status">
                                            <span class="visually-hidden">Cargando...</span>
                                        </div>
                                        <h6>Cargando imágenes...</h6>
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" :style="`width: ${progress}%`"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Vista previa de imágenes -->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($images) || !empty($existingImages)): ?>
                        <div class="row mt-4">
                            <div class="col-12">
                                <h6 class="mb-3">Imágenes seleccionadas:</h6>

                                <!-- Imágenes existentes -->
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($existingImages)): ?>
                                <div class="row mb-4">
                                    <div class="col-12">
                                        <h6 class="mb-3">Imágenes actuales:</h6>
                                        <div class="row">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $existingImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-3 mb-3">
                                                <div class="position-relative">
                                                    <img src="<?php echo e(Storage::url($image['thumbnail_path'] ?? $image['path'])); ?>" alt="<?php echo e($image['alt_text'] ?? 'Producto'); ?>" class="img-thumbnail w-100" style="height: 200px; object-fit: cover;">
                                                    <button type="button" wire:click="removeExistingImage(<?php echo e($image['id']); ?>)" class="btn btn-danger btn-sm position-absolute top-0 end-0">
                                                        <i class="ri-close-line"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <!-- Nuevas imágenes -->
                                <div class="row">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-3 mb-3">
                                        <div class="position-relative">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_object($image)): ?>
                                                <img src="<?php echo e($image->temporaryUrl()); ?>" alt="Preview" class="img-thumbnail w-100" style="height: 200px; object-fit: cover;">
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <button type="button" wire:click="removeImage(<?php echo e($index); ?>)" class="btn btn-danger btn-sm position-absolute top-0 end-0">
                                                <i class="ri-close-line"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="alert alert-danger mt-3">
                            <i class="ri-error-warning-line me-1"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- Variantes -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab == 'variants' && $has_variants): ?>
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Variantes del Producto</h5>
                        <button type="button" wire:click="addVariant" class="btn btn-primary btn-sm">
                            <i class="ri-add-line me-1"></i>
                            Agregar Variante
                        </button>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Nombre de la Variante</label>
                                        <select wire:model="variants.<?php echo e($index); ?>.name"
                                                wire:change="loadVariantOptions(<?php echo e($index); ?>, $event.target.value)"
                                                class="form-select <?php $__errorArgs = ['variants.' . $index . '.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Seleccione tipo</option>
                                            <optgroup label="Físico">
                                                <option value="size">📏 Tamaño</option>
                                                <option value="color">🎨 Color</option>
                                                <option value="material">🧵 Material</option>
                                                <option value="peso">⚖️ Peso</option>
                                                <option value="volumen">🥤 Volumen</option>
                                                <option value="dureza">💪 Dureza</option>
                                                <option value="textura">✋ Textura</option>
                                                <option value="resistencia">🛡️ Resistencia</option>
                                                <option value="longitud">📐 Longitud</option>
                                                <option value="ancho">↔️ Ancho</option>
                                                <option value="grosor">📏 Grosor</option>
                                                <option value="densidad">🧱 Densidad</option>
                                                <option value="flexibilidad">🤸 Flexibilidad</option>
                                                <option value="transparencia">🔍 Transparencia</option>
                                            </optgroup>
                                            <optgroup label="Sabor y Aroma">
                                                <option value="sabor">🍓 Sabor</option>
                                                <option value="concentracion">🧪 Concentración</option>
                                                <option value="temperatura">🌡️ Temperatura</option>
                                                <option value="ph">⚗️ pH</option>
                                                <option value="aroma">🌸 Aroma</option>
                                            </optgroup>
                                            <optgroup label="Tecnología">
                                                <option value="capacidad">💾 Capacidad</option>
                                                <option value="almacenamiento">💽 Almacenamiento</option>
                                                <option value="ram">🧠 Memoria RAM</option>
                                                <option value="potencia">⚡ Potencia</option>
                                                <option value="voltaje">🔌 Voltaje</option>
                                                <option value="frecuencia">📡 Frecuencia</option>
                                                <option value="conectividad">📶 Conectividad</option>
                                                <option value="compatibilidad">🔗 Compatibilidad</option>
                                                <option value="pantalla">📱 Pantalla</option>
                                                <option value="bateria">🔋 Batería</option>
                                                <option value="camara">📷 Cámara</option>
                                                <option value="procesador">🖥️ Procesador</option>
                                                <option value="velocidad">⚡ Velocidad</option>
                                                <option value="red">📡 Red</option>
                                                <option value="sensor">🔍 Sensor</option>
                                                <option value="carga">🔌 Carga</option>
                                                <option value="resistencia_agua">💧 Resistencia al Agua</option>
                                            </optgroup>
                                            <optgroup label="Demográfico">
                                                <option value="edad">👶 Edad</option>
                                                <option value="genero">👤 Género</option>
                                                <option value="temporada">🌸 Temporada</option>
                                                <option value="publico">👥 Público</option>
                                                <option value="nivel">📊 Nivel</option>
                                                <option value="dificultad">🎯 Dificultad</option>
                                                <option value="categoria_edad">🔞 Categoría Edad</option>
                                                <option value="idioma">🗣️ Idioma</option>
                                            </optgroup>
                                            <optgroup label="Calidad y Tipo">
                                                <option value="tipo">⭐ Tipo</option>
                                                <option value="formato">📦 Formato</option>
                                                <option value="origen">🌍 Origen</option>
                                                <option value="certificacion">✅ Certificación</option>
                                                <option value="modelo">🏷️ Modelo</option>
                                                <option value="acabado">✨ Acabado</option>
                                                <option value="forma">🔷 Forma</option>
                                                <option value="estilo">🎨 Estilo</option>
                                                <option value="uso">👔 Uso</option>
                                                <option value="ocasion">🎉 Ocasión</option>
                                            </optgroup>
                                            <optgroup label="Especificaciones">
                                                <option value="eficiencia">⚡ Eficiencia</option>
                                                <option value="consumo">📊 Consumo</option>
                                                <option value="ruido">🔇 Ruido</option>
                                                <option value="garantia">🛡️ Garantía</option>
                                                <option value="instalacion">🔧 Instalación</option>
                                                <option value="mantenimiento">🛠️ Mantenimiento</option>
                                                <option value="aplicacion">🏠 Aplicación</option>
                                                <option value="clima">🌤️ Clima</option>
                                            </optgroup>
                                            <optgroup label="Presentación">
                                                <option value="presentacion">📦 Presentación</option>
                                                <option value="unidades">🔢 Unidades</option>
                                                <option value="medida">📏 Medida</option>
                                            </optgroup>
                                        </select>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['variants.' . $index . '.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">SKU</label>
                                        <input type="text" wire:model="variants.<?php echo e($index); ?>.sku" class="form-control <?php $__errorArgs = ['variants.' . $index . '.sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['variants.' . $index . '.sku'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Precio USD</label>
                                        <div class="input-group">
                                            <span class="input-group-text">$</span>
                                            <input type="number" wire:model="variants.<?php echo e($index); ?>.price_adjustment" class="form-control <?php $__errorArgs = ['variants.' . $index . '.price_adjustment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" step="0.01" min="0">
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['variants.' . $index . '.price_adjustment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->esVenezuela): ?>
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Precio Bs.</label>
                                        <div class="input-group">
                                            <span class="input-group-text">Bs.</span>
                                            <input type="number" wire:model="variants.<?php echo e($index); ?>.precio_bs" class="form-control <?php $__errorArgs = ['variants.' . $index . '.precio_bs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" step="0.01" min="0">
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['variants.' . $index . '.precio_bs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <div class="col-md-2 mb-3">
                                        <label class="form-label">Cantidad</label>
                                        <input type="number" wire:model="variants.<?php echo e($index); ?>.quantity" class="form-control <?php $__errorArgs = ['variants.' . $index . '.quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="0">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['variants.' . $index . '.quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="col-md-1 mb-3">
                                        <label class="form-label">&nbsp;</label>
                                        <button type="button" wire:click="removeVariant(<?php echo e($index); ?>)" class="btn btn-danger w-100">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </div>
                                </div>

                                <!-- Imagen de la variante -->
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Imagen de la Variante</label>
                                        <div class="d-flex align-items-center">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($variant['image_path']) && $variant['image_path']): ?>
                                                <div class="me-3">
                                                    <img src="<?php echo e(Storage::url($variant['image_path'])); ?>" alt="<?php echo e($variant['alt_text'] ?? 'Variante'); ?>" class="img-thumbnail" style="width: 80px; height: 80px; object-fit: cover;">
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <div class="flex-grow-1">
                                                <input type="file" wire:model="variantImages.<?php echo e($index); ?>" class="form-control" accept="image/*">
                                                <small class="text-muted">Formatos: JPG, PNG, GIF. Máx: 2MB</small>
                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($variant['image_path']) && $variant['image_path']): ?>
                                                <button type="button" wire:click="removeVariantImage(<?php echo e($index); ?>)" class="btn btn-outline-danger btn-sm ms-2">
                                                    <i class="ri-image-2-line"></i>
                                                </button>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Texto Alternativo (Alt)</label>
                                        <input type="text" wire:model="variants.<?php echo e($index); ?>.alt_text" class="form-control" placeholder="Descripción de la imagen">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <label class="form-label mb-0">Valores</label>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($variant['name']) && isset($variantOptions[$variant['name']])): ?>
                                            <small class="text-muted">
                                                <i class="ri-information-line me-1"></i>
                                                Valores disponibles para <?php echo e(ucfirst($variant['name'])); ?>:
                                                <?php echo e(implode(', ', array_slice($variantOptions[$variant['name']], 0, 3))); ?>...
                                            </small>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($variant['name']) && isset($variantOptions[$variant['name']])): ?>
                                        <div class="mb-3">
                                            <label class="form-label text-muted small">Seleccionar valores predefinidos:</label>
                                            <div class="d-flex flex-wrap gap-1">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $variantOptions[$variant['name']]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $predefinedValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <button type="button"
                                                        onclick="addPredefinedValue(<?php echo e($index); ?>, '<?php echo e($predefinedValue); ?>')"
                                                        class="btn btn-outline-secondary btn-sm">
                                                    <?php echo e($predefinedValue); ?>

                                                </button>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $variant['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $valueIndex => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="input-group mb-2">
                                            <input type="text" wire:model="variants.<?php echo e($index); ?>.values.<?php echo e($valueIndex); ?>" class="form-control" placeholder="Valor (ej: 50ml, 100ml)">
                                            <button type="button" wire:click="removeVariantValue(<?php echo e($index); ?>, <?php echo e($valueIndex); ?>)" class="btn btn-outline-danger">
                                                <i class="ri-subtract-line"></i>
                                            </button>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <button type="button" wire:click="addVariantValue(<?php echo e($index); ?>)" class="btn btn-outline-primary btn-sm">
                                            <i class="ri-add-line me-1"></i>
                                            Agregar Valor Personalizado
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(empty($variants)): ?>
                        <div class="text-center py-4">
                            <i class="ri-palette-line text-muted ri-3x mb-3"></i>
                            <p class="text-muted">No hay variantes configuradas</p>
                            <button type="button" wire:click="addVariant" class="btn btn-primary">
                                <i class="ri-add-line me-1"></i>
                                Agregar Primera Variante
                            </button>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- Inventario -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab == 'inventory'): ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Configuración de Inventario</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" wire:model="track_inventory" id="track_inventory" class="form-check-input">
                                    <label class="form-check-label" for="track_inventory">Rastrear Inventario</label>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch mb-3">
                                    <input type="checkbox" wire:model="allow_backorder" id="allow_backorder" class="form-check-input">
                                    <label class="form-check-label" for="allow_backorder">Permitir Pedidos sin Stock</label>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label" for="inventory_policy">Política de Inventario</label>
                                <select wire:model="inventory_policy" id="inventory_policy" class="form-select">
                                    <option value="deny">Denegar cuando no hay stock</option>
                                    <option value="allow">Permitir cuando no hay stock</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- SEO -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab == 'seo'): ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Optimización SEO</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label" for="meta_title">Título Meta</label>
                                <input type="text" wire:model="meta_title" id="meta_title" class="form-control <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Título para motores de búsqueda">
                                <small class="text-muted">Máximo 60 caracteres</small>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label" for="meta_description">Descripción Meta</label>
                                <textarea wire:model="meta_description" id="meta_description" class="form-control <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3" placeholder="Descripción para motores de búsqueda"></textarea>
                                <small class="text-muted">Máximo 160 caracteres</small>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>

        <!-- Botones de acción -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="<?php echo e(route('admin.productos.index')); ?>" class="btn btn-outline-secondary">
                                <i class="ri-close-line me-1"></i>
                                Cancelar
                            </a>
                             <button type="button" wire:click="update" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="update">
                                    <i class="ri-save-line me-1"></i>
                                    Actualizar Producto
                                </span>
                                <span wire:loading wire:target="update">
                                    <i class="ri-loader-2-line ri-spin me-1"></i>
                                    Actualizando...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Opciones predefinidas de variantes
    const variantOptions = <?php echo json_encode($variantOptions, 15, 512) ?>;

    // Función para agregar un valor predefinido
    function addPredefinedValue(variantIndex, value) {
        // Obtener los valores actuales
        const currentValues = window.Livewire.find('<?php echo e($_instance->getId()); ?>').get(`variants.${variantIndex}.values`) || [];

        // Verificar si el valor ya existe
        if (!currentValues.includes(value)) {
            // Agregar el nuevo valor
            currentValues.push(value);
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(`variants.${variantIndex}.values`, currentValues);
        }
    }

    // Inicializar editor de texto si está disponible
    document.addEventListener('DOMContentLoaded', function() {
        // Aquí podrías inicializar un editor WYSIWYG como TinyMCE o CKEditor
        // Por ahora, usamos un textarea simple
    });

    // Manejar drag and drop de imágenes
    document.addEventListener('livewire:load', function() {
        Livewire.on('imageUploaded', function() {
            // Actualizar la vista previa de imágenes
        });

        // Escuchar evento de SKUs actualizados
        Livewire.on('skus-updated', function() {
            console.log('SKUs de variantes sincronizados');
            // Mostrar notificación visual
            const notification = document.createElement('div');
            notification.className = 'alert alert-success alert-sm position-fixed top-0 end-0 m-3';
            notification.style.zIndex = '9999';
            notification.innerHTML = '<i class=" ri-circle-line me-1"></i> SKUs sincronizados';
            document.body.appendChild(notification);
            setTimeout(() => notification.remove(), 2000);
        });

        // Sincronización automática de SKU con debounce
        let skuTimeout;
        function setupSkuSync() {
            const skuInput = document.getElementById('sku');
            if (skuInput) {
                skuInput.removeEventListener('input', handleSkuInput);
                skuInput.addEventListener('input', handleSkuInput);
            }
        }

        function handleSkuInput() {
            clearTimeout(skuTimeout);
            skuTimeout = setTimeout(() => {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').syncVariantSKUs();
            }, 500); // Esperar 500ms después de dejar de escribir
        }

        // Configurar sincronización inicial
        setupSkuSync();

        // Reconfigurar cuando Livewire actualice el DOM
        Livewire.hook('message.processed', (message, component) => {
            setupSkuSync();
            // Si hay variantes, sincronizar SKUs automáticamente
            if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').has_variants && window.Livewire.find('<?php echo e($_instance->getId()); ?>').variants && window.Livewire.find('<?php echo e($_instance->getId()); ?>').variants.length > 0) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').syncVariantSKUs();
            }
        });

        // Sincronizar cuando se cambie a la pestaña de información básica
        Livewire.on('tab-changed', function(tab) {
            if (tab === 'basic') {
                setTimeout(() => {
                    if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').has_variants && window.Livewire.find('<?php echo e($_instance->getId()); ?>').variants && window.Livewire.find('<?php echo e($_instance->getId()); ?>').variants.length > 0) {
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').syncVariantSKUs();
                    }
                }, 100);
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.nav-pills .nav-link {
    margin-right: 0.5rem;
    border-radius: 0.375rem;
}

.nav-pills .nav-link.active {
    background-color: #7367f0;
    color: white;
}

.dropzone {
    border: 2px dashed #7367f0;
    border-radius: 0.5rem;
    transition: all 0.3s ease;
}

.dropzone:hover {
    border-color: #5a4bd1;
    background-color: rgba(115, 103, 240, 0.05);
}

.img-thumbnail {
    border-radius: 0.5rem;
    border: 1px solid #e9ecef;
}

.form-check-input:checked {
    background-color: #7367f0;
    border-color: #7367f0;
}

.form-check-input:focus {
    box-shadow: 0 0 0 0.2rem rgba(115, 103, 240, 0.25);
}
</style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/productos/edit-mejorado.blade.php ENDPATH**/ ?>