<div>
    <div class="container-fluid">
        <!-- Mensajes de notificación -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-<?php echo e(session('message_type') === 'error' ? 'danger' : 'success'); ?> alert-dismissible fade show" role="alert">
                        <i class="ri-<?php echo e(session('message_type') === 'error' ? 'error-warning-line' : 'check-circle-line'); ?> me-2"></i>
                        <?php echo e(session('message')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <!-- Encabezado con título y breadcrumb -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Crear Nuevo Pedido</h4>
                    <div class="page-title-right">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-style m-0">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('admin.dashboard')); ?>">
                                        <i class="ri-home-line"></i>
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('admin.pedidos.index')); ?>">Pedidos</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Crear</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Sección de Cliente -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="ri-user-line me-2"></i>
                            Información del Cliente
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Selector de cliente existente -->
                        <div class="mb-4">
                            <label class="form-label" for="cliente_id">
                                Cliente Existente
                            </label>
                            <div class="position-relative">
                                <select wire:model.live="cliente_id" class="form-select <?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="cliente_id">
                                    <option value="">Seleccione un cliente existente</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $nombre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"><?php echo e($nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <i class="ri-error-warning-line me-1"></i>
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        <!-- Separador con texto -->
                        <div class="position-relative my-4">
                            <hr class="border-secondary">
                            <div class="position-absolute top-50 start-50 translate-middle bg-white px-3">
                                <span class="text-muted fw-medium small">O crear nuevo cliente</span>
                            </div>
                        </div>

                        <!-- Formulario de nuevo cliente -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label" for="nombres">
                                    Nombres *
                                </label>
                                <input wire:model="nombres" type="text" class="form-control <?php $__errorArgs = ['nombres'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nombres" placeholder="Juan Carlos">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['nombres'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="apellidos">
                                    Apellidos *
                                </label>
                                <input wire:model="apellidos" type="text" class="form-control <?php $__errorArgs = ['apellidos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="apellidos" placeholder="Pérez González">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['apellidos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="row g-3 mt-1">
                            <div class="col-md-6">
                                <label class="form-label" for="email">
                                    Email
                                </label>
                                <input wire:model="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" placeholder="cliente@ejemplo.com">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="telefono">
                                    Teléfono
                                </label>
                                <input wire:model="telefono" type="text" class="form-control <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="telefono" placeholder="+58 412-1234567">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="form-label" for="direccion">
                                Dirección de Entrega
                            </label>
                            <textarea wire:model="direccion" class="form-control <?php $__errorArgs = ['direccion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="direccion" rows="3" placeholder="Calle Principal, Edificio, Apartamento..."></textarea>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['direccion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sección de Pedido -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="ri-shopping-bag-line me-2"></i>
                            Detalles del Pedido
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label" for="fecha_entrega">
                                    Fecha de Entrega
                                </label>
                                <input wire:model="fecha_entrega" type="date" class="form-control <?php $__errorArgs = ['fecha_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="fecha_entrega">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['fecha_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="notas">
                                    Notas del Pedido
                                </label>
                                <textarea wire:model="notas" class="form-control <?php $__errorArgs = ['notas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="notas" rows="4" placeholder="Instrucciones especiales, preferencias, detalles adicionales..."></textarea>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['notas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <!-- Resumen de pago -->
                        <div class="bg-light rounded-3 p-3 mt-4">
                            <h6 class="fw-semibold text-muted mb-3">
                                <i class="ri-money-dollar-circle-line me-1"></i>
                                Resumen de Pago
                            </h6>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Subtotal:</span>
                                <span class="fw-medium">$ <?php echo e(number_format($this->total, 2)); ?></span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">IVA (16%):</span>
                                <span class="fw-medium">$ <?php echo e(number_format($this->total * 0.16, 2)); ?></span>
                            </div>
                            <hr class="my-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold text-primary">Total:</span>
                                <span class="fw-bold text-primary ">$ <?php echo e(number_format($this->total * 1.16, 2)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección de Productos -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="ri-shopping-cart-line me-2"></i>
                            Productos
                        </h5>
                        <div class="badge bg-label-primary">
                            <?php echo e(count($cart)); ?> productos
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Búsqueda de productos en tiempo real -->
                        <div class="row mb-4">
                            <div class="col-lg-8">
                                <label class="form-label" for="searchTerm">
                                    Buscar Productos
                                </label>
                                <div class="position-relative">
                                    <div class="input-group input-group-merge">
                                        <span class="input-group-text">
                                            <i class="ri-search-line"></i>
                                        </span>
                                        <input
                                            wire:model.live.debounce.300ms="searchTerm"
                                            type="text"
                                            class="form-control"
                                            id="searchTerm"
                                            placeholder="Escriba el código, nombre o descripción del producto..."
                                            autocomplete="off"
                                        >
                                        <span class="input-group-text">
                                            <div wire:loading wire:target="searchTerm" class="spinner-border spinner-border-sm text-primary" role="status">
                                                <span class="visually-hidden">Cargando...</span>
                                            </div>
                                            <div wire:loading.remove wire:target="searchTerm">
                                                <i class="ri-search-line"></i>
                                            </div>
                                        </span>
                                    </div>

                                    <!-- Resultados de búsqueda -->
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showSearchResults && is_array($searchResults) && count($searchResults) > 0): ?>
                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                            <div class="card shadow-lg">
                                                <div class="card-header py-2">
                                                    <small class="text-muted">
                                                        <i class="ri-search-2-line me-1"></i>
                                                        <?php echo e(count($searchResults)); ?> productos encontrados
                                                    </small>
                                                </div>
                                                <div class="card-body p-0 max-h-300px overflow-y-auto">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div
                                                            class="d-flex align-items-center p-3 border-bottom cursor-pointer"
                                                            wire:click="selectProduct(<?php echo e($producto['id']); ?>)"
                                                        >
                                                            <div class="me-3">
                                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($producto['image_path']) && $producto['image_path']): ?>
                                                                    <img src="/media/producto/<?php echo e($producto['image_path']); ?>"
                                                                         alt="<?php echo e($producto['name'] ?? 'Producto'); ?>"
                                                                         class="rounded"
                                                                         width="50"
                                                                         height="50"
                                                                         style="object-fit: cover;">
                                                                <?php else: ?>
                                                                    <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                     style="width: 50px; height: 50px;">
                                                                        <i class="ri-image-line text-muted"></i>
                                                                    </div>
                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-1 fw-semibold"><?php echo e($producto['name'] ?? 'Producto sin nombre'); ?></h6>
                                                                <p class="text-muted mb-1 small">
                                                                    <?php echo e($producto['code'] ?? ''); ?>

                                                                </p>
                                                                <p class="text-muted mb-1 small">
                                                                    <?php echo e(isset($producto['description']) ? Str::limit($producto['description'], 50) : ''); ?>

                                                                </p>
                                                                <div class="d-flex align-items-center">
                                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($producto['categoria_name']) && $producto['categoria_name']): ?>
                                                                        <span class="badge bg-label-primary me-2">
                                                                            <i class="ri-price-tag-3-line me-1"></i>
                                                                            <?php echo e($producto['categoria_name']); ?>

                                                                        </span>
                                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    <span class="badge bg-label-<?php echo e((isset($producto['quantity']) && $producto['quantity'] > 0) ? 'success' : 'danger'); ?>">
                                                                        <i class="ri-stock-line me-1"></i>
                                                                        Stock: <?php echo e($producto['quantity'] ?? 0); ?>

                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="text-end">
                                                                <h5 class="text-primary mb-1">$ <?php echo e(isset($producto['price']) ? number_format($producto['price'], 2) : '0.00'); ?></h5>
                                                                <small class="text-muted">C/U</small>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($showSearchResults && strlen($searchTerm) >= 2): ?>
                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                            <div class="card shadow-lg">
                                                <div class="card-body text-center py-4">
                                                    <i class="ri-search-line ri-3x text-muted mb-3"></i>
                                                    <h6 class="text-muted">No se encontraron productos</h6>
                                                    <p class="text-muted small mb-0">Intenta con otro término de búsqueda</p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <label class="form-label" for="quantity">
                                    Cantidad
                                </label>
                                <div class="input-group">
                                    <button
                                        class="btn btn-outline-secondary"
                                        type="button"
                                        wire:click="$set('quantity', Math.max(1, quantity - 1))"
                                        <?php echo e($quantity <= 1 ? 'disabled' : ''); ?>

                                    >
                                        <i class="ri-subtract-line"></i>
                                    </button>
                                    <input
                                        wire:model="quantity"
                                        type="number"
                                        min="1"
                                        class="form-control text-center fw-bold"
                                        id="quantity"
                                        style="max-width: 80px;"
                                    >
                                    <button
                                        class="btn btn-outline-secondary"
                                        type="button"
                                        wire:click="$set('quantity', quantity + 1)"
                                    >
                                        <i class="ri-add-line"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Botón para agregar producto -->
                        <div class="row mb-4">
                            <div class="col-12 text-center">
                                <button
                                    wire:click="addProductToCart"
                                    type="button"
                                    class="btn btn-primary"
                                    <?php echo e(!$selectedProduct ? 'disabled' : ''); ?>

                                >
                                    <i class="ri-shopping-cart-2-line me-2"></i>
                                    Agregar Producto al Carrito
                                </button>
                            </div>
                        </div>

                        <!-- Producto seleccionado actual -->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProduct): ?>
                            <?php
                                $selectedProductData = \App\Models\Producto::find($selectedProduct);
                            ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProductData): ?>
                                <div class="row mb-4">
                                    <div class="col-12">
                                        <div class="card border-primary">
                                            <div class="card-body p-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProductData->featuredImage): ?>
                                                            <img src="/media/producto/<?php echo e($selectedProductData->featuredImage->path); ?>"
                                                                 alt="<?php echo e($selectedProductData->name); ?>"
                                                                 class="rounded"
                                                                 width="60"
                                                                 height="60"
                                                                 style="object-fit: cover;">
                                                        <?php else: ?>
                                                            <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                 style="width: 60px; height: 60px;">
                                                                <i class="ri-image-line text-muted"></i>
                                                            </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1 fw-bold"><?php echo e($selectedProductData->name); ?></h6>
                                                        <p class="text-muted mb-1">
                                                            <?php echo e($selectedProductData->code); ?>

                                                        </p>
                                                        <p class="text-muted mb-1">
                                                            <?php echo e($selectedProductData->categoria->name ?? 'Sin categoría'); ?>

                                                        </p>
                                                        <div class="d-flex align-items-center">
                                                            <span class="text-primary fw-bold me-3">$ <?php echo e(number_format($selectedProductData->price, 2)); ?></span>
                                                            <span class="badge bg-label-<?php echo e($selectedProductData->quantity > 0 ? 'success' : 'danger'); ?>">
                                                                <i class="ri-stock-line me-1"></i>
                                                                Stock: <?php echo e($selectedProductData->quantity); ?>

                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="text-end">
                                                        <div class=" fw-bold text-primary">
                                                            $ <?php echo e(number_format($selectedProductData->price * $quantity, 2)); ?>

                                                        </div>
                                                        <small class="text-muted">Total</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <!-- Lista de productos en el carrito -->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($cart) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Producto</th>
                                            <th class="text-center">Cantidad</th>
                                            <th class="text-end">Precio Unit.</th>
                                            <th class="text-end">Subtotal</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="border-bottom">
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="me-3">
                                                            <?php
                                                                $producto = \App\Models\Producto::find($item['producto_id']);
                                                            ?>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto && $producto->featuredImage): ?>
                                                                <img src="/media/producto/<?php echo e($producto->featuredImage->path); ?>"
                                                                     alt="<?php echo e($item['nombre']); ?>"
                                                                     class="rounded"
                                                                     width="40"
                                                                     height="40"
                                                                     style="object-fit: cover;">
                                                            <?php else: ?>
                                                                <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                     style="width: 40px; height: 40px;">
                                                                    <i class="ri-image-line text-muted"></i>
                                                                </div>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 fw-semibold"><?php echo e($item['nombre']); ?></h6>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto && $producto->categoria): ?>
                                                                <small class="text-muted"><?php echo e($producto->categoria->name); ?></small>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto): ?>
                                                                <small class="text-muted d-block"><?php echo e($producto->code); ?></small>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge bg-primary rounded-pill px-3 py-2">
                                                        <?php echo e($item['cantidad']); ?>

                                                    </span>
                                                </td>
                                                <td class="text-end fw-medium">
                                                    $ <?php echo e(number_format($item['precio_unitario'], 2)); ?>

                                                </td>
                                                <td class="text-end fw-bold text-primary">
                                                    $ <?php echo e(number_format($item['subtotal'], 2)); ?>

                                                </td>
                                                <td class="text-center">
                                                    <button
                                                        wire:click="removeFromCart(<?php echo e($index); ?>)"
                                                        type="button"
                                                        class="btn btn-sm btn-outline-danger rounded-circle"
                                                        data-bs-toggle="tooltip"
                                                        data-bs-placement="top"
                                                        title="Eliminar producto"
                                                    >
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="table-active">
                                            <th colspan="3" class="text-end text-uppercase">Total del Pedido:</th>
                                            <th class="text-end">
                                                <span class=" fw-bold text-primary">
                                                    $ <?php echo e(number_format($this->total, 2)); ?>

                                                </span>
                                            </th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <div class="mb-4">
                                    <i class="ri-shopping-cart-line ri-3x text-muted"></i>
                                </div>
                                <h5 class="text-muted mb-2">Carrito vacío</h5>
                                <p class="text-muted mb-4">Agrega productos al carrito para continuar con el pedido</p>
                                <div class="d-flex justify-content-center gap-2">
                                    <span class="badge bg-label-secondary">
                                        <i class="ri-lightbulb-line me-1"></i>
                                        Tip: Usa la búsqueda para encontrar productos rápidamente
                                    </span>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Botones de acción -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <div class="bg-label-primary rounded-circle p-3 me-3">
                                        <i class="ri-check-double-line ri-24px"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">¿Listo para crear el pedido?</h6>
                                        <small class="text-muted">Revisa todos los detalles antes de confirmar</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex justify-content-end gap-3">
                                    <a href="<?php echo e(route('admin.pedidos.index')); ?>" class="btn btn-outline-secondary">
                                        <i class="ri-arrow-left-line me-2"></i>
                                        Cancelar
                                    </a>
                                    <button
                                        wire:click="save"
                                        type="button"
                                        class="btn btn-success"
                                        <?php echo e(count($cart) == 0 ? 'disabled' : ''); ?>

                                    >
                                        <i class="ri-save-line me-2"></i>
                                        Crear Pedido
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript para mejorar la experiencia -->
    <script>
        // Cerrar resultados de búsqueda al hacer clic fuera
        document.addEventListener('click', function(e) {
            const searchContainer = document.querySelector('.position-relative');
            if (searchContainer && !searchContainer.contains(e.target)) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('hideSearchResults');
            }
        });

        // Mejorar la experiencia de búsqueda
        document.addEventListener('livewire:init', () => {
            Livewire.on('product-added', (event) => {
                // Mostrar notificación de éxito
                if (typeof toastr !== 'undefined') {
                    toastr.success('Producto agregado al carrito');
                }
            });

            Livewire.on('product-removed', (event) => {
                // Mostrar notificación de eliminación
                if (typeof toastr !== 'undefined') {
                    toastr.info('Producto eliminado del carrito');
                }
            });

            Livewire.on('show-toast', (event) => {
                if (typeof toastr !== 'undefined') {
                    const data = event[0] || event;
                    switch(data.type) {
                        case 'success':
                            toastr.success(data.message);
                            break;
                        case 'error':
                            toastr.error(data.message);
                            break;
                        case 'info':
                            toastr.info(data.message);
                            break;
                        case 'warning':
                            toastr.warning(data.message);
                            break;
                    }
                }
            });
        });

        // Mejorar accesibilidad con teclado
        document.addEventListener('keydown', function(e) {
            // Escape para cerrar resultados de búsqueda
            if (e.key === 'Escape') {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('hideSearchResults');
            }
        });
    </script>

    <style>
        .cursor-pointer {
            cursor: pointer;
        }

        .cursor-pointer:hover {
            background-color: #f8f9fa;
        }

        .max-h-300px {
            max-height: 300px;
        }

        .overflow-y-auto {
            overflow-y: auto;
        }

        /* Mejorar la apariencia de los badges */
        .badge {
            font-size: 0.75em;
        }

        /* Animaciones suaves */
        .card {
            transition: all 0.3s ease;
        }

        .btn {
            transition: all 0.2s ease;
        }

        /* Mejorar la tabla responsive */
        .table-responsive {
            border-radius: 0.375rem;
        }

        /* Estilos para el estado loading */
        .spinner-border-sm {
            width: 1rem;
            height: 1rem;
        }
    </style>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/pedidos/create.blade.php ENDPATH**/ ?>