<div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
        <script>
            window.addEventListener('DOMContentLoaded', function() {
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        type: 'success',
                        message: '<?php echo e(session('message')); ?>',
                        timeout: 5000
                    }
                }));
            });
        </script>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1"><?php echo e(number_format($stats['total'])); ?></h3>
                            <p class="mb-0">Total Pedidos</p>
                            <small class="text-muted">Todos los pedidos</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-primary">
                                <i class=" ri-shopping-bag-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-warning"><?php echo e(number_format($stats['pendientes'])); ?></h3>
                            <p class="mb-0">Pendientes</p>
                            <small class="text-muted">Esperando pago</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-warning">
                                <i class=" ri-time-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-success"><?php echo e(number_format($stats['pagados'])); ?></h3>
                            <p class="mb-0">Pagados</p>
                            <small class="text-muted">Listos para entrega</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-success">
                                <i class=" ri-money-dollar-circle-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-info"><?php echo e(number_format($stats['entregados'])); ?></h3>
                            <p class="mb-0">Entregados</p>
                            <small class="text-muted">Completados</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-info">
                                <i class=" ri-checkbox-circle-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y tabla -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Gestión de Pedidos</h5>
            <div class="d-flex gap-2">
                <button wire:click="$refresh" class="btn btn-outline-primary">
                    <i class=" ri-refresh-line"></i> Actualizar
                </button>
            </div>
        </div>

        <div class="card-body">
            <!-- Filtros -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text"><i class=" ri-search-line"></i></span>
                        <input type="text" class="form-control" placeholder="Buscar pedidos..." wire:model.live="search">
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="estadoFilter">
                        <option value="">Todos los estados</option>
                        <option value="pendiente">Pendiente</option>
                        <option value="pagado">Pagado</option>
                        <option value="asignado">Asignado</option>
                        <option value="entregado">Entregado</option>
                        <option value="cancelado">Cancelado</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="metodoPagoFilter">
                        <option value="">Todos los métodos</option>
                        <option value="efectivo">Efectivo</option>
                        <option value="transferencia">Transferencia</option>
                        <option value="pago_movil">Pago Móvil</option>
                    </select>
                </div>
            </div>

            <!-- Tabla -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('codigo')" style="cursor: pointer;">
                                Código <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'codigo'): ?> <i class=" ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </th>
                            <th>Cliente</th>
                            <th>Total</th>
                            <th>Método Pago</th>
                            <th>Estado</th>
                            <th>Empleado</th>
                            <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                Fecha <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'created_at'): ?> <i class=" ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $pedidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><strong><?php echo e($pedido->codigo); ?></strong></td>
                                <td>
                                    <div>
                                        <strong><?php echo e($pedido->user->name); ?></strong>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->user->telefono): ?>
                                            <br><small class="text-muted">
                                                <i class=" ri-phone-line me-1"></i><?php echo e($pedido->user->telefono); ?>

                                            </small>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </td>
                                <td><?php echo e(format_money($pedido->total_usd, 2)); ?></td>
                                <td>
                                    <span class="badge bg-label-info"><?php echo e(ucfirst($pedido->metodo_pago)); ?></span>
                                </td>
                                <td>
                                    <?php
                                        $badgeClass = match($pedido->estado) {
                                            'pendiente' => 'bg-warning',
                                            'pagado' => 'bg-success',
                                            'asignado' => 'bg-info',
                                            'entregado' => 'bg-primary',
                                            'cancelado' => 'bg-danger',
                                            default => 'bg-secondary'
                                        };
                                    ?>
                                    <span class="badge <?php echo e($badgeClass); ?>"><?php echo e(ucfirst($pedido->estado)); ?></span>
                                </td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->empleados->count() > 0): ?>
                                        <small><?php echo e($pedido->empleados->first()->nombre_completo); ?></small>
                                    <?php else: ?>
                                        <span class="text-muted">Sin asignar</span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td><?php echo e($pedido->created_at->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                            <i class=" ri-more-2-line"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="<?php echo e(route('admin.pedidos.show', $pedido)); ?>">
                                                <i class=" ri-eye-line me-1"></i> Ver Detalle
                                            </a></li>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($pedido->estado, ['pendiente', 'pagado']) && auth()->user()->can('edit pedidos')): ?>
                                                <li><a class="dropdown-item" href="<?php echo e(route('admin.pedidos.edit', $pedido->id)); ?>">
                                                    <i class=" ri-edit-line me-1"></i> Modificar Pedido
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado === 'Pendiente'): ?>
                                                <li><a class="dropdown-item text-success" href="#"
                                                    wire:click="confirmarPago(<?php echo e($pedido->id); ?>)"
                                                    wire:confirm="¿Confirmar el pago de este pedido?">
                                                    <i class=" ri-check-double-line me-1"></i> Confirmar Pago
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($pedido->estado, ['pagado', 'asignado'])): ?>
                                                <li><a class="dropdown-item text-info" href="#"
                                                    wire:click="abrirModalAsignar(<?php echo e($pedido->id); ?>)">
                                                    <i class=" ri-user-add-line me-1"></i> Asignar Empleado
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado === 'asignado'): ?>
                                                <li><a class="dropdown-item text-primary" href="#"
                                                    wire:click="finalizarEntrega(<?php echo e($pedido->id); ?>)"
                                                    wire:confirm="¿Marcar como entregado?">
                                                    <i class=" ri-truck-line me-1"></i> Finalizar Entrega
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($pedido->estado, ['pagado', 'asignado', 'entregado']) && auth()->user()->can('revertir pedidos')): ?>
                                                <li><a class="dropdown-item text-warning" href="#"
                                                    wire:click="revertirPedido(<?php echo e($pedido->id); ?>)"
                                                    wire:confirm="¿Revertir este pedido? Se devolverán los productos al almacén.">
                                                    <i class=" ri-arrow-go-back-line me-1"></i> Revertir Pedido
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!in_array($pedido->estado, ['entregado', 'cancelado'])): ?>
                                                <li><hr class="dropdown-divider"></li>
                                                <li><a class="dropdown-item text-danger" href="#"
                                                    wire:click="abrirModalCancelar(<?php echo e($pedido->id); ?>)">
                                                    <i class=" ri-close-circle-line me-1"></i> Cancelar Pedido
                                                </a></li>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class=" ri-shopping-bag-line fs-1 text-muted mb-2"></i>
                                    <p class="text-muted mb-0">No se encontraron pedidos</p>
                                </td>
                            </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                
                <?php echo e($pedidos->links('livewire.pagination')); ?>

            </div>
        </div>
    </div>

    <!-- Modal Asignar Empleado -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showAsignarModal): ?>
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Asignar Empleado</h5>
                        <button type="button" class="btn-close" wire:click="$set('showAsignarModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Seleccionar Empleado</label>
                            <select class="form-select" wire:model="empleadoSeleccionado">
                                <option value="">Seleccionar empleado...</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($empleado->id); ?>"><?php echo e($empleado->nombre_completo); ?> - <?php echo e($empleado->cargo); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['empleadoSeleccionado'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showAsignarModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-primary" wire:click="asignarEmpleado">Asignar</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Modal Cancelar Pedido -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCancelarModal): ?>
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Cancelar Pedido</h5>
                        <button type="button" class="btn-close" wire:click="$set('showCancelarModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Motivo de Cancelación</label>
                            <textarea class="form-control" rows="3" wire:model="motivoCancelacion"
                                placeholder="Describe el motivo de la cancelación..."></textarea>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['motivoCancelacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showCancelarModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-danger" wire:click="cancelarPedido">Confirmar Cancelación</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<script>
    // Auto-refresh cada 30 segundos para tiempo real
    setInterval(function() {
        window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('$refresh');
    }, 30000);

    // Tiempo real con broadcasting (si está disponible)
    if (typeof Echo !== 'undefined') {
        Echo.channel('pedidos')
            .listen('PedidoActualizado', (e) => {
                // Mostrar notificación toast
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        type: 'info',
                        message: `Pedido ${e.pedido.codigo}: ${e.accion.replace('_', ' ')}`,
                        timeout: 5000
                    }
                }));

                // Refrescar la tabla
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('$refresh');
            });
    }
</script>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/pedidos/index.blade.php ENDPATH**/ ?>