<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Configuraciones de Seguridad</h5>
    </div>
    <div class="card-body">
        <!-- Security Score -->
        <div class="mb-4">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Nivel de Seguridad</h6>
                <span class="badge bg-<?php echo e($securityInfo['level']['color']); ?>"><?php echo e($securityInfo['level']['name']); ?></span>
            </div>
            <div class="progress mb-2" style="height: 8px;">
                <div class="progress-bar bg-<?php echo e($securityInfo['level']['color']); ?>" 
                     role="progressbar" 
                     style="width: <?php echo e($securityInfo['score']); ?>%"
                     aria-valuenow="<?php echo e($securityInfo['score']); ?>" 
                     aria-valuemin="0" 
                     aria-valuemax="100">
                </div>
            </div>
            <small class="text-muted"><?php echo e($securityInfo['score']); ?>% de seguridad</small>
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($securityInfo['factors']) > 0): ?>
                <div class="mt-3">
                    <small class="text-muted d-block mb-2">Factores de seguridad activos:</small>
                    <ul class="list-unstyled mb-0">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $securityInfo['factors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="mb-1">
                                <i class="ri-check-line text-success me-1"></i>
                                <small><?php echo e($factor); ?></small>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </ul>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <hr>

        <!-- Change Password -->
        <div class="mb-4">
            <h6 class="mb-3">Cambiar Contraseña</h6>
            <form wire:submit.prevent="updatePassword">
                <div class="row">
                    <div class="col-12 mb-3">
                        <label class="form-label">Contraseña Actual *</label>
                        <input type="password" 
                               wire:model="current_password" 
                               class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="Ingresa tu contraseña actual">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Nueva Contraseña *</label>
                        <input type="password" 
                               wire:model="new_password" 
                               class="form-control <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="Mínimo 8 caracteres">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Confirmar Nueva Contraseña *</label>
                        <input type="password" 
                               wire:model="new_password_confirmation" 
                               class="form-control"
                               placeholder="Repite la nueva contraseña">
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" 
                               type="checkbox" 
                               wire:model="logout_other_devices" 
                               id="logoutOtherDevices">
                        <label class="form-check-label" for="logoutOtherDevices">
                            Cerrar sesión en otros dispositivos
                        </label>
                        <small class="form-text text-muted d-block">
                            Esto cerrará tu sesión en todos los demás dispositivos por seguridad.
                        </small>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="ri-lock-line me-1"></i> Actualizar Contraseña
                </button>
            </form>
        </div>

        <hr>

        <!-- Security Recommendations -->
        <div class="mb-0">
            <h6 class="mb-3">Recomendaciones de Seguridad</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-<?php echo e($user->two_factor_enabled ? 'success' : 'warning'); ?> rounded">
                                <i class="ri-shield-<?php echo e($user->two_factor_enabled ? 'check' : 'line'); ?>-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Autenticación de Dos Factores</h6>
                            <p class="mb-2 text-muted">
                                <?php echo e($user->two_factor_enabled ? 'Activada' : 'Añade una capa extra de seguridad'); ?>

                            </p>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$user->two_factor_enabled): ?>
                                <small class="text-warning">
                                    <i class="ri-information-line me-1"></i>
                                    Recomendado activar
                                </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-<?php echo e($user->email_verified_at ? 'success' : 'danger'); ?> rounded">
                                <i class="ri-mail-<?php echo e($user->email_verified_at ? 'check' : 'line'); ?>-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Email Verificado</h6>
                            <p class="mb-2 text-muted">
                                <?php echo e($user->email_verified_at ? 'Verificado el ' . $user->email_verified_at->format('d/m/Y') : 'Verifica tu email para mayor seguridad'); ?>

                            </p>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$user->email_verified_at): ?>
                                <small class="text-danger">
                                    <i class="ri-error-warning-line me-1"></i>
                                    Verificación pendiente
                                </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-<?php echo e(($user->phone && $user->address) ? 'success' : 'info'); ?> rounded">
                                <i class="ri-user-<?php echo e(($user->phone && $user->address) ? 'check' : 'line'); ?>-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Perfil Completo</h6>
                            <p class="mb-2 text-muted">
                                <?php echo e(($user->phone && $user->address) ? 'Información completa' : 'Completa tu información de contacto'); ?>

                            </p>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!($user->phone && $user->address)): ?>
                                <small class="text-info">
                                    <i class="ri-information-line me-1"></i>
                                    Mejora tu perfil
                                </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-<?php echo e($user->avatar ? 'success' : 'secondary'); ?> rounded">
                                <i class="ri-camera-<?php echo e($user->avatar ? 'check' : 'line'); ?>-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Foto de Perfil</h6>
                            <p class="mb-2 text-muted">
                                <?php echo e($user->avatar ? 'Configurada' : 'Añade una foto para personalizar tu perfil'); ?>

                            </p>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$user->avatar): ?>
                                <small class="text-secondary">
                                    <i class="ri-information-line me-1"></i>
                                    Opcional pero recomendado
                                </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/users/profile/security-settings.blade.php ENDPATH**/ ?>