<div class="dropdown mini-cart-dropdown" wire:ignore.self>
    <button class="btn btn-icon  btn-success position-relative wishlist-btn"
            type="button"
            id="miniCartDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
            aria-label="Carrito de compras">
        <i class="ri-shopping-cart-2-line fs-5"></i>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cartCount > 0): ?>
            <span class="position-absolute topbar-badge cart-badge fs-10 translate-middle badge rounded-pill bg-danger animate__animated animate__pulse animate__infinite">
                <?php echo e($cartCount > 99 ? '99+' : $cartCount); ?>

            </span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </button>

    <div class="dropdown-menu dropdown-menu-end dropdown-menu-lg p-0 dropdown-menu-cart" aria-labelledby="miniCartDropdown">
        <!-- Header con gradiente -->
        <div class="dropdown-head bg-primary bg-gradient rounded-top">
            <div class="p-3">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        <div class="avatar-sm bg-white bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center">
                            <i class="ri-shopping-cart-2-fill text-white fs-5"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-0 text-white fw-semibold">Mi Carrito</h6>
                        <p class="mb-0 text-white text-opacity-75 fs-12">
                            <?php echo e($cartCount); ?> <?php echo e($cartCount == 1 ? 'producto' : 'productos'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cartCount > 0): ?>
            <div class="mini-cart-items" data-simplebar>
                <?php
                    $items = \Cart::session(userID())->getContent();
                ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="cart-item-wrapper" wire:key="cart-item-<?php echo e($item->id); ?>">
                        <div class="d-flex align-items-center p-3 cart-item">
                            <?php
                                $imageToShow = null;
                                if (isset($item->attributes['variant_id']) && $item->attributes['variant_id']) {
                                    $variant = $item->associatedModel->variants->find($item->attributes['variant_id']);
                                    if ($variant && $variant->image_path) {
                                        $imageToShow = $variant->image_path;
                                    } elseif ($variant && $variant->image_thumbnail_path) {
                                        $imageToShow = $variant->image_thumbnail_path;
                                    }
                                }
                                if (!$imageToShow && $item->associatedModel && $item->associatedModel->images && $item->associatedModel->images->first()) {
                                    $imageToShow = $item->associatedModel->images->first()->path;
                                }
                            ?>

                            <div class="flex-shrink-0 me-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($imageToShow): ?>
                                    <div class="avatar-md rounded bg-light overflow-hidden">
                                        <img src="<?php echo e(asset('app/' . $imageToShow)); ?>"
                                             alt="<?php echo e($item->name); ?>"
                                             class="img-fluid h-100 w-100"
                                             style="object-fit: cover;"
                                             loading="lazy">
                                    </div>
                                <?php else: ?>
                                    <div class="avatar-md rounded bg-light d-flex align-items-center justify-content-center">
                                        <i class="ri-image-line text-muted fs-4"></i>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="flex-grow-1 overflow-hidden">
                                <h6 class="mb-1 text-truncate fw-medium"><?php echo e($item->name); ?></h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge bg-primary-subtle text-primary fs-11">
                                        <?php echo e($item->quantity); ?> x <?php echo e(format_money($item->price)); ?>

                                    </span>
                                </div>
                                <div class="mt-1">
                                    <span class="fw-semibold text-primary"><?php echo e(format_money($item->price * $item->quantity)); ?></span>
                                </div>
                            </div>

                            <div class="flex-shrink-0 ms-2">
                                <button wire:click="removeItem('<?php echo e($item->id); ?>')"
                                        wire:loading.attr="disabled"
                                        wire:loading.class="btn-ghost-secondary"
                                        wire:target="removeItem('<?php echo e($item->id); ?>')"
                                        class="btn btn-icon btn-sm btn-ghost-danger rounded-circle cart-remove-btn"
                                        aria-label="Eliminar <?php echo e($item->name); ?> del carrito">
                                    <span wire:loading.remove wire:target="removeItem('<?php echo e($item->id); ?>')">
                                        <i class="ri-delete-bin-5-line"></i>
                                    </span>
                                    <span wire:loading wire:target="removeItem('<?php echo e($item->id); ?>')">
                                        <span class="spinner-border spinner-border-sm"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <!-- Footer con total -->
            <div class="dropdown-footer border-top bg-light bg-opacity-50">
                <div class="p-3">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="text-muted fw-medium">Subtotal:</span>
                        <span class="fw-bold text-dark fs-5"><?php echo e(format_money(\Cart::session(userID())->getTotal())); ?></span>
                    </div>
                    <div class="hstack gap-2">
                        <a href="/front/cart" class="btn btn-soft-primary btn-sm w-50 d-flex align-items-center justify-content-center gap-1">
                            <i class="ri-shopping-cart-2-line"></i>
                            <span>Ver Carrito</span>
                        </a>
                        <a href="/front/checkout" class="btn btn-success btn-sm w-50 d-flex align-items-center justify-content-center gap-1">
                            <i class="ri-secure-payment-line"></i>
                            <span>Pagar</span>
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <!-- Empty State -->
            <div class="p-4 text-center empty-cart-state">
                <div class="avatar-lg mx-auto mb-3">
                    <div class="avatar-title bg-primary-subtle text-primary rounded-circle empty-cart-icon">
                        <i class="ri-shopping-cart-2-line fs-2"></i>
                    </div>
                </div>
                <h6 class="mb-2 text-dark">Tu carrito está vacío</h6>
                <p class="text-muted fs-13 mb-3">Agrega productos para comenzar</p>
                <a href="/" class="btn btn-primary btn-sm px-4">
                    <i class="ri-store-2-line me-1"></i>Explorar Tienda
                </a>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <style>
    .mini-cart-dropdown .dropdown-menu-cart {
        min-width: 340px;
        max-width: 340px;
        border: none;
        box-shadow: 0 5px 25px rgba(0,0,0,0.15);
        border-radius: 0.5rem;
        animation: fadeInUp 0.2s ease-out;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .mini-cart-items {
        max-height: 280px;
        overflow-y: auto;
    }

    .cart-item {
        transition: all 0.2s ease;
        border-bottom: 1px solid rgba(0,0,0,0.05);
    }

    .cart-item:hover {
        background-color: rgba(var(--vz-primary-rgb), 0.04);
    }

    .cart-item-wrapper:last-child .cart-item {
        border-bottom: none;
    }

    .cart-remove-btn {
        opacity: 0.6;
        transition: all 0.2s ease;
    }

    .cart-item:hover .cart-remove-btn {
        opacity: 1;
    }

    .cart-remove-btn:hover {
        transform: scale(1.1);
    }

    .avatar-md {
        width: 50px;
        height: 50px;
    }

    .avatar-sm {
        width: 36px;
        height: 36px;
    }

    .avatar-lg {
        width: 64px;
        height: 64px;
    }

    .avatar-title {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .topbar-badge {
        top: 2px !important;
        right: -2px !important;
        left: auto !important;
        padding: 0.25em 0.5em;
    }

    .fs-10 {
        font-size: 10px !important;
    }

    .fs-11 {
        font-size: 11px !important;
    }

    .fs-12 {
        font-size: 12px !important;
    }

    .fs-13 {
        font-size: 13px !important;
    }

    .btn-icon {
        width: 38px;
        height: 38px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .btn-icon.btn-sm {
        width: 28px;
        height: 28px;
    }

    .btn-ghost-secondary {
        color: #495057;
        background-color: transparent;
    }

    .btn-ghost-secondary:hover {
        color: #495057;
        background-color: rgba(73, 80, 87, 0.1);
    }

    .btn-ghost-danger {
        color: #f06548;
        background-color: transparent;
    }

    .btn-ghost-danger:hover {
        color: #fff;
        background-color: #f06548;
    }

    .btn-soft-primary {
        color: var(--bs-primary);
        background-color: rgba(var(--vz-primary-rgb), 0.1);
        border-color: transparent;
    }

    .btn-soft-primary:hover {
        color: #fff;
        background-color: var(--bs-primary);
    }

    .empty-cart-icon {
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
        }
        50% {
            transform: scale(1.05);
        }
    }

    .mini-cart-items::-webkit-scrollbar {
        width: 5px;
    }

    .mini-cart-items::-webkit-scrollbar-track {
        background: transparent;
    }

    .mini-cart-items::-webkit-scrollbar-thumb {
        background: rgba(0,0,0,0.15);
        border-radius: 10px;
    }

    .mini-cart-items::-webkit-scrollbar-thumb:hover {
        background: rgba(0,0,0,0.25);
    }

    .bg-primary-subtle {
        background-color: rgba(var(--vz-primary-rgb), 0.15) !important;
    }
    </style>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/mini-cart.blade.php ENDPATH**/ ?>