<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Notas de Venta</h1>
            <p class="mb-0 text-muted">Gestión y consulta de notas de venta emitidas</p>
        </div>
        <a href="<?php echo e(route('admin.notas-venta.create')); ?>" class="btn btn-primary">
            <i class="ri-add-line me-2"></i>Nueva Nota
        </a>
    </div>

    <!-- Estadísticas Cards -->
    <div class="row g-3 mb-4">
        <div class="col-xl-6 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-primary bg-opacity-10 rounded-3 p-3">
                                <i class="ri-file-list-3-line text-primary fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Total Notas</h6>
                            <h3 class="mb-0"><?php echo e(number_format($this->totalNotas)); ?></h3>
                            <small class="text-primary"><?php echo e($fechaInicio); ?> - <?php echo e($fechaFin); ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-success bg-opacity-10 rounded-3 p-3">
                                <i class="ri-money-dollar-circle-line text-success fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Monto Total</h6>
                            <h3 class="mb-0"><?php echo e(format_money($this->totalMonto)); ?></h3>
                            <small class="text-success">Notas emitidas</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-0 pb-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Filtros de Búsqueda</h5>
                <button wire:click="limpiarFiltros" class="btn btn-outline-secondary btn-sm">
                    <i class="ri-refresh-line me-1"></i>Limpiar
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Buscar</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0">
                            <i class="ri-search-line text-muted"></i>
                        </span>
                        <input type="text" wire:model.live.debounce.300ms="search"
                               class="form-control border-start-0"
                               placeholder="Número, cliente, venta...">
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Inicio</label>
                    <input type="date" wire:model.live="fechaInicio" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Fin</label>
                    <input type="date" wire:model.live="fechaFin" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Estado</label>
                    <select wire:model.live="estado" class="form-select">
                        <option value="">Todos</option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Notas de Venta -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Listado de Notas de Venta</h5>
                <div class="text-muted small">
                    <?php echo e($notasVenta->firstItem() ?? 0); ?> - <?php echo e($notasVenta->lastItem() ?? 0); ?> de <?php echo e($notasVenta->total()); ?> notas
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notasVenta->isEmpty()): ?>
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="ri-file-list-3-line text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <h5 class="text-muted">No se encontraron notas de venta</h5>
                    <p class="text-muted mb-0">Ajusta los filtros para ver más resultados</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">
                                    <button wire:click="orderBy('numero')" class="btn btn-link p-0 text-decoration-none text-muted">
                                        Número
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($orderBy === 'numero'): ?>
                                            <i class="ri-arrow-<?php echo e($orderDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </button>
                                </th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Cliente</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Origen</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Serie</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">
                                    <button wire:click="orderBy('fecha_emision')" class="btn btn-link p-0 text-decoration-none text-muted">
                                        Fecha
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($orderBy === 'fecha_emision'): ?>
                                            <i class="ri-arrow-<?php echo e($orderDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </button>
                                </th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-end">
                                    <button wire:click="orderBy('total')" class="btn btn-link p-0 text-decoration-none text-muted">
                                        Total
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($orderBy === 'total'): ?>
                                            <i class="ri-arrow-<?php echo e($orderDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </button>
                                </th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Estado</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center pe-4">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $notasVenta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
                                            <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                <i class="ri-file-list-3-line text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold"><?php echo e($nota->numeroCompleto); ?></div>
                                                <small class="text-muted"><?php echo e($nota->created_at->format('d/m/Y H:i')); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-user-line text-muted me-2"></i>
                                            <span><?php echo e($nota->cliente->nombre_completo ?? 'Cliente general'); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($nota->cotizaciones->count() > 0): ?>
                                                <div class="d-flex align-items-center">
                                                    <i class="ri-file-list-3-line text-primary me-1"></i>
                                                    <span class="text-primary">Cotización</span>
                                                </div>
                                            <?php else: ?>
                                                <div class="d-flex align-items-center">
                                                    <i class="ri-edit-line text-muted me-1"></i>
                                                    <span class="text-muted">Directa</span>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($nota->venta): ?>
                                                <div class="d-flex align-items-center mt-1">
                                                    <i class="ri-shopping-cart-line text-success me-1"></i>
                                                    <span class="text-success small">Convertida</span>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-hashtag text-muted me-2"></i>
                                            <span class="fw-medium"><?php echo e($nota->serie); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div class="fw-medium"><?php echo e($nota->fecha_emision->format('d/m/Y')); ?></div>
                                            <div class="text-muted"><?php echo e($nota->user->name ?? 'Sistema'); ?></div>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <span class="fw-bold text-success"><?php echo e(format_money($nota->total)); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($nota->estado):
                                            case ('procesada'): ?>
                                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-2 py-1">
                                                    <i class="ri-check-line me-1"></i>Procesada
                                                </span>
                                                <?php break; ?>
                                            <?php case ('pendiente'): ?>
                                                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-2 py-1">
                                                    <i class="ri-time-line me-1"></i>Pendiente
                                                </span>
                                                <?php break; ?>
                                            <?php case ('anulada'): ?>
                                                <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-2 py-1">
                                                    <i class="ri-close-line me-1"></i>Anulada
                                                </span>
                                                <?php break; ?>
                                        <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td class="text-center pe-4">
                                        <a href="<?php echo e(route('admin.notas-venta.show', $nota->id)); ?>"
                                           class="btn btn-outline-primary btn-sm"
                                           title="Ver detalle">
                                            <i class="ri-eye-line"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.notas-venta.edit', $nota->id)); ?>"
                                           class="btn btn-outline-secondary btn-sm"
                                           title="Editar">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notasVenta->hasPages()): ?>
                    <div class="card-footer bg-white border-0">
                        <?php echo e($notasVenta->links()); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/notas-venta/index.blade.php ENDPATH**/ ?>