<div>
    <!-- Breadcrumb -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">Detalle del Producto</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.productos.index')); ?>">Productos</a>
                        </li>
                        <li class="breadcrumb-item active"><?php echo e($producto->name ?? 'Detalle'); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$producto): ?>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="mb-4">
                                <i class=" ri-shopping-bag-line text-warning"></i>
                            </div>
                            <h5 class="text-warning mb-3">Producto no encontrado</h5>
                            <p class="text-muted mb-4">El producto que estás buscando no existe o no tienes permisos para verlo.</p>
                            <a href="<?php echo e(route('admin.productos.index')); ?>" class="btn btn-primary">
                                <i class=" ri-shopping-bag-line me-1"></i> Volver al listado
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Información Básica
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Código:</td>
                                        <td>
                                            <span class="badge bg-secondary"><?php echo e($producto->code); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Nombre:</td>
                                        <td class="text-dark fw-medium"><?php echo e($producto->name); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Descripción:</td>
                                        <td class="text-muted"><?php echo e($producto->description ?? 'Sin descripción'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">SKU:</td>
                                        <td class="text-muted"><?php echo e($producto->sku ?? 'No asignado'); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Estado:</td>
                                        <td><?php echo $this->statusBadge; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Categoría:</td>
                                        <td>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->categoria): ?>
                                                <span class="badge bg-primary"><?php echo e($producto->categoria->name); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">Sin categoría</span>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Marca:</td>
                                        <td>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->marca): ?>
                                                <span class="badge bg-secondary"><?php echo e($producto->marca->name); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">Sin marca</span>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Empresa:</td>
                                        <td>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->empresa): ?>
                                                <span class="badge bg-dark"><?php echo e($producto->empresa->name); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">Sin empresa</span>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Precios y Stock
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Precio USD:</td>
                                        <td class="text-success fw-bold"><?php echo e($this->priceWithCurrency); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Precio Bs:</td>
                                        <td class="text-success fw-bold"><?php echo e($this->priceBsWithCurrency); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Stock Actual:</td>
                                        <td>
                                            <span class="badge bg-info"><?php echo e($producto->quantity); ?> unidades</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Alerta de Stock:</td>
                                        <td>
                                            <span class="badge bg-warning"><?php echo e($producto->quantity_alert); ?> unidades</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Estado Stock:</td>
                                        <td><?php echo $this->stockStatus; ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class=" ri-shopping-bag-line me-2"></i>
                                Galería de Imágenes
                            </h5>
                            <span class="badge bg-info"><?php echo e($producto->images->count()); ?> imágenes</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->images->isNotEmpty()): ?>
                            <div class="row g-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $producto->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="card border h-100">
                                            <div class="position-relative">
                                                <img src="<?php echo e(Storage::url($image->path)); ?>"
                                                     alt="<?php echo e($image->alt_text ?? $producto->name); ?>"
                                                     class="card-img-top"
                                                     style="height: 150px; object-fit: cover;">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($image->featured): ?>
                                                    <span class="position-absolute top-0 start-0 translate-middle badge bg-warning m-2">
                                                        <i class=" ri-shopping-bag-line"></i> Principal
                                                    </span>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                            <div class="card-body p-2 text-center">
                                                <small class="text-muted">
                                                    <?php echo e($image->featured ? 'Imagen Principal' : 'Imagen Secundaria'); ?>

                                                </small>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($image->alt_text): ?>
                                                    <div class="mt-1">
                                                        <small class="text-dark"><?php echo e($image->alt_text); ?></small>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class=" ri-shopping-bag-line text-muted"></i>
                                <p class="text-muted mt-2 mb-0">Este producto no tiene imágenes asociadas.</p>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class=" ri-shopping-bag-line me-2"></i>
                                Variantes del Producto
                            </h5>
                            <span class="badge bg-info"><?php echo e($producto->variants->count()); ?> variantes</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->variants->isNotEmpty()): ?>
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Variante</th>
                                            <th class="text-center">Stock</th>
                                            <th class="text-center">Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $producto->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php
                                                        $values = null;
                                                        if (is_array($variant->values)) {
                                                            $values = $variant->values;
                                                        } elseif (is_string($variant->values)) {
                                                            $values = json_decode($variant->values, true);
                                                        } else {
                                                            $values = (array) $variant->values;
                                                        }

                                                        // Si la decodificación falló o no es array, envolver en array
                                                        if (!is_array($values)) {
                                                            $values = [$variant->values];
                                                        }
                                                    ?>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge bg-light text-dark me-1"><?php echo e($value); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge bg-secondary"><?php echo e($variant->quantity); ?></span>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo $this->getVariantStockStatus($variant->quantity); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <i class=" ri-shopping-bag-line text-muted"></i>
                                <p class="text-muted mt-2 mb-0">Este producto no tiene variantes configuradas.</p>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Inventario
                        </h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless mb-0">
                            <tr>
                                <td class="fw-semibold">Política de Inventario:</td>
                                <td>
                                    <span class="badge bg-info"><?php echo e($this->inventoryPolicyText); ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-semibold">Stock Total:</td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->hasVariants): ?>
                                        <span class="badge bg-success"><?php echo e($this->totalVariantStock); ?> unidades</span>
                                        <div class="small text-muted">(en variantes)</div>
                                    <?php else: ?>
                                        <span class="badge bg-success"><?php echo e($producto->quantity); ?> unidades</span>
                                        <div class="small text-muted">(producto principal)</div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-semibold">Alerta de Stock:</td>
                                <td>
                                    <span class="badge bg-warning"><?php echo e($producto->quantity_alert); ?> unidades</span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            SEO
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($producto->seo): ?>
                            <table class="table table-borderless mb-3">
                                <tr>
                                    <td class="fw-semibold">Título Meta:</td>
                                    <td class="text-dark"><?php echo e($producto->seo->meta_title ?? 'No configurado'); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Descripción Meta:</td>
                                    <td class="text-muted"><?php echo e($producto->seo->meta_description ?? 'No configurada'); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Slug:</td>
                                    <td>
                                        <code class="text-primary"><?php echo e($producto->seo->slug ?? 'No configurado'); ?></code>
                                    </td>
                                </tr>
                            </table>

                            <div class="border rounded p-3 bg-light">
                                <h6 class="text-primary mb-2" style="color: #1a0dab;">
                                    <?php echo e($producto->seo->meta_title ?? $producto->name); ?>

                                </h6>
                                <p class="text-success mb-2" style="color: #006621;">
                                    <?php echo e(url('/')); ?>/producto/<?php echo e($producto->seo->slug ?? $producto->code); ?>

                                </p>
                                <p class="text-muted small mb-0">
                                    <?php echo e($producto->seo->meta_description ?? Str::limit($producto->description, 160)); ?>

                                </p>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info mb-0">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                No hay configuración SEO disponible para este producto.
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Acciones
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('admin.productos.index')); ?>" class="btn btn-outline-secondary">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Volver a Productos
                            </a>
                            <a href="<?php echo e(route('admin.productos.edit', $producto->id)); ?>" class="btn btn-primary">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Editar Producto
                            </a>
                            <button type="button" class="btn btn-outline-danger" onclick="confirmDelete()">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Eliminar Producto
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmDelete() {
    if (confirm('¿Está seguro de eliminar este producto? Esta acción no se puede deshacer.')) {
        window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('deleteProduct', <?php echo e($producto->id); ?>);
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.card {
    border-radius: 0.5rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    border: 1px solid rgba(0, 0, 0, 0.125);
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid rgba(0, 0, 0, 0.125);
    border-radius: calc(0.5rem - 1px) calc(0.5rem - 1px) 0 0 !important;
    padding: 1rem 1.25rem;
}

.card-header h5 {
    margin: 0;
    font-size: 1.1rem;
    font-weight: 600;
}

.table-borderless td {
    padding: 0.5rem 0;
}

.table-borderless tr:first-child td {
    padding-top: 0;
}

.table-borderless tr:last-child td {
    padding-bottom: 0;
}

.badge {
    font-weight: 500;
}

.text-muted {
    color: #6c757d !important;
}

.text-dark {
    color: #212529 !important;
}

.btn-outline-danger:hover {
    color: #fff;
    background-color: #dc3545;
    border-color: #dc3545;
}

.page-title-box {
    background-color: #fff;
    border-radius: 0.5rem;
    padding: 1rem 1.25rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}
</style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/productos/producto-detail-mejorado.blade.php ENDPATH**/ ?>