<div>
    <?php $__env->startSection('title', 'Dashboard'); ?>

    <?php $__env->startPush('styles'); ?>
    <style>
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.15) !important;
        }
        .stat-icon {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 0.5rem;
        }
        .chart-container {
            min-height: 350px;
        }
        .order-card {
            transition: all 0.3s ease;
        }
        .order-card:hover {
            background-color: rgba(105, 108, 255, 0.04);
        }
        .product-item {
            transition: all 0.3s ease;
        }
        .product-item:hover {
            background-color: rgba(105, 108, 255, 0.04);
        }
        .alert-card {
            border-left: 4px solid;
        }
        .employee-ranking-card {
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        .employee-ranking-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.15) !important;
        }
        .employee-ranking-card.gold-medal {
            border-color: #FFD700;
            background: linear-gradient(135deg, rgba(255, 215, 0, 0.1) 0%, rgba(255, 215, 0, 0.05) 100%);
        }
        .employee-ranking-card.silver-medal {
            border-color: #C0C0C0;
            background: linear-gradient(135deg, rgba(192, 192, 192, 0.1) 0%, rgba(192, 192, 192, 0.05) 100%);
        }
        .employee-ranking-card.bronze-medal {
            border-color: #CD7F32;
            background: linear-gradient(135deg, rgba(205, 127, 50, 0.1) 0%, rgba(205, 127, 50, 0.05) 100%);
        }
        .medal-icon {
            font-size: 3rem;
        }
        .top-employee-badge {
            margin-top: 0.5rem;
        }
    </style>
    <?php $__env->stopPush(); ?>

    <!-- Header con Selector de Período -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                <div>
                    <h4 class="fw-bold mb-1">Dashboard Administrativo</h4>
                    <p class="text-muted mb-0">Período: <span class="fw-medium"><?php echo e($dateRangeOptions[$dateRange]); ?></span></p>
                </div>
                <div class="d-flex align-items-center gap-2">
                    <div class="btn-group" role="group">
                        <button class="btn btn-sm <?php echo e($dateRange === 'week' ? 'btn-primary' : 'btn-outline-primary'); ?>"
                                wire:click="updateDateRange('week')">Semana</button>
                        <button class="btn btn-sm <?php echo e($dateRange === 'month' ? 'btn-primary' : 'btn-outline-primary'); ?>"
                                wire:click="updateDateRange('month')">Mes</button>
                        <button class="btn btn-sm <?php echo e($dateRange === 'quarter' ? 'btn-primary' : 'btn-outline-primary'); ?>"
                                wire:click="updateDateRange('quarter')">Trimestre</button>
                        <button class="btn btn-sm <?php echo e($dateRange === 'year' ? 'btn-primary' : 'btn-outline-primary'); ?>"
                                wire:click="updateDateRange('year')">Año</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Alertas -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($alerts->count() > 0): ?>
    <div class="row mb-4">
        <div class="col-12">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card alert-card border-0 mb-2 alert-<?php echo e($alert['type']); ?>">
                <div class="card-body py-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-3">
                            <div class="stat-icon bg-<?php echo e($alert['type']); ?>">
                                <i class="<?php echo e($alert['icon']); ?> text-white fs-5"></i>
                            </div>
                            <div>
                                <h6 class="mb-0 fw-semibold"><?php echo e($alert['title']); ?></h6>
                                <p class="mb-0 text-muted small"><?php echo e($alert['message']); ?></p>
                            </div>
                        </div>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($alert['action'])): ?>
                        <a href="<?php echo e($alert['action']); ?>" class="btn btn-sm btn-<?php echo e($alert['type']); ?>">
                            Ver detalles
                        </a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Tarjetas de Estadísticas Principales -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2">Ventas Totales</h6>
                            <h3 class="mb-1 text-success"><?php echo e(format_money($stats['total_sales'])); ?></h3>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['sales_growth'] != 0): ?>
                            <small class="text-<?php echo e($stats['sales_growth'] >= 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['sales_growth'] >= 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['sales_growth'])); ?>% vs período anterior
                            </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="stat-icon bg-success">
                            <i class="ri-money-dollar-circle-line text-white fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2">Total Pedidos</h6>
                            <h3 class="mb-1 text-primary"><?php echo e(number_format($stats['total_orders'])); ?></h3>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['orders_growth'] != 0): ?>
                            <small class="text-<?php echo e($stats['orders_growth'] >= 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['orders_growth'] >= 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['orders_growth'])); ?>% vs período anterior
                            </small>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="stat-icon bg-primary">
                            <i class="ri-shopping-cart-line text-white fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2">Valor Promedio</h6>
                            <h3 class="mb-1 text-warning"><?php echo e(format_money($stats['avg_order_value'])); ?></h3>
                            <small class="text-muted">Por pedido</small>
                        </div>
                        <div class="stat-icon bg-warning">
                            <i class="ri-calculator-line text-white fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2">Tasa Conversión</h6>
                            <h3 class="mb-1 text-info"><?php echo e($stats['conversion_rate']); ?>%</h3>
                            <small class="text-muted">Pedidos completados</small>
                        </div>
                        <div class="stat-icon bg-info">
                            <i class="ri-percent-line text-white fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráfico de Ventas y Métricas de Pedidos -->
    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Ventas - <?php echo e($dateRangeOptions[$dateRange]); ?></h5>
                        <span class="badge bg-label-primary"><?php echo e($dateRangeOptions[$dateRange]); ?></span>
                    </div>
                </div>
                <div class="card-body">
                    <div id="salesChart" style="min-height: 300px;" wire:ignore></div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">Estado de Pedidos</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-column gap-3">
                        <div class="d-flex align-items-center justify-content-between p-3 rounded bg-light">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-success">
                                    <i class="ri-check-line text-white"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Completados</h6>
                                    <small class="text-muted"><?php echo e($stats['completed_orders']); ?> pedidos</small>
                                </div>
                            </div>
                            <h4 class="mb-0 text-success"><?php echo e($stats['completed_orders']); ?></h4>
                        </div>

                        <div class="d-flex align-items-center justify-content-between p-3 rounded bg-light">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-warning">
                                    <i class="ri-time-line text-white"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Pendientes</h6>
                                    <small class="text-muted">Requieren atención</small>
                                </div>
                            </div>
                            <h4 class="mb-0 text-warning"><?php echo e($stats['pending_orders']); ?></h4>
                        </div>

                        <div class="d-flex align-items-center justify-content-between p-3 rounded bg-light">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-info">
                                    <i class="ri-shopping-bag-line text-white"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Productos</h6>
                                    <small class="text-muted">En catálogo</small>
                                </div>
                            </div>
                            <h4 class="mb-0 text-info"><?php echo e($stats['total_products']); ?></h4>
                        </div>

                        <div class="d-flex align-items-center justify-content-between p-3 rounded bg-light">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-secondary">
                                    <i class="ri-timer-line text-white"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Tiempo Entrega</h6>
                                    <small class="text-muted">Promedio</small>
                                </div>
                            </div>
                            <h4 class="mb-0"><?php echo e($performance['avg_delivery_time']); ?> días</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Métricas de Rendimiento y Clientes -->
    <div class="row g-4 mb-4">
        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">Métricas de Rendimiento</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-column gap-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Clientes Recurrentes</h6>
                                <small class="text-muted">Con múltiples pedidos</small>
                            </div>
                            <h4 class="mb-0 text-primary"><?php echo e(number_format($performance['repeat_customers'], 1)); ?>%</h4>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Tasa Cancelación</h6>
                                <small class="text-muted">Pedidos cancelados</small>
                            </div>
                            <h4 class="mb-0 text-danger"><?php echo e(number_format($performance['cancellation_rate'], 1)); ?>%</h4>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Rotación Inventario</h6>
                                <small class="text-muted">Veces al mes</small>
                            </div>
                            <h4 class="mb-0 text-success"><?php echo e(format_money($performance['inventory_turnover'], 1)); ?></h4>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Tiempo Respuesta</h6>
                                <small class="text-muted">Soporte al cliente</small>
                            </div>
                            <h4 class="mb-0 text-warning"><?php echo e($performance['avg_response_time']); ?> min</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">Top Productos</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-column gap-2">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="product-item d-flex align-items-center justify-content-between p-2 rounded">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-label-primary">
                                    <span class="fw-bold text-primary"><?php echo e($index + 1); ?></span>
                                </div>
                                <div>
                                    <h6 class="mb-0"><?php echo e($product->name); ?></h6>
                                    <small class="text-muted"><?php echo e($product->total_sold); ?> vendidos</small>
                                </div>
                            </div>
                            <span class="badge bg-label-success"><?php echo e($product->total_sold); ?></span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">Top Clientes</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-column gap-2">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $topCustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="product-item d-flex align-items-center justify-content-between p-2 rounded">
                            <div class="d-flex align-items-center gap-2">
                                <div class="stat-icon bg-label-success">
                                    <span class="fw-bold text-success"><?php echo e($index + 1); ?></span>
                                </div>
                                <div>
                                    <h6 class="mb-0"><?php echo e($customer->name); ?></h6>
                                    <small class="text-muted"><?php echo e($customer->total_orders); ?> pedidos</small>
                                </div>
                            </div>
                            <span class="badge bg-label-primary"><?php echo e(format_money($customer->total_spent)); ?></span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Empleados -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Top Empleados - <?php echo e($dateRangeOptions[$dateRange]); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($topEmployees->count() > 0): ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $topEmployees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4">
                                <div class="card employee-ranking-card h-100 <?php echo e($index === 0 ? 'gold-medal' : ($index === 1 ? 'silver-medal' : ($index === 2 ? 'bronze-medal' : ''))); ?>">
                                    <div class="card-body text-center">
                                        <div class="medal-icon mb-3">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($index === 0): ?>
                                                <i class="ri-medal-fill text-warning"></i>
                                            <?php elseif($index === 1): ?>
                                                <i class="ri-medal-fill text-secondary"></i>
                                            <?php else: ?>
                                                <i class="ri-medal-fill text-warning" style="color: #CD7F32 !important;"></i>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <h5 class="mb-2 fw-bold"><?php echo e($employee->name); ?></h5>
                                        <div class="top-employee-badge">
                                            <span class="badge bg-<?php echo e($index === 0 ? 'warning' : ($index === 1 ? 'secondary' : 'info')); ?>">
                                                <?php echo e($employee->total_deliveries); ?> entregas
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <i class="ri-information-line me-2"></i>
                                    No hay empleados con entregas en este período
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Pedidos Recientes -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Pedidos Recientes</h5>
                        <a href="<?php echo e(route('admin.pedidos.index')); ?>" class="btn btn-sm btn-primary">
                            Ver todos
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead>
                                <tr>
                                    <th>Pedido</th>
                                    <th>Cliente</th>
                                    <th>Fecha</th>
                                    <th>Total</th>
                                    <th>Estado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="order-card">
                                    <td>
                                        <h6 class="mb-0">#<?php echo e($order->id); ?></h6>
                                    </td>
                                    <td>
                                        <div>
                                            <h6 class="mb-0"><?php echo e($order->user->name ?? 'N/A'); ?></h6>
                                            <small class="text-muted"><?php echo e($order->user->email ?? 'N/A'); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <small><?php echo e($order->created_at->format('d/m/Y H:i')); ?></small>
                                    </td>
                                    <td>
                                        <h6 class="mb-0 text-success"><?php echo e(format_money($order->total_usd)); ?></h6>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($order->estado === 'entregado' ? 'success' : ($order->estado === 'pagado' ? 'primary' : 'warning')); ?>">
                                            <?php echo e(ucfirst($order->estado)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.pedidos.show', $order->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            Ver
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Acciones Rápidas -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Acciones Rápidas</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $quickActions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3">
                            <a href="<?php echo e(route($action['route'])); ?>" class="card text-decoration-none h-100">
                                <div class="card-body text-center">
                                    <div class="stat-icon bg-<?php echo e($action['color']); ?> mx-auto mb-3">
                                        <i class="<?php echo e($action['icon']); ?> text-white fs-4"></i>
                                    </div>
                                    <h6 class="mb-1"><?php echo e($action['title']); ?></h6>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($action['extra'])): ?>
                                    <small class="text-muted"><?php echo e($action['extra']); ?></small>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Función para crear el gráfico inicial
            function initializeChart() {
                var salesChartEl = document.getElementById('salesChart');
                if (!salesChartEl) return;

                // Verificar si ya existe una instancia del gráfico y destruirla si es necesario
                if (salesChartEl._chart) {
                    salesChartEl._chart.destroy();
                    delete salesChartEl._chart;
                }

                const salesData = <?php echo json_encode($salesChart, 15, 512) ?>;

                if (!salesData || salesData.length === 0) {
                    salesChartEl.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="height: 300px;"><p class="text-muted">No hay datos para el período seleccionado</p></div>';
                    return;
                }

                const salesChartConfig = {
                    chart: {
                        height: 300,
                        type: 'area',
                        toolbar: {
                            show: false
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 3
                    },
                    legend: {
                        show: true,
                        position: 'top'
                    },
                    series: [{
                        name: 'Ventas ($)',
                        data: salesData.map(item => parseFloat(item.sales || 0))
                    }, {
                        name: 'Pedidos',
                        data: salesData.map(item => parseInt(item.orders || 0))
                    }],
                    xaxis: {
                        categories: salesData.map(item => item.period || 'N/A'),
                        axisBorder: {
                            show: false
                        },
                        axisTicks: {
                            show: false
                        },
                        labels: {
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: {
                                colors: '#9b9ea2',
                                fontSize: '13px',
                                fontFamily: 'Inter'
                            }
                        }
                    },
                    grid: {
                        show: true,
                        borderColor: '#f0f2f8',
                        strokeDashArray: 6,
                        padding: {
                            left: 0,
                            right: 0
                        }
                    },
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shade: 'light',
                            type: 'vertical',
                            shadeIntensity: 0.25,
                            gradientToColors: ['#7367f0'],
                            inverseColors: true,
                            opacityFrom: 0.8,
                            opacityTo: 0.1,
                            stops: [0, 100]
                        }
                    }
                };

                if (salesChartEl._chart) {
                    salesChartEl._chart.destroy();
                }
                const salesChart = new ApexCharts(salesChartEl, salesChartConfig);
                salesChart.render();
                salesChartEl._chart = salesChart;
            }

            // Crear gráfico inicial
            initializeChart();

            // Función para actualizar el gráfico con nuevos datos
            function updateChartWithNewData(chartData) {
                var salesChartEl = document.getElementById('salesChart');
                if (salesChartEl && salesChartEl._chart && Array.isArray(chartData)) {
                    salesChartEl._chart.updateSeries([{
                        name: 'Ventas ($)',
                        data: chartData.map(item => parseFloat(item.sales || 0))
                    }, {
                        name: 'Pedidos',
                        data: chartData.map(item => parseInt(item.orders || 0))
                    }]);
                    salesChartEl._chart.updateOptions({
                        xaxis: {
                            categories: chartData.map(item => item.period || 'N/A')
                        }
                    });
                }
            }

            // Escuchar evento de actualización de gráfico desde Livewire

                Livewire.on('updateChart', (event) => {
                    console.log('Evento updateChart recibido:', event);
                    setTimeout(() => {
                        if (event[0] && event[0].chartData) {
                            updateChartWithNewData(event[0].chartData);
                        }
                    }, 100);
                });


            // También escuchar cuando Livewire se actualiza
            document.addEventListener('livewire:updated', () => {
                // Verificar si hay datos actualizados en el componente
                if (window.salesChartData) {
                    updateChartWithNewData(window.salesChartData);
                }
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/dashboard-mejorado.blade.php ENDPATH**/ ?>