<div wire:id="checkout-component">
    <?php $__env->startSection('title', 'Finalizar Compra'); ?>

    <style>
        /* ===== Progress Steps Velzon ===== */
        .checkout-progress {
            position: relative;
            padding: 1.5rem 0;
        }

        .checkout-progress::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 15%;
            right: 15%;
            height: 3px;
            background: linear-gradient(90deg, #e9ecef 0%, #e9ecef 100%);
            transform: translateY(-50%);
            z-index: 0;
            border-radius: 3px;
        }

        .checkout-progress .progress-line {
            position: absolute;
            top: 50%;
            left: 15%;
            height: 3px;
            background: linear-gradient(90deg, var(--vz-primary) 0%, var(--vz-success) 100%);
            transform: translateY(-50%);
            z-index: 1;
            border-radius: 3px;
            transition: width 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .step-item {
            position: relative;
            z-index: 2;
            text-align: center;
            flex: 1;
        }

        .step-icon-wrap {
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: #fff;
            border: 3px solid #e9ecef;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 12px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .step-icon-wrap i {
            font-size: 1.5rem;
            color: #878a99;
            transition: all 0.3s ease;
        }

        .step-item.active .step-icon-wrap {
            border-color: var(--vz-primary);
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            transform: scale(1.1);
            box-shadow: 0 8px 25px rgba(64, 81, 137, 0.35);
            animation: pulse-step 2s infinite;
        }

        .step-item.active .step-icon-wrap i {
            color: #fff;
        }

        .step-item.completed .step-icon-wrap {
            border-color: var(--vz-success);
            background: linear-gradient(135deg, var(--vz-success) 0%, #28a745 100%);
            box-shadow: 0 4px 15px rgba(25, 135, 84, 0.3);
        }

        .step-item.completed .step-icon-wrap i {
            color: #fff;
        }

        .step-title {
            font-size: 0.85rem;
            font-weight: 600;
            color: #878a99;
            transition: all 0.3s ease;
        }

        .step-item.active .step-title,
        .step-item.completed .step-title {
            color: var(--vz-dark);
        }

        @keyframes pulse-step {
            0%, 100% { box-shadow: 0 8px 25px rgba(64, 81, 137, 0.35); }
            50% { box-shadow: 0 8px 35px rgba(64, 81, 137, 0.5); }
        }

        /* ===== Form Styles Velzon ===== */
        .form-floating-icon {
            position: relative;
        }

        .form-floating-icon .form-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--vz-primary);
            font-size: 1.1rem;
            z-index: 5;
        }

        .form-floating-icon .form-control,
        .form-floating-icon .form-select {
            padding-left: 42px;
            border-radius: 8px;
            border: 1.5px solid #e9ecef;
            transition: all 0.3s ease;
            background-color: #fafbfc;
        }

        .form-floating-icon .form-control:focus,
        .form-floating-icon .form-select:focus {
            border-color: var(--vz-primary);
            box-shadow: 0 0 0 3px rgba(64, 81, 137, 0.15);
            background-color: #fff;
        }

        .form-floating-icon textarea.form-control {
            padding-top: 12px;
        }

        .form-floating-icon.textarea-icon .form-icon {
            top: 20px;
        }

        .form-label-velzon {
            font-weight: 600;
            color: var(--vz-dark);
            margin-bottom: 6px;
            font-size: 0.875rem;
        }

        .input-group-velzon .input-group-text {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            border: none;
            color: #fff;
            border-radius: 8px 0 0 8px;
        }

        .input-group-velzon .form-control {
            border-radius: 0 8px 8px 0;
            border: 1.5px solid #e9ecef;
            border-left: none;
        }

        .input-group-velzon .form-control:focus {
            border-color: var(--vz-primary);
            box-shadow: 0 0 0 3px rgba(64, 81, 137, 0.15);
        }

        /* ===== Payment Method Cards ===== */
        .payment-method-card {
            border: 2px solid #e9ecef;
            border-radius: 16px;
            padding: 1.5rem;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            background: #fff;
            position: relative;
            overflow: hidden;
        }

        .payment-method-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--vz-primary) 0%, var(--vz-info) 100%);
            transform: scaleX(0);
            transition: transform 0.4s ease;
        }

        .payment-method-card:hover {
            border-color: var(--vz-primary);
            transform: translateY(-4px);
            box-shadow: 0 12px 35px rgba(64, 81, 137, 0.15);
        }

        .payment-method-card:hover::before {
            transform: scaleX(1);
        }

        .payment-method-card.selected {
            border-color: var(--vz-primary);
            background: linear-gradient(135deg, rgba(64, 81, 137, 0.05) 0%, rgba(92, 142, 212, 0.08) 100%);
            box-shadow: 0 8px 25px rgba(64, 81, 137, 0.2);
        }

        .payment-method-card.selected::before {
            transform: scaleX(1);
        }

        .payment-method-card .payment-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }

        .payment-method-card:hover .payment-icon {
            transform: scale(1.1);
        }

        .payment-icon.efectivo { background: linear-gradient(135deg, #28a74533 0%, #20c99733 100%); color: var(--vz-success); }
        .payment-icon.efectivo-bs { background: linear-gradient(135deg, #ffc10733 0%, #ff980033 100%); color: #f7b84b; }
        .payment-icon.transferencia { background: linear-gradient(135deg, #40519933 0%, #5c8ed433 100%); color: var(--vz-primary); }
        .payment-icon.pago-movil { background: linear-gradient(135deg, #0ab39c33 0%, #0dcaf033 100%); color: var(--vz-info); }

        .payment-check {
            position: absolute;
            top: 12px;
            right: 12px;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: var(--vz-success);
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.75rem;
            opacity: 0;
            transform: scale(0);
            transition: all 0.3s ease;
        }

        .payment-method-card.selected .payment-check {
            opacity: 1;
            transform: scale(1);
        }

        /* ===== Order Summary ===== */
        .order-summary-card {
            border: none;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 5px 25px rgba(0,0,0,0.1);
        }

        .order-summary-header {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 50%, var(--vz-info) 100%);
            padding: 1.25rem 1.5rem;
            position: relative;
            overflow: hidden;
        }

        .order-summary-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 100px;
            height: 200%;
            background: rgba(255,255,255,0.1);
            transform: rotate(25deg);
        }

        .order-summary-header h5 {
            color: #fff;
            margin: 0;
            font-weight: 600;
            position: relative;
            z-index: 1;
        }

        .order-summary-header .cart-badge {
            background: rgba(255,255,255,0.2);
            color: #fff;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
        }

        .order-item {
            display: flex;
            align-items: center;
            padding: 1rem 0;
            border-bottom: 1px solid #f3f3f9;
            transition: all 0.3s ease;
        }

        .order-item:hover {
            background: #fafbfc;
            margin: 0 -1rem;
            padding: 1rem;
            border-radius: 8px;
        }

        .order-item:last-child {
            border-bottom: none;
        }

        .order-item-img {
            width: 55px;
            height: 55px;
            border-radius: 10px;
            object-fit: cover;
            border: 2px solid #f3f3f9;
        }

        .order-item-placeholder {
            width: 55px;
            height: 55px;
            border-radius: 10px;
            background: linear-gradient(135deg, #f3f3f9 0%, #e9ecef 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #878a99;
        }

        .order-summary-scroll {
            max-height: 280px;
            overflow-y: auto;
            padding-right: 8px;
        }

        .order-summary-scroll::-webkit-scrollbar {
            width: 5px;
        }

        .order-summary-scroll::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }

        .order-summary-scroll::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, var(--vz-primary) 0%, #5c8ed4 100%);
            border-radius: 10px;
        }

        .total-section {
            background: linear-gradient(135deg, #f8f9fc 0%, #f3f3f9 100%);
            border-radius: 12px;
            padding: 1rem;
            margin-top: 1rem;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed #e9ecef;
        }

        .total-row:last-child {
            border-bottom: none;
        }

        .total-row.grand-total {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            margin: 0.5rem -1rem -1rem;
            padding: 1rem;
            border-radius: 0 0 12px 12px;
            color: #fff;
        }

        /* ===== Trust Badges ===== */
        .trust-badges {
            display: flex;
            justify-content: center;
            gap: 1rem;
            padding: 1rem 0;
            margin-top: 1rem;
            border-top: 1px solid #f3f3f9;
        }

        .trust-badge {
            text-align: center;
            padding: 0.75rem 1rem;
            background: linear-gradient(135deg, #f8f9fc 0%, #fff 100%);
            border-radius: 12px;
            flex: 1;
            transition: all 0.3s ease;
        }

        .trust-badge:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        }

        .trust-badge i {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            display: block;
        }

        .trust-badge.security i { color: var(--vz-success); }
        .trust-badge.shipping i { color: var(--vz-info); }
        .trust-badge.guarantee i { color: var(--vz-warning); }

        .trust-badge span {
            font-size: 0.7rem;
            font-weight: 600;
            color: var(--vz-dark);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* ===== Step Content Animation ===== */
        .step-content {
            animation: fadeSlideIn 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @keyframes fadeSlideIn {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .step-header {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #f3f3f9;
        }

        .step-header-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
        }

        .step-header-icon i {
            font-size: 1.5rem;
            color: #fff;
        }

        .step-header h5 {
            margin: 0;
            font-weight: 600;
            color: var(--vz-dark);
        }

        .step-header p {
            margin: 0;
            font-size: 0.875rem;
            color: #878a99;
        }

        /* ===== Payment Breakdown ===== */
        .payment-breakdown-item {
            border: 2px solid #e9ecef;
            border-radius: 14px;
            padding: 1.25rem;
            margin-bottom: 1rem;
            background: #fff;
            transition: all 0.3s ease;
            position: relative;
        }

        .payment-breakdown-item:hover {
            border-color: var(--vz-primary);
            box-shadow: 0 5px 20px rgba(64, 81, 137, 0.12);
        }

        .payment-breakdown-item .method-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.85rem;
        }

        .method-badge.efectivo { background: #28a74520; color: var(--vz-success); }
        .method-badge.efectivo-bs { background: #ffc10720; color: #d9a406; }
        .method-badge.transferencia { background: #40519920; color: var(--vz-primary); }
        .method-badge.pago-movil { background: #0ab39c20; color: var(--vz-info); }

        .payment-methods-container {
            max-height: 350px;
            overflow-y: auto;
            padding-right: 10px;
        }

        .payment-methods-container::-webkit-scrollbar {
            width: 5px;
        }

        .payment-methods-container::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }

        .payment-methods-container::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, var(--vz-primary) 0%, #5c8ed4 100%);
            border-radius: 10px;
        }

        .distributed-summary {
            background: linear-gradient(135deg, #f8f9fc 0%, #e8f4f8 100%);
            border-radius: 14px;
            padding: 1.25rem;
            border: 2px solid #e9ecef;
        }

        .add-payment-card {
            border: 2px dashed #d4d4d4;
            border-radius: 14px;
            background: linear-gradient(135deg, #fafbfc 0%, #f8f9fc 100%);
            transition: all 0.3s ease;
        }

        .add-payment-card:hover {
            border-color: var(--vz-primary);
            background: #fff;
        }

        /* ===== Buttons Velzon ===== */
        .btn-velzon-primary {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            border: none;
            color: #fff;
            padding: 12px 28px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(64, 81, 137, 0.3);
        }

        .btn-velzon-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(64, 81, 137, 0.4);
            background: linear-gradient(135deg, #5066a8 0%, #4a7bc4 100%);
            color: #fff;
        }

        .btn-velzon-success {
            background: linear-gradient(135deg, var(--vz-success) 0%, #28a745 100%);
            border: none;
            color: #fff;
            padding: 14px 32px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(25, 135, 84, 0.3);
        }

        .btn-velzon-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(25, 135, 84, 0.4);
            color: #fff;
        }

        .btn-velzon-outline {
            border: 2px solid #e9ecef;
            background: #fff;
            color: var(--vz-dark);
            padding: 12px 28px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-velzon-outline:hover {
            border-color: var(--vz-primary);
            color: var(--vz-primary);
            background: rgba(64, 81, 137, 0.05);
        }

        /* ===== Location Styles ===== */
        .location-btn {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            border: none;
            color: #fff;
            border-radius: 0 8px 8px 0;
            padding: 0 1.25rem;
            transition: all 0.3s ease;
        }

        .location-btn:hover {
            background: linear-gradient(135deg, #5066a8 0%, #4a7bc4 100%);
            color: #fff;
        }

        .location-accuracy-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .location-accuracy-high {
            background: #28a74520;
            color: var(--vz-success);
        }

        .location-accuracy-medium {
            background: #ffc10720;
            color: #d9a406;
        }

        .location-accuracy-low {
            background: #dc354520;
            color: var(--vz-danger);
        }

        .location-help-panel {
            background: linear-gradient(135deg, #f8f9fc 0%, #e8f4f8 100%);
            border-radius: 12px;
            padding: 1rem 1.25rem;
            margin-top: 1rem;
            border-left: 4px solid var(--vz-info);
        }

        .location-help-panel h6 {
            color: var(--vz-dark);
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .location-help-panel ul {
            padding-left: 1.25rem;
            margin: 0;
        }

        .location-help-panel li {
            color: #6c757d;
            font-size: 0.85rem;
            margin-bottom: 4px;
        }

        .location-alert {
            display: flex;
            align-items: flex-start;
            gap: 12px;
            padding: 1rem;
            border-radius: 10px;
            margin-top: 0.75rem;
        }

        .location-alert-warning {
            background: #ffc10715;
            border: 1px solid #ffc10740;
        }

        .location-alert .alert-icon {
            font-size: 1.25rem;
            color: #d9a406;
        }

        .location-alert p {
            font-size: 0.85rem;
            color: #6c757d;
        }

        /* ===== Success Confirmation ===== */
        .confirmation-info-card {
            background: linear-gradient(135deg, #f8f9fc 0%, #fff 100%);
            border: 2px solid #e9ecef;
            border-radius: 14px;
            padding: 1.5rem;
            height: 100%;
        }

        .confirmation-info-card h6 {
            color: var(--vz-primary);
            font-weight: 600;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .confirmation-alert {
            background: linear-gradient(135deg, #0ab39c15 0%, #0dcaf015 100%);
            border: 2px solid #0ab39c40;
            border-radius: 14px;
            padding: 1.25rem;
        }

        .confirmation-alert i {
            color: var(--vz-info);
        }

        /* ===== Info Alert ===== */
        .info-alert-velzon {
            background: linear-gradient(135deg, #40519915 0%, #5c8ed415 100%);
            border: none;
            border-left: 4px solid var(--vz-primary);
            border-radius: 0 12px 12px 0;
            padding: 1.25rem;
        }

        .info-alert-velzon .alert-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 1.25rem;
        }

        /* ===== Empty State ===== */
        .empty-payment-state {
            text-align: center;
            padding: 3rem 2rem;
            background: linear-gradient(135deg, #f8f9fc 0%, #fff 100%);
            border-radius: 14px;
            border: 2px dashed #d4d4d4;
        }

        .empty-payment-state i {
            font-size: 3rem;
            color: #d4d4d4;
            margin-bottom: 1rem;
        }

        .empty-payment-state p {
            color: #878a99;
            margin: 0;
        }

        /* ===== Page Header ===== */
        .checkout-page-header {
            background: linear-gradient(135deg, var(--vz-primary) 0%, #5c8ed4 50%, var(--vz-info) 100%);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            position: relative;
            overflow: hidden;
        }

        .checkout-page-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -10%;
            width: 300px;
            height: 300px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
        }

        .checkout-page-header::after {
            content: '';
            position: absolute;
            bottom: -30%;
            left: 10%;
            width: 150px;
            height: 150px;
            background: rgba(255,255,255,0.05);
            border-radius: 50%;
        }

        .checkout-page-header h2 {
            color: #fff;
            font-weight: 700;
            margin-bottom: 0.5rem;
            position: relative;
            z-index: 1;
        }

        .checkout-page-header p {
            color: rgba(255,255,255,0.85);
            margin: 0;
            position: relative;
            z-index: 1;
        }

        .checkout-page-header .cart-count-badge {
            background: rgba(255,255,255,0.2);
            color: #fff;
            padding: 6px 16px;
            border-radius: 25px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        /* ===== Card Velzon ===== */
        .card-velzon {
            border: none;
            border-radius: 16px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            overflow: hidden;
        }

        .card-velzon .card-body {
            padding: 1.75rem;
        }
    </style>

    <section class="section bg-light py-4">
        <div class="container">
            <!-- Page Header -->
            <div class="checkout-page-header">
                <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                    <div>
                        <h2><i class="ri ri-shopping-bag-3-line me-2"></i>Finalizar Compra</h2>
                        <p>Estás a pocos pasos de completar tu pedido</p>
                    </div>
                    <div class="cart-count-badge">
                        <i class="ri ri-cart"></i>
                        <?php echo e($cartCount); ?> productos
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-lg-8">
                    <!-- Progress Steps -->
                    <div class="card card-velzon mb-4">
                        <div class="card-body">
                            <div class="checkout-progress d-flex justify-content-between align-items-start">
                                <div class="progress-line" style="width: <?php echo e($step == 1 ? '0%' : ($step == 2 ? '35%' : '70%')); ?>;"></div>

                                <div class="step-item <?php echo e($step >= 1 ? 'active' : ''); ?> <?php echo e($step > 1 ? 'completed' : ''); ?>">
                                    <div class="step-icon-wrap">
                                        <i class="<?php echo e($step > 1 ? 'ri-check-line' : 'ri-user-line'); ?>"></i>
                                    </div>
                                    <div class="step-title">Información</div>
                                </div>

                                <div class="step-item <?php echo e($step >= 2 ? 'active' : ''); ?> <?php echo e($step > 2 ? 'completed' : ''); ?>">
                                    <div class="step-icon-wrap">
                                        <i class="<?php echo e($step > 2 ? 'ri-check-line' : 'ri-wallet-3-line'); ?>"></i>
                                    </div>
                                    <div class="step-title">Método de Pago</div>
                                </div>

                                <div class="step-item <?php echo e($step >= 3 ? 'active' : ''); ?>">
                                    <div class="step-icon-wrap">
                                        <i class="ri ri-checkbox-circle-line"></i>
                                    </div>
                                    <div class="step-title">Confirmación</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Step Content -->
                    <div class="card card-velzon">
                        <div class="card-body">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($step == 1): ?>
                                <!-- Step 1: Personal Information -->
                                <div class="step-content">
                                    <div class="step-header">
                                        <div class="step-header-icon">
                                            <i class="ri ri-map-pin-user-line"></i>
                                        </div>
                                        <div>
                                            <h5>Información de Entrega</h5>
                                            <p>Completa tus datos para el envío</p>
                                        </div>
                                    </div>

                                    <div class="row g-4">
                                        <div class="col-md-6">
                                            <label class="form-label-velzon">
                                                <i class="ri ri-phone-line me-1 text-primary"></i>Teléfono *
                                            </label>
                                            <div class="form-floating-icon">
                                                <i class="ri ri-phone-line form-icon"></i>
                                                <input type="text"
                                                       class="form-control <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="telefono"
                                                       wire:model="telefono"
                                                       placeholder="Ingrese su número de teléfono">
                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label-velzon">
                                                <i class="ri ri-user-line me-1 text-primary"></i>Nombre Completo *
                                            </label>
                                            <div class="form-floating-icon">
                                                <i class="ri ri-user-line form-icon"></i>
                                                <input type="text"
                                                       class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="name"
                                                       wire:model="name"
                                                       placeholder="Ingrese su nombre completo">
                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label-velzon">
                                                <i class="ri ri-map-pin-line me-1 text-primary"></i>Dirección de Entrega *
                                            </label>
                                            <div class="input-group">
                                                <div class="form-floating-icon textarea-icon flex-grow-1">
                                                    <i class="ri ri-home form-icon"></i>
                                                    <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                              wire:model="address"
                                                              rows="3"
                                                              style="border-radius: 8px 0 0 8px;"
                                                              placeholder="Ingresa la dirección completa de entrega"></textarea>
                                                </div>
                                                <button type="button"
                                                        class="location-btn"
                                                        wire:click="getCurrentLocation"
                                                        wire:loading.attr="disabled"
                                                        title="Obtener ubicación actual">
                                                    <span wire:loading.remove wire:target="getCurrentLocation">
                                                        <i class="ri ri-crosshair-2-line fs-5"></i>
                                                    </span>
                                                    <span wire:loading wire:target="getCurrentLocation">
                                                        <i class="ri ri-loader-4-line ri-spin fs-5"></i>
                                                    </span>
                                                </button>
                                            </div>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($locationAccuracy): ?>
                                                <div class="mt-2">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($locationAccuracy <= 50): ?>
                                                        <span class="location-accuracy-badge location-accuracy-high">
                                                            <i class="ri ri-map-pin-2-line"></i> Alta precisión (<?php echo e($locationAccuracy); ?>m)
                                                        </span>
                                                    <?php elseif($locationAccuracy <= 100): ?>
                                                        <span class="location-accuracy-badge location-accuracy-medium">
                                                            <i class="ri ri-map-pin-2-line"></i> Precisión media (<?php echo e($locationAccuracy); ?>m)
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="location-accuracy-badge location-accuracy-low">
                                                            <i class="ri ri-map-pin-2-line"></i> Baja precisión (<?php echo e($locationAccuracy); ?>m)
                                                        </span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>

                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($locationAccuracy > 100): ?>
                                                    <div class="location-alert location-alert-warning">
                                                        <i class="ri ri-alert-line alert-icon"></i>
                                                        <div>
                                                            <strong>Ubicación aproximada</strong>
                                                            <p class="mb-0">La precisión de tu ubicación es baja. Te recomendamos revisar y corregir la dirección manualmente.</p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <div class="location-help-panel">
                                                <h6><i class="ri ri-lightbulb-line text-warning"></i> Consejos para mejor ubicación</h6>
                                                <ul class="mb-0">
                                                    <li>Habilita la ubicación en tu dispositivo cuando se te solicite</li>
                                                    <li>Asegúrate de estar en un lugar abierto con buena señal GPS</li>
                                                    <li>Evita ubicaciones interiores o subterráneas</li>
                                                    <li>Si la ubicación es incorrecta, corrígela manualmente</li>
                                                </ul>
                                            </div>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                            <!-- Hidden fields for coordinates -->
                                            <input type="hidden" wire:model="latitud" id="latitud">
                                            <input type="hidden" wire:model="longitud" id="longitud">
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                                        <a href="/front/cart" class="btn btn-velzon-outline">
                                            <i class="ri ri-shopping-cart-line me-2"></i>Volver al Carrito
                                        </a>
                                        <button wire:click="nextStep" class="btn btn-velzon-primary" wire:loading.attr="disabled">
                                            <span wire:loading.remove wire:target="nextStep">
                                                Continuar <i class="ri ri-arrow-right ms-2"></i>
                                            </span>
                                            <span wire:loading wire:target="nextStep">
                                                <i class="ri ri-loader-4-line ri-spin me-2"></i>Procesando...
                                            </span>
                                        </button>
                                    </div>
                                </div>

                            <?php elseif($step == 2): ?>
                                <!-- Step 2: Payment Method -->
                                <div class="step-content">
                                    <div class="step-header">
                                        <div class="step-header-icon">
                                            <i class="ri ri-wallet-3-line"></i>
                                        </div>
                                        <div>
                                            <h5>Método de Pago</h5>
                                            <p>Selecciona cómo deseas pagar tu pedido</p>
                                        </div>
                                    </div>

                                    <div class="info-alert-velzon d-flex align-items-start gap-3 mb-4">
                                        <div class="alert-icon">
                                            <i class="ri ri-wallet-line"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-1 fw-semibold">Pago Flexible</h6>
                                            <p class="mb-0 text-muted">Puedes pagar con múltiples métodos. Distribuye el monto total entre los métodos que prefieras.</p>
                                        </div>
                                    </div>

                                    <!-- Total Summary -->
                                    <div class="distributed-summary mb-4">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="text-muted">Total a pagar</span>
                                                <h3 class="mb-0 text-primary fw-bold"><?php echo e(format_money($cartTotal)); ?></h3>
                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(tasa()): ?>
                                                <div class="text-end">
                                                    <small class="text-muted d-block">Tasa del día</small>
                                                    <span class="badge bg-primary-subtle text-primary px-3 py-2">
                                                        <?php echo e(format_money(tasa()->usd_rate, 2)); ?> Bs/$
                                                    </span>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <?php if(tasa() && in_array($selectedPaymentMethod, ['Transferencia', 'Pago Móvil'])): ?>
                                            <div class="mt-2 pt-2 border-top">
                                                <small class="text-muted">
                                                    <i class="ri ri-currency-usd-circle me-1"></i>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company() && tasa()): ?>
                                                      <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currency === 'usd' && tasa()->usd_rate > 0): ?>
                                                        Equivalente: <strong><?php echo e(format_money($cartTotal * tasa()->usd_rate, 2)); ?> Bs</strong>
                                                        <?php else: ?>
                                                         Equivalente: <strong><?php echo e(format_money($cartTotal / tasa()->usd_rate, 2)); ?> $</strong>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </small>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <!-- Payment Breakdown -->
                                    <div class="mb-4">
                                        <h6 class="fw-semibold mb-3">
                                            <i class="ri ri-file-document me-2 text-primary"></i>Desglose de Pagos
                                        </h6>

                                        <div class="payment-methods-container">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($paymentMethods) > 0): ?>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="payment-breakdown-item">
                                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                                            <div>
                                                                <span class="method-badge <?php echo e($payment['method'] == 'Efectivo' ? 'efectivo' : ($payment['method'] == 'Efectivo Bs' ? 'efectivo-bs' : ($payment['method'] == 'Transferencia' ? 'transferencia' : 'pago-movil'))); ?>">
                                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo'): ?>
                                                                        <i class="ri ri-refund-2-line"></i>
                                                                    <?php elseif($payment['method'] == 'Efectivo Bs'): ?>
                                                                        <i class="ri ri-coins-line"></i>
                                                                    <?php elseif($payment['method'] == 'Transferencia'): ?>
                                                                        <i class="ri ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line"></i>
                                                                    <?php elseif($payment['method'] == 'Pago Móvil'): ?>
                                                                        <i class="ri ri-smartphone-line"></i>
                                                                    <?php else: ?>
                                                                        <i class="ri ri-wallet-line"></i>
                                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    <?php echo e($payment['method']); ?>

                                                                </span>
                                                                <div class="mt-2">
                                                                    <h5 class="mb-0 fw-bold">
                                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo Bs'): ?>
                                                                            <?php echo e(format_money($payment['amount'], 2)); ?>

                                                                        <?php else: ?>
                                                                            <?php echo e(format_money($payment['amount'])); ?>

                                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    </h5>
                                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo Bs'): ?>
                                                                        <small class="text-muted">(<?php echo e(format_money($payment['amount'])); ?>)</small>
                                                                    <?php elseif(in_array($payment['method'], ['Transferencia', 'Pago Móvil']) && tasa() && $currency === 'usd'): ?>
                                                                        <small class="text-muted">(<?php echo e(format_money($payment['amount'] * tasa()->usd_rate, 2)); ?> Bs)</small>
                                                                        <?php else: ?>
                                                                    <small class="text-muted">(<?php echo e(format_money($payment['amount'] / tasa()->usd_rate, 2)); ?> $)</small>
                                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                </div>
                                                            </div>
                                                            <button type="button"
                                                                    class="btn btn-sm btn-soft-danger rounded-circle"
                                                                    wire:click="removePaymentMethod(<?php echo e($index); ?>)"
                                                                    title="Eliminar método">
                                                                <i class="ri ri-close"></i>
                                                            </button>
                                                        </div>

                                                        <!-- Payment specific fields -->
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($payment['method'], ['Transferencia', 'Pago Móvil'])): ?>
                                                            <div class="bg-light rounded-3 p-3">
                                                                <div class="row g-3">
                                                                    <div class="col-md-6">
                                                                        <label class="form-label-velzon small">
                                                                            <i class="ri ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line me-1"></i>Banco *
                                                                        </label>
                                                                        <select class="form-select form-select-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.banco_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                wire:model="paymentMethods.<?php echo e($index); ?>.banco_id">
                                                                            <option value="">Selecciona un banco</option>
                                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->codigo .' | '.$banco->nombre); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                        </select>
                                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.banco_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="form-label-velzon small">
                                                                            <i class="ri ri-hashtag me-1"></i>Referencia *
                                                                        </label>
                                                                        <input type="text"
                                                                               class="form-control form-control-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.referencia'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                               wire:model="paymentMethods.<?php echo e($index); ?>.referencia"
                                                                               placeholder="Número de referencia">
                                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.referencia'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                    </div>
                                                                </div>

                                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Pago Móvil'): ?>
                                                                    <div class="row g-3 mt-1">
                                                                        <div class="col-md-6">
                                                                            <label class="form-label-velzon small">
                                                                                <i class="ri ri-id-card-line me-1"></i>Documento (CI/RIF) *
                                                                            </label>
                                                                            <input type="text"
                                                                                   class="form-control form-control-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.documento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                   wire:model="paymentMethods.<?php echo e($index); ?>.documento"
                                                                                   placeholder="V-12345678">
                                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.documento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <label class="form-label-velzon small">
                                                                                <i class="ri ri-phone-line me-1"></i>Teléfono *
                                                                            </label>
                                                                            <input type="text"
                                                                                   class="form-control form-control-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.numero_telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                   wire:model="paymentMethods.<?php echo e($index); ?>.numero_telefono"
                                                                                   placeholder="0414-1234567">
                                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.numero_telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                <?php elseif($payment['method'] == 'Transferencia'): ?>
                                                                    <div class="row g-3 mt-1">
                                                                        <div class="col-md-6">
                                                                            <label class="form-label-velzon small">
                                                                                <i class="ri ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-card-line me-1"></i>Número de Cuenta *
                                                                            </label>
                                                                            <input type="text"
                                                                                   class="form-control form-control-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.numero_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                   wire:model="paymentMethods.<?php echo e($index); ?>.numero_cuenta"
                                                                                   placeholder="Últimos 4 dígitos">
                                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.numero_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <label class="form-label-velzon small">
                                                                                <i class="ri ri-list-check me-1"></i>Tipo de Cuenta *
                                                                            </label>
                                                                            <select class="form-select form-select-sm <?php $__errorArgs = ['paymentMethods.'.$index.'.tipo_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                    wire:model="paymentMethods.<?php echo e($index); ?>.tipo_cuenta">
                                                                                <option value="">Selecciona el tipo</option>
                                                                                <option value="ahorro">Ahorro</option>
                                                                                <option value="corriente">Corriente</option>
                                                                            </select>
                                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods.'.$index.'.tipo_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                                <!-- Distributed Total -->
                                                <div class="distributed-summary mt-3">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <span class="fw-semibold">Distribuido:</span>
                                                        <span class="fs-5 fw-bold <?php echo e($distributedAmount > $cartTotal ? 'text-danger' : 'text-success'); ?>">
                                                            <?php echo e(format_money($distributedAmount)); ?>

                                                        </span>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center mt-2 pt-2 border-top">
                                                        <span class="text-muted">Restante:</span>
                                                        <span class="<?php echo e($remainingAmount < 0 ? 'text-danger fw-bold' : 'text-muted'); ?>">
                                                            <?php echo e(money(abs($remainingAmount))); ?>

                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($remainingAmount < 0): ?>
                                                                <i class="ri ri-error-warning-line ms-1"></i>
                                                            <?php elseif($remainingAmount == 0): ?>
                                                                <i class="ri ri-check-double-line text-success ms-1"></i>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </span>
                                                    </div>
                                                    <?php if(tasa() && count(array_filter($paymentMethods, function($p) { return in_array($p['method'], ['Transferencia', 'Pago Móvil']); })) > 0): ?>

                                                     <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currency === 'usd' && tasa()->usd_rate > 0): ?>
                                                    <div class="d-flex justify-content-between align-items-center mt-1">
                                                            <small class="text-muted">Total en Bs:</small>
                                                            <small class="text-muted"><?php echo e(format_money($distributedAmount * tasa()->usd_rate, 2)); ?></small>
                                                        </div>
                                                  <?php else: ?>
                                                    <div class="d-flex justify-content-between align-items-center mt-1">
                                                            <small class="text-muted">Total en Divisa ($):</small>
                                                            <small class="text-muted"><?php echo e(format_money($distributedAmount / tasa()->usd_rate, 2)); ?></small>
                                                        </div>
                                                       <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="empty-payment-state">
                                                    <i class="ri ri-wallet-3-line"></i>
                                                    <p>Aún no has añadido métodos de pago</p>
                                                    <small class="text-muted">Selecciona un método abajo para comenzar</small>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>

                                    <!-- Add Payment Method -->
                                    <div class="card add-payment-card mb-4">
                                        <div class="card-header bg-transparent border-0 pb-0">
                                            <h6 class="mb-0 fw-semibold">
                                                <i class="ri ri-add-circle-line me-2 text-primary"></i>Añadir Método de Pago
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label-velzon small">Método de Pago *</label>
                                                    <div class="form-floating-icon">
                                                        <i class="ri ri-wallet-line form-icon"></i>
                                                        <select class="form-select" wire:model.live="selectedPaymentMethod">
                                                            <option value="">Selecciona un método</option>
                                                            <option value="Efectivo">💵 Efectivo USD</option>
                                                            <option value="Efectivo Bs">🪙 Efectivo Bs</option>
                                                            <option value="Transferencia">🏦 Transferencia</option>
                                                            <option value="Pago Móvil">📱 Pago Móvil</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label-velzon small">Monto *</label>
                                                    <div class="input-group input-group-velzon">
                                                        <span class="input-group-text">$</span>
                                                        <input type="number"
                                                               step="0.01"
                                                               class="form-control"
                                                               wire:model.live="paymentAmount"
                                                               placeholder="0.00"
                                                               max="<?php echo e($remainingAmount > 0 ? format_money($remainingAmount, 2, '.', '') : format_money($cartTotal, 2, '.', '')); ?>">
                                                        <span class="input-group-text bg-light">USD</span>
                                                    </div>
                                                    <?php if(tasa() && $paymentAmount > 0): ?>
                                                        <small class="text-muted mt-1 d-block">
                                                            <i class="ri ri-exchange-line me-1"></i>
                                                           <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company() && tasa()): ?>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currency === 'usd' && tasa()->usd_rate > 0): ?>
                                                                Equivalente: <strong><?php echo e(format_money($cartTotal * tasa()->usd_rate, 2)); ?> Bs</strong>
                                                                <?php else: ?>
                                                                Equivalente: <strong><?php echo e(format_money($cartTotal / tasa()->usd_rate, 2)); ?> $</strong>
                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </small>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>

                                            <button type="button"
                                                    class="btn btn-velzon-primary mt-3"
                                                    wire:click="addPaymentMethod"
                                                    <?php if(!$selectedPaymentMethod || !$paymentAmount || $paymentAmount <= 0): ?> disabled <?php endif; ?>>
                                                <i class="ri ri-plus me-2"></i>Añadir Método
                                            </button>
                                        </div>
                                    </div>

                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['paymentMethods'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger rounded-3 d-flex align-items-center gap-2">
                                            <i class="ri ri-error-warning-line fs-5"></i>
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                    <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                                        <button wire:click="previousStep" class="btn btn-velzon-outline">
                                            <i class="ri ri-arrow-left me-2"></i>Atrás
                                        </button>
                                        <button wire:click="processOrder" class="btn btn-velzon-success" wire:loading.attr="disabled">
                                            <span wire:loading.remove wire:target="processOrder">
                                                Confirmar Pedido <i class="ri ri-arrow-right ms-2"></i>
                                            </span>
                                            <span wire:loading wire:target="processOrder">
                                                <i class="ri ri-loader-4-line ri-spin me-2"></i>Procesando...
                                            </span>
                                        </button>
                                    </div>
                                </div>

                            <?php elseif($step == 3): ?>
                                <!-- Step 3: Confirmation -->
                                <div class="step-content">
                                    <div class="step-header">
                                        <div class="step-header-icon" style="background: linear-gradient(135deg, var(--vz-success) 0%, #28a745 100%);">
                                            <i class="ri ri-checkbox-circle-line"></i>
                                        </div>
                                        <div>
                                            <h5>Confirmar Pedido</h5>
                                            <p>Revisa la información antes de confirmar</p>
                                        </div>
                                    </div>

                                    <div class="row g-4 mb-4">
                                        <div class="col-md-6">
                                            <div class="confirmation-info-card">
                                                <h6><i class="ri ri-user-location-line"></i> Información de Entrega</h6>
                                                <div class="mb-2">
                                                    <small class="text-muted">Nombre</small>
                                                    <p class="mb-0 fw-semibold"><?php echo e($name); ?></p>
                                                </div>
                                                <div class="mb-2">
                                                    <small class="text-muted">Teléfono</small>
                                                    <p class="mb-0 fw-semibold"><?php echo e($telefono); ?></p>
                                                </div>
                                                <div>
                                                    <small class="text-muted">Dirección</small>
                                                    <p class="mb-0 fw-semibold"><?php echo e($address); ?></p>
                                                </div>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($note): ?>
                                                    <div class="mt-2 pt-2 border-top">
                                                        <small class="text-muted">Nota</small>
                                                        <p class="mb-0"><?php echo e($note); ?></p>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="confirmation-info-card">
                                                <h6><i class="ri ri-wallet-3-line"></i> Métodos de Pago</h6>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="d-flex justify-content-between align-items-center py-2 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo'): ?>
                                                                <i class="ri ri-refund-2-line text-success"></i>
                                                            <?php elseif($payment['method'] == 'Efectivo Bs'): ?>
                                                                <i class="ri ri-coins-line text-warning"></i>
                                                            <?php elseif($payment['method'] == 'Transferencia'): ?>
                                                                <i class="ri ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line text-primary"></i>
                                                            <?php elseif($payment['method'] == 'Pago Móvil'): ?>
                                                                <i class="ri ri-smartphone-line text-info"></i>
                                                            <?php else: ?>
                                                                <i class="ri ri-wallet-line text-secondary"></i>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            <span><?php echo e($payment['method']); ?></span>
                                                        </div>
                                                        <div class="text-end">
                                                            <strong>
                                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo Bs'): ?>
                                                                    <?php echo e(format_money($payment['amount'], 2)); ?> Bs
                                                                <?php else: ?>
                                                                    <?php echo e(money($payment['amount'])); ?>

                                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            </strong>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($payment['method'] == 'Efectivo Bs'): ?>
                                                                <br><small class="text-muted">(<?php echo e(money($payment['amount'])); ?>)</small>
                                                            <?php elseif(in_array($payment['method'], ['Transferencia', 'Pago Móvil']) && tasa()): ?>
                                                                <br><small class="text-muted">(<?php echo e(format_money($payment['amount'] * tasa()->usd_rate, 2)); ?> Bs)</small>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($payment['method'], ['Transferencia', 'Pago Móvil'])): ?>
                                                        <small class="text-muted d-block ps-4 pb-2">
                                                            Banco: <?php echo e($bancos->find($payment['banco_id'])->nombre ?? '-'); ?> |
                                                            Ref: <?php echo e($payment['referencia'] ?? '-'); ?>

                                                        </small>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <label class="form-label-velzon">
                                            <i class="ri ri-sticky-note-line me-1 text-primary"></i>Nota (Opcional)
                                        </label>
                                        <div class="form-floating-icon textarea-icon">
                                            <i class="ri ri-pencil form-icon"></i>
                                            <textarea class="form-control <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                      id="note"
                                                      wire:model="note"
                                                      rows="2"
                                                      placeholder="Agregue cualquier instrucción especial para su pedido"
                                                      maxlength="500"></textarea>
                                        </div>
                                        <div class="d-flex justify-content-between mt-1">
                                            <small class="text-muted">Instrucciones especiales para tu pedido</small>
                                            <small class="text-muted"><?php echo e(strlen($note)); ?>/500</small>
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="confirmation-alert d-flex align-items-start gap-3">
                                        <i class="ri ri-checkbox-circle-line fs-3"></i>
                                        <div>
                                            <h6 class="mb-1 fw-semibold">¡Casi listo!</h6>
                                            <p class="mb-0 text-muted">Al confirmar tu pedido, recibirás un código de seguimiento para monitorear el estado de tu compra.</p>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                                        <button wire:click="previousStep" class="btn btn-velzon-outline">
                                            <i class="ri ri-arrow-left me-2"></i>Atrás
                                        </button>
                                        <button wire:click="processOrder" class="btn btn-velzon-success btn-lg" wire:loading.attr="disabled">
                                            <span wire:loading.remove wire:target="processOrder">
                                                <i class="ri ri-check-double-line me-2"></i>Confirmar Pedido
                                            </span>
                                            <span wire:loading wire:target="processOrder">
                                                <i class="ri ri-loader-4-line ri-spin me-2"></i>Procesando Pedido...
                                            </span>
                                        </button>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Order Summary Sidebar -->
                <div class="col-lg-4">
                    <div class="card order-summary-card sticky-top" style="top: 100px;">
                        <div class="order-summary-header d-flex justify-content-between align-items-center">
                            <h5><i class="ri ri-file-document me-2"></i>Resumen del Pedido</h5>
                            <span class="cart-badge"><?php echo e($cartCount); ?> items</span>
                        </div>
                        <div class="card-body">
                            <!-- Products -->
                            <div class="order-summary-scroll mb-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="order-item">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->associatedModel && $item->associatedModel->images && $item->associatedModel->images->first()): ?>
                                            <img src="<?php echo e('/app/'.$item->associatedModel->images->first()->path); ?>"
                                                 alt="<?php echo e($item->name); ?>"
                                                 class="order-item-img me-3">
                                        <?php else: ?>
                                            <div class="order-item-placeholder me-3">
                                                <i class="ri ri-image-line"></i>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                         <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company() && tasa()): ?>
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1 fs-6 fw-semibold"><?php echo e(Str::limit($item->name, 22)); ?></h6>
                                                <small class="text-muted">
                                                    <span class="badge bg-light text-dark"><?php echo e($item->quantity); ?>x</span>
                                                    <?php echo e(format_money($item->price)); ?>

                                                </small>
                                            </div>

                                         <?php else: ?>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1 fs-6 fw-semibold"><?php echo e(Str::limit($item->name, 22)); ?></h6>
                                            <small class="text-muted">
                                                <span class="badge bg-light text-dark"><?php echo e($item->quantity); ?>x</span>
                                                <?php echo e(money($item->price)); ?>

                                            </small>
                                        </div>
                                        <div class="text-end">
                                            <strong class="text-primary"><?php echo e(money($item->price * $item->quantity)); ?></strong>
                                        </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <!-- Totals -->
                            <div class="total-section">
                                <div class="total-row">
                                    <span class="text-muted">Subtotal</span>
                                    <span><?php echo e(format_money($cartTotal)); ?></span>
                                </div>
                                <div class="total-row">
                                    <span class="text-muted">Tasa del día</span>
                                    <span>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(tasa()): ?>
                                            <span class="badge bg-primary-subtle text-primary"><?php echo e(format_money(tasa()->usd_rate, 2)); ?> Bs/$</span>
                                        <?php else: ?>
                                            No disponible
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </span>
                                </div>
                                <div class="total-row grand-total">

                                    <span class="text-white">Total a pagar</span>
                                    <span><?php echo e(format_money($cartTotal)); ?></span>
                                </div>
                            </div>

                            <!-- Trust Badges -->
                            <div class="trust-badges">
                                <div class="trust-badge security">
                                    <i class="ri ri-shield-check-line"></i>
                                    <span>Pago Seguro</span>
                                </div>
                                <div class="trust-badge shipping">
                                    <i class="ri ri-truck-line"></i>
                                    <span>Envío Rápido</span>
                                </div>
                                <div class="trust-badge guarantee">
                                    <i class="ri ri-medal-line"></i>
                                    <span>Garantía</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->startSection('scripts'); ?>
   <script>
        document.addEventListener('DOMContentLoaded', function() {
            Livewire.on('getLocation', function() {
                console.log('🌍 Evento getLocation recibido');

                const status = document.getElementById('status');
                 Swal.fire({
                    title: '',
                    text: 'Buscando tu ubicación...',
                    icon: 'info',
                    confirmButtonText: 'OK'
                 });

                if (navigator.geolocation) {
                    // Solicita la ubicación al navegador
                    console.log(navigator.geolocation)
                    navigator.geolocation.getCurrentPosition(showPosition, showError);
                } else {
                     Swal.fire({
                    title: '',
                    text: 'La geolocalización no es compatible con este navegador',
                    icon: 'warning',
                    confirmButtonText: 'OK'
                 });
                }


            // Función que se ejecuta si la ubicación es exitosa
            async function showPosition(position) {
                const lat = position.coords.latitude;
                const lon = position.coords.longitude;


                 Swal.fire({
                    title: '',
                    text: 'Coordenadas obtenidas. Obteniendo dirección...',
                    icon: 'info',
                    confirmButtonText: 'OK'
                 });

                // Llama a la función para geocodificación inversa
                await getAddressFromCoords(lat, lon);
            }

            // Función para llamar a la API de geocodificación de Laravel
            async function getAddressFromCoords(lat, lon) {
                try {
                    // Usar el controlador de geocodificación de Laravel
                    const response = await fetch(`/api/geocoding/reverse?lat=${lat}&lon=${lon}`, {
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });

                    if (!response.ok) {
                        throw new Error(`Error HTTP: ${response.status}`);
                    }

                    const data = await response.json();
                    console.log('✅ Ubicación actualizada:', {
                        address: data.display_name,
                        lat: lat,
                        lng: lon
                    });


                    if (data.display_name) {
                        // Llamar al método de Livewire para actualizar la ubicación
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').updateLocation(data.display_name, lat, lon);

                        Swal.fire({
                            title: '',
                            text: 'Dirección obtenida con éxito.',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        });
                    } else {
                        // Llamar al método de Livewire con dirección genérica
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').updateLocation('No se encontró una dirección detallada.', lat, lon);

                        Swal.fire({
                            title: '',
                            text: 'Geocodificación inversa completada (sin dirección detallada).',
                            icon: 'info',
                            confirmButtonText: 'OK'
                        });
                    }

                } catch (error) {
                    console.error("Error al obtener la dirección:", error);

                    // Llamar al método de Livewire con mensaje de error
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').updateLocation('Error al cargar la dirección.', lat, lon);

                    Swal.fire({
                            title: '',
                            text: 'Error en la solicitud de geocodificación.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                }
            }

            // Función para manejar errores de geolocalización
            function showError(error) {
                const status = document.getElementById('status');
                switch(error.code) {
                    case error.PERMISSION_DENIED:
                        Swal.fire({
                            title: '',
                            text: "Permiso denegado por el usuario para la geolocalización.",
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });
                        break;
                    case error.POSITION_UNAVAILABLE:
                        Swal.fire({
                            title: '',
                            text: "La información de ubicación no está disponible.",
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });
                        break;
                    case error.TIMEOUT:
                        Swal.fire({
                            title: '',
                            text: "Se agotó el tiempo de espera para obtener la ubicación.",
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });
                        break;
                    case error.UNKNOWN_ERROR:
                        Swal.fire({
                            title: '',
                            text: "Ocurrió un error desconocido.",
                            icon: 'warning',
                            confirmButtonText: 'OK'
                        });
                        break;
                }
            }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/checkout/index.blade.php ENDPATH**/ ?>