<!DOCTYPE html>
<html
  lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>"
  class="layout-menu-fixed layout-navbar-fixed <?php echo e(isset($templateSettings) ? ($templateSettings->content_layout === 'wide' ? 'layout-wide' : 'layout-compact') : 'layout-compact'); ?><?php echo e(isset($templateSettings) && $templateSettings->footer_fixed ? ' layout-footer-fixed' : ''); ?>"
  dir="<?php echo e(isset($templateSettings) ? $templateSettings->text_direction : 'ltr'); ?>"
  data-skin="<?php echo e(isset($templateSettings) ? ($templateSettings->skin == 1 ? 'bordered' : 'default') : 'default'); ?>"
  data-bs-theme="<?php echo e(isset($templateSettings) ? $templateSettings->theme : 'light'); ?>"
  data-assets-path="<?php echo e(asset('materialize/assets/')); ?>/"
  data-template="horizontal-menu-template">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo e($title ?? config('app.name')); ?></title>
    <meta name="description" content="<?php echo e(config('app.name')); ?> - <?php echo e(config('app.description')); ?>" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('materialize/assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="/materialize/assets/vendor/fonts/iconify-icons.css" />
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.7.0/fonts/remixicon.css" rel="stylesheet">


    <!-- Core CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/node-waves/node-waves.css" />
    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/pickr/pickr-themes.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/css/core.css" />
    <link rel="stylesheet" href="/materialize/assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/swiper/swiper.css" />

    <!-- Page CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/animate-css/animate.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Helpers -->
    <script src="/materialize/assets/vendor/js/helpers.js"></script>
    <script src="/materialize/assets/vendor/js/template-customizer.js"></script>
    <script src="/materialize/assets/js/config.js"></script>


    <?php echo $__env->make('components.template-config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Cropper.js CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">

    <!-- Chat y Biblioteca CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/chat-biblioteca.css')); ?>">

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($templateSettings) && $templateSettings->primary_color): ?>
    <style>
      :root {
        --bs-primary: <?php echo e($templateSettings->primary_color); ?>;
        --bs-primary-rgb: <?php echo e(implode(',', sscanf($templateSettings->primary_color, '#%02x%02x%02x'))); ?>;
      }
    </style>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <style>
      .avatar-initial {
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 1rem;
        color: white;
      }

      /* Eliminar overlays problemáticos */
      .modal-backdrop,
      .offcanvas-backdrop,
      .tooltip,
      .popover,
      .dropdown-backdrop {
        display: none !important;
        opacity: 0 !important;
        visibility: hidden !important;
      }

      /* Asegurar que no haya z-index problemáticos */
      .layout-overlay {
        z-index: -1 !important;
      }
    </style>

    <!-- Livewire Styles -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <?php echo $__env->yieldPushContent('styles'); ?>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-navbar-full layout-horizontal layout-without-menu">
      <div class="layout-container">

        <!-- /Navbar -->
      <?php echo $__env->make('components.partials.navbar-horizontal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Layout page -->
        <div class="layout-page">
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Menu -->
            <aside id="layout-menu" class="layout-menu-horizontal menu-horizontal menu flex-grow-0">
              <div class="container-fluid d-flex h-100">
                <?php echo $__env->make('components.partials.horizontal-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
              </div>
            </aside>

            <!-- Content -->
            <div class="container-fluid flex-grow-1 container-p-y">

              <?php echo e($slot); ?>

            </div>
            <!-- /Content -->

            <!-- Footer -->
            <?php echo $__env->make('components.partials.footer-horizontal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- <div class="content-backdrop fade"></div> -->
          </div>
          <!-- /Content wrapper -->
        </div>
        <!-- /Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- /Layout wrapper -->

    <!-- Contenedor de notificaciones -->
    <div id="notification-container"></div>

    <!-- Core JS -->
    <script src="/materialize/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="/materialize/assets/vendor/libs/popper/popper.js"></script>
    <script src="/materialize/assets/vendor/js/bootstrap.js"></script>
    <script src="/materialize/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>
    <script src="/materialize/assets/vendor/libs/pickr/pickr.js"></script>
    <script src="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="/materialize/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="/materialize/assets/vendor/libs/i18n/i18n.js"></script>
    <script src="/materialize/assets/vendor/js/menu.js"></script>

    <!-- Vendors JS -->
    <script src="/materialize/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="/materialize/assets/vendor/libs/swiper/swiper.js"></script>
    <script src="/materialize/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>

    <!-- Main JS -->
    <script src="/materialize/assets/js/main.js"></script>

    <!-- Livewire Scripts -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>



    <!-- Cropper.js JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

    <!-- Script para manejar notificaciones -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Función para mostrar notificaciones
            function showNotification(type, message) {
                const iconMap = {
                    'success': 'success',
                    'error': 'error',
                    'warning': 'warning',
                    'info': 'info'
                };

                Swal.fire({
                    icon: iconMap[type] || 'info',
                    text: message,
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: false
                });
            }

            // Listener para eventos show-toast de Livewire
            window.addEventListener('show-toast', event => {
                const detail = event.detail;
                showNotification(detail.type || detail[0]?.type, detail.message || detail[0]?.message);
            });

            // Procesar mensajes flash de Laravel
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
                showNotification('success', '<?php echo e(session('success')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
                showNotification('error', '<?php echo e(session('error')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('warning')): ?>
                showNotification('warning', '<?php echo e(session('warning')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('info')): ?>
                showNotification('info', '<?php echo e(session('info')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('message')): ?>
                showNotification('info', '<?php echo e(session('message')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('danger')): ?>
                showNotification('error', '<?php echo e(session('danger')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('alert')): ?>
                showNotification('warning', '<?php echo e(session('alert')); ?>');
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            // Procesar errores de validación
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    showNotification('error', '<?php echo e($error); ?>');
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>

  </body>
</html>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/components/layouts/horizontal.blade.php ENDPATH**/ ?>