<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Autenticación en dos pasos</h5>
    </div>
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h6 class="mb-1">Estado actual</h6>
                <small class="text-muted">Añade una capa adicional de seguridad a tu cuenta</small>
            </div>
            <button 
                wire:click="toggle2FA" 
                class="btn btn-<?php echo e($enabled ? 'danger' : 'primary'); ?>"
            >
                <?php echo e($enabled ? 'Desactivar' : 'Activar'); ?>

            </button>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showQrCode): ?>
            <div class="border rounded p-4 mb-4">
                <div class="text-center mb-3">
                    <h6>Configura tu aplicación de autenticación</h6>
                    <small class="text-muted">Escanea el código QR con tu aplicación</small>
                </div>

                <div class="d-flex flex-column align-items-center">
                    <div class="mb-3">
                        <?php echo $qrCode; ?>

                    </div>

                    <div class="mb-3 w-100">
                        <label class="form-label">Código de verificación</label>
                        <input 
                            type="text" 
                            wire:model="verificationCode" 
                            class="form-control" 
                            placeholder="Ingresa el código de tu app"
                        >
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['verificationCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <button 
                        wire:click="verifyCode" 
                        class="btn btn-primary w-100"
                    >
                        Verificar y activar
                    </button>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($recoveryCodes)): ?>
            <div class="alert alert-warning">
                <h6 class="alert-heading">Códigos de recuperación</h6>
                <p class="mb-2">Guarda estos códigos en un lugar seguro. Son tu respaldo si pierdes acceso a tu dispositivo.</p>
                
                <div class="row mt-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $recoveryCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-2">
                            <code><?php echo e($code); ?></code>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/users/profile/two-factor-auth.blade.php ENDPATH**/ ?>