<div>
    <?php $__env->startSection('title', 'Pedido #' . $pedido->codigo); ?>

    <!-- Header Profesional -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-6 gap-6">
        <div class="d-flex flex-column justify-content-center">
            <div class="d-flex align-items-center mb-2">
                <button wire:click="goBack" class="btn btn-sm btn-outline-secondary me-3">
                    <i class="ri-arrow-left-line"></i>
                </button>
                <h4 class="mb-0">Pedido #<?php echo e($pedido->codigo); ?></h4>
                <span class="badge bg-label-<?php echo e($pedido->estado == 'Pendiente' ? 'warning' :
                    ($pedido->estado == 'Procesando' ? 'info' :
                    ($pedido->estado == 'entregado' ? 'success' :
                    ($pedido->estado == 'cancelado' ? 'danger' : 'primary')))); ?> ms-3 rounded-pill"><?php echo e($pedido->estado); ?></span>
            </div>
            <div class="d-flex align-items-center text-muted">
                <i class="ri-calendar-line me-2"></i>
                <span><?php echo e($pedido->created_at->format('d/m/Y H:i')); ?></span>
                <span class="mx-2">•</span>
                <i class="ri-user-line me-2"></i>
                <span><?php echo e($pedido->user->name); ?></span>
                <span class="mx-2">•</span>
                <i class="ri-money-dollar-circle-line me-2"></i>
                <span class="fw-semibold"><?php echo e(format_money($pedido->total_usd)); ?></span>
            </div>
        </div>
        <div class="d-flex align-content-center flex-wrap gap-2">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'Pendiente'): ?>
                <button wire:click="updateOrderStatus('Procesando')" class="btn btn-success">
                    <i class="ri-play-line me-1"></i> Procesar Pedido
                </button>
            <?php elseif($pedido->estado == 'Procesando'): ?>
                <button wire:click="updateOrderStatus('entregado')" class="btn btn-primary">
                    <i class="ri-check-line me-1"></i> Marcar Entregado
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->user->telefono): ?>
                <a href="tel:<?php echo e($pedido->user->telefono); ?>" class="btn btn-outline-success">
                    <i class="ri-phone-line me-1"></i> Llamar Cliente
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->latitud && $pedido->longitud): ?>
                <a href="https://www.google.com/maps/dir//<?php echo e($pedido->latitud); ?>,<?php echo e($pedido->longitud); ?>" target="_blank" class="btn btn-outline-info">
                    <i class="ri-navigation-line me-1"></i> Navegar
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

    <!-- Contenido Principal -->
    <div class="row">
        <div class="col-12 col-lg-8">
            <!-- Productos del Pedido -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Productos del Pedido</h5>
                    <span class="badge bg-label-primary rounded-pill"><?php echo e($pedido->detalles->count()); ?> <?php echo e($pedido->detalles->count() == 1 ? 'producto' : 'productos'); ?></span>
                </div>
                <div class="card-datatable table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 80px;">Imagen</th>
                                <th>Producto</th>
                                <th class="text-center" style="width: 100px;">Precio Unit.</th>
                                <th class="text-center" style="width: 80px;">Cant.</th>
                                <th class="text-end" style="width: 120px;">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pedido->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($detalle->producto && $detalle->producto->images && $detalle->producto->images->first()): ?>
                                            <img src="<?php echo e(asset('app/' . $detalle->producto->images->first()->path)); ?>"
                                                 alt="<?php echo e($detalle->producto->name); ?>"
                                                 class="rounded shadow-sm" style="width: 50px; height: 50px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-label-secondary rounded d-flex align-items-center justify-content-center"
                                                 style="width: 50px; height: 50px;">
                                                <i class="ri-image-line text-muted"></i>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <h6 class="mb-1"><?php echo e($detalle->producto->name ?? 'Producto eliminado'); ?></h6>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($detalle->producto && $detalle->producto->sku): ?>
                                                <small class="text-muted">SKU: <?php echo e($detalle->producto->sku); ?></small>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="fw-medium"><?php echo e(format_money($detalle->price)); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-label-info rounded-pill"><?php echo e($detalle->quantity); ?></span>
                                    </td>
                                    <td class="text-end">
                                        <strong class="text-primary"><?php echo e(format_money($detalle->total_usd)); ?></strong>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end fw-semibold">Total del Pedido:</td>
                                <td class="text-end">
                                    <h5 class="mb-0 text-primary"><?php echo e(format_money($pedido->total_usd)); ?></h5>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company()): ?>
                                        <small class="text-muted"><?php echo e(format_money($pedido->total_bs)); ?> Bs</small>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Timeline del Estado -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Estado del Pedido</h5>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="ri-edit-line me-1"></i> Cambiar Estado
                        </button>
                        <ul class="dropdown-menu">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado != 'Procesando'): ?>
                                <li><a class="dropdown-item" href="#" wire:click="updateOrderStatus('Procesando')">
                                    <i class="ri-play-line me-2"></i> Procesando
                                </a></li>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado != 'entregado'): ?>
                                <li><a class="dropdown-item" href="#" wire:click="updateOrderStatus('entregado')">
                                    <i class="ri-check-line me-2"></i> Entregado
                                </a></li>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado != 'cancelado'): ?>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="#" wire:click="updateOrderStatus('cancelado')">
                                    <i class="ri-close-line me-2"></i> Cancelar
                                </a></li>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="timeline timeline-advance mb-0">
                        <li class="timeline-item timeline-item-transparent">
                            <span class="timeline-point timeline-point-success"></span>
                            <div class="timeline-event">
                                <div class="timeline-header mb-2">
                                    <h6 class="mb-0">Pedido Recibido</h6>
                                    <small class="text-muted"><?php echo e($pedido->created_at->format('d/m/Y H:i')); ?></small>
                                </div>
                                <p class="mb-2">El pedido #<?php echo e($pedido->codigo); ?> fue creado exitosamente</p>
                            </div>
                        </li>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($pedido->estado, ['Procesando', 'entregado'])): ?>
                            <li class="timeline-item timeline-item-transparent">
                                <span class="timeline-point <?php echo e($pedido->estado == 'entregado' ? 'timeline-point-success' : 'timeline-point-primary'); ?>"></span>
                                <div class="timeline-event">
                                    <div class="timeline-header mb-2">
                                        <h6 class="mb-0">En Preparación</h6>
                                        <small class="text-muted"><?php echo e($pedido->estado == 'entregado' ? 'Completado' : 'En proceso'); ?></small>
                                    </div>
                                    <p class="mb-2">El pedido está siendo preparado por el equipo</p>
                                </div>
                            </li>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <li class="timeline-item timeline-item-transparent pb-0">
                            <span class="timeline-point <?php echo e($pedido->estado == 'entregado' ? 'timeline-point-success' : ($pedido->estado == 'cancelado' ? 'timeline-point-danger' : 'timeline-point-secondary')); ?>"></span>
                            <div class="timeline-event pb-0">
                                <div class="timeline-header mb-2">
                                    <h6 class="mb-0"><?php echo e($pedido->estado == 'cancelado' ? 'Cancelado' : 'Entregado'); ?></h6>
                                    <small class="text-muted">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'entregado'): ?>
                                            <?php echo e($pedido->fecha_entrega ? $pedido->fecha_entrega->format('d/m/Y H:i') : 'Completado'); ?>

                                        <?php elseif($pedido->estado == 'cancelado'): ?>
                                            Pedido cancelado
                                        <?php else: ?>
                                            Pendiente
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </small>
                                </div>
                                <p class="mb-0">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'entregado'): ?>
                                        Pedido entregado exitosamente al cliente
                                    <?php elseif($pedido->estado == 'cancelado'): ?>
                                        El pedido ha sido cancelado
                                    <?php else: ?>
                                        El pedido será entregado pronto
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-4">
            <!-- Información del Cliente -->
            <div class="card mb-6">
                <div class="card-header">
                    <h5 class="card-title m-0">Información del Cliente</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-4">
                        <div class="avatar me-3">
                            <span class="avatar-initial rounded-circle bg-label-primary">
                                <?php echo e(strtoupper(substr($pedido->user->name, 0, 2))); ?>

                            </span>
                        </div>
                        <div class="d-flex flex-column">
                            <h6 class="mb-0"><?php echo e($pedido->user->name); ?></h6>
                            <small class="text-muted">Cliente ID: #<?php echo e($pedido->user->id); ?></small>
                        </div>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <i class="ri-mail-line me-3 text-muted"></i>
                        <span><?php echo e($pedido->user->email); ?></span>
                    </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->user->telefono): ?>
                        <div class="d-flex align-items-center mb-3">
                            <i class="ri-phone-line me-3 text-muted"></i>
                            <span><?php echo e($pedido->user->telefono); ?></span>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="d-flex align-items-center">
                        <i class="ri-calendar-line me-3 text-muted"></i>
                        <span>Cliente desde <?php echo e($pedido->user->created_at->format('M Y')); ?></span>
                    </div>
                </div>
            </div>

            <!-- Dirección de Entrega -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Dirección de Entrega</h5>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->latitud && $pedido->longitud): ?>
                        <a href="https://www.google.com/maps?q=<?php echo e($pedido->latitud); ?>,<?php echo e($pedido->longitud); ?>" 
                           target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="ri-external-link-line"></i>
                        </a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-start">
                        <i class="ri-map-pin-line me-3 mt-1 text-primary"></i>
                        <div class="flex-grow-1">
                            <p class="mb-2"><?php echo e($pedido->ubicacion); ?></p>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->latitud && $pedido->longitud): ?>
                                <small class="text-muted d-block mb-3">
                                    Coordenadas: <?php echo e(number_format($pedido->latitud, 6)); ?>, <?php echo e(number_format($pedido->longitud, 6)); ?>

                                </small>
                                <a href="https://www.google.com/maps/dir//<?php echo e($pedido->latitud); ?>,<?php echo e($pedido->longitud); ?>" 
                                   target="_blank" class="btn btn-primary btn-sm w-100">
                                    <i class="ri-navigation-line me-1"></i> Obtener Direcciones
                                </a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Información de Pago -->
            <div class="card mb-6">
                <div class="card-header">
                    <h5 class="card-title m-0">Información de Pago</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="text-muted">Método de Pago:</span>
                        <span class="fw-semibold"><?php echo e($pedido->metodo_pago ?? 'No especificado'); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="text-muted">Subtotal:</span>
                        <span><?php echo e(format_money($pedido->total_usd)); ?></span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Total:</h6>
                        <h5 class="mb-0 text-primary"><?php echo e(format_money($pedido->total_usd)); ?></h5>
                    </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company()): ?>
                        <div class="text-end mt-1">
                            <small class="text-muted"><?php echo e(format_money($pedido->total_bs)); ?> Bs</small>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->pagos && $pedido->pagos->count() > 0): ?>
                        <hr>
                        <h6 class="mb-2">Detalles de Pago:</h6>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pedido->pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted"><?php echo e($pago->metodo_pago); ?></small>
                                <small class="fw-medium"><?php echo e(format_money($pago->total_usd)); ?></small>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pago->referencia): ?>
                                <div class="mb-2">
                                    <small class="text-muted">Ref: <?php echo e($pago->referencia); ?></small>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>

            <!-- Notas del Pedido -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->nota): ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title m-0">Notas del Pedido</h5>
                </div>
                <div class="card-body">
                    <p class="mb-0"><?php echo e($pedido->nota); ?></p>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</div><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/empleados/pedido-detalle.blade.php ENDPATH**/ ?>