<?php

use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('register', App\Livewire\Auth\Register::class)->name('register');
    Route::get('login', App\Livewire\Auth\Login::class)->name('login');
    Route::get('forgot-password', App\Livewire\Auth\ForgotPassword::class)->name('password.request');
    Route::get('reset-password/{token}', App\Livewire\Auth\ResetPassword::class)->name('password.reset');
});

Route::middleware('auth')->group(function () {
    Route::get('verify-email', App\Livewire\Auth\Verify::class)->name('verification.notice');
});