<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\JwtAuthController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Rutas de autenticación JWT
Route::group(['prefix' => 'auth'], function () {
    Route::post('login', [JwtAuthController::class, 'login']);
    Route::post('logout', [JwtAuthController::class, 'logout']);
    Route::post('refresh', [JwtAuthController::class, 'refresh']);
    Route::post('me', [JwtAuthController::class, 'me']);
});

// Ruta de verificación de tokens para WhatsApp API (usando JWT ahora)
Route::post('/verify-token', [JwtAuthController::class, 'verifyToken'])
    ->name('api.verify-token');

// Ruta protegida de ejemplo con JWT
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

// Ruta de prueba
Route::get('/test', [\App\Http\Controllers\Api\TestController::class, 'test']);
Route::post('/test-auth', [\App\Http\Controllers\Api\TestAuthController::class, 'testBasicAuth']);
Route::post('/simple-login', [\App\Http\Controllers\Api\SimpleJWTController::class, 'login']);


// Rutas de WhatsApp con autenticación JWT
Route::middleware('auth:api')->group(function () {
    Route::post('/whatsapp/send', [\App\Http\Controllers\WhatsAppProxyController::class, 'sendMessage']);
    Route::get('/whatsapp/status', [\App\Http\Controllers\WhatsAppProxyController::class, 'getStatus']);
    Route::get('/whatsapp/qr', [\App\Http\Controllers\WhatsAppProxyController::class, 'getQR']);
    Route::get('/whatsapp/contacts', [\App\Http\Controllers\WhatsAppProxyController::class, 'getContacts']);
});