<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\Dashboard;
use App\Livewire\Admin\Empresas\Index as EmpresasIndex;
use App\Livewire\Admin\Empresas\Create as EmpresasCreate;
use App\Livewire\Admin\Empresas\Edit as EmpresasEdit;
use App\Livewire\Admin\Sucursales\Index as SucursalesIndex;
use App\Livewire\Admin\Sucursales\Create as SucursalesCreate;
use App\Livewire\Admin\Sucursales\Edit as SucursalesEdit;
use App\Livewire\Admin\Sucursales\Show as SucursalesShow;
use App\Livewire\Admin\Users\Index as UsersIndex;
use App\Livewire\Admin\Users\Create as UsersCreate;
use App\Livewire\Admin\Users\Edit as UsersEdit;
use App\Livewire\Admin\Roles\Index as RolesIndex;
use App\Livewire\Admin\Roles\Create as RolesCreate;
use App\Livewire\Admin\Roles\Edit as RolesEdit;
use App\Livewire\Admin\Roles\Show as RolesShow;
use App\Livewire\Admin\Permissions\Index as PermissionsIndex;
use App\Livewire\Admin\Permissions\Create as PermissionsCreate;
use App\Livewire\Admin\Permissions\Edit as PermissionsEdit;
use App\Livewire\Admin\ConceptosPago\Index as ConceptosPagoIndex;
use App\Livewire\Admin\ConceptosPago\Create as ConceptosPagoCreate;
use App\Livewire\Admin\ConceptosPago\Edit as ConceptosPagoEdit;
use App\Livewire\Admin\Pedidos\Index as PedidosIndex;
use App\Livewire\Admin\Pedidos\Create as PedidosCreate;
use App\Livewire\Admin\Pedidos\Edit as PedidosEdit;
use App\Livewire\Admin\Pedidos\Show as PedidosShow;
use App\Livewire\Admin\Pedidos\Historico as PedidosHistorico;
use App\Livewire\Admin\ActiveSessions;
use App\Livewire\Admin\Categorias\Index as CategoriasIndex;
use App\Livewire\Admin\Categorias\Create as CategoriasCreate;
use App\Livewire\Admin\Categorias\Edit as CategoriasEdit;
use App\Livewire\Admin\Marcas\Index as MarcasIndex;
use App\Livewire\Admin\Marcas\Edit as MarcasEdit;
use App\Livewire\Admin\Marcas\Create as MarcasCreate;
use App\Livewire\Admin\Productos\Index as ProductosIndex;
use App\Livewire\Admin\Productos\Create as ProductosCreate;
use App\Livewire\Admin\Productos\ProductoDetail;
use App\Livewire\Admin\Empleados\Index as EmpleadosIndex;
use App\Livewire\Admin\Empleados\Create as EmpleadosCreate;
use App\Livewire\Admin\Empleados\Edit as EmpleadosEdit;
use App\Livewire\Admin\Empleados\Show as EmpleadosShow;
use App\Livewire\Admin\Pos\Index;
use App\Livewire\Admin\Pos\Reportes;
use App\Livewire\Admin\Pos\Aprobaciones;
use App\Livewire\Admin\Ventas\VentasConBarcode;

// Empresas
Route::get('/empresas', EmpresasIndex::class)->name('empresas.index');
Route::get('/empresas/crear', EmpresasCreate::class)->name('empresas.create');
Route::get('/empresas/{empresa}/editar', EmpresasEdit::class)->name('empresas.edit');

// Países
Route::get('/paises', \App\Livewire\Admin\Paises\PaisIndex::class)->name('paises.index');
Route::get('/paises/crear', \App\Livewire\Admin\Paises\Create::class)->name('paises.create');
Route::get('/paises/{pais}/editar', \App\Livewire\Admin\Paises\Edit::class)->name('paises.edit');

// Sucursales
Route::get('/sucursales', SucursalesIndex::class)->name('sucursales.index');
Route::get('/sucursales/crear', SucursalesCreate::class)->name('sucursales.create');
Route::get('/sucursales/{sucursal}/editar', SucursalesEdit::class)->name('sucursales.edit');
Route::get('/sucursales/{sucursal}', SucursalesShow::class)->name('sucursales.show');

// Usuarios
Route::get('/usuarios', UsersIndex::class)->name('users.index');
Route::get('/usuarios/crear', UsersCreate::class)->name('users.create');
Route::get('/usuarios/{user}/editar', UsersEdit::class)->name('users.edit');
 // Perfil de usuario
Route::prefix('profile')->group(function () {
    Route::get('/', \App\Livewire\Admin\Users\Profile\Index::class)->name('users.profile');
    Route::get('/{user_id}/password', \App\Livewire\Admin\Users\Profile\ChangePassword::class)->name('users.password');
    Route::get('/{user_id}/history', \App\Livewire\Admin\Users\Profile\HistoryUser::class)->name('users.history');
});

// Usuarios
// Roles
Route::get('/roles', RolesIndex::class)->name('roles.index');
Route::get('/roles/crear', RolesCreate::class)->name('roles.create');
Route::get('/roles/{role}/editar', RolesEdit::class)->name('roles.edit');
Route::get('/roles/{role}', RolesShow::class)->name('roles.show');

// Permisos
Route::get('/permisos', PermissionsIndex::class)->name('permissions.index');
Route::get('/permisos/crear', PermissionsCreate::class)->name('permissions.create');
Route::get('/permisos/{permission}/editar', PermissionsEdit::class)->name('permissions.edit');

// Sesiones activas
Route::get('/active-sessions', ActiveSessions::class)->name('active-sessions.index');

// Categorías
Route::get('/categorias', CategoriasIndex::class)->name('categorias.index');
Route::get('/categorias/crear', CategoriasCreate::class)->name('categorias.create');
Route::get('/categorias/{categoria}/editar', CategoriasEdit::class)->name('categorias.edit');

// Marcas
Route::get('/marcas', MarcasIndex::class)->name('marcas.index');
Route::get('/marcas/crear', MarcasCreate::class)->name('marcas.create');
Route::get('/marcas/{marca}/editar', MarcasEdit::class)->name('marcas.edit');

// Productos
Route::get('/productos', \App\Livewire\Admin\Productos\IndexMejorado::class)->name('productos.index');
Route::get('/productos/crear', \App\Livewire\Admin\Productos\CreateMejorado::class)->name('productos.create');
Route::get('/productos/{producto}', ProductoDetail::class)->name('productos.show')->middleware('permission:view product details');
Route::get('/productos/{producto}/editar', \App\Livewire\Admin\Productos\EditMejorado::class)->name('productos.edit');
Route::get('/productos/{producto}/inventario', \App\Livewire\Admin\Productos\InventoryHistory::class)->name('productos.inventory');

// Pedidos
Route::middleware('permission:access pedidos')->group(function () {
    Route::get('/pedidos', PedidosIndex::class)->name('pedidos.index');
    Route::get('/pedidos/create', PedidosCreate::class)->name('pedidos.create')->middleware('permission:create pedidos');
    Route::get('/pedidos/{pedidoId}/edit', PedidosEdit::class)->name('pedidos.edit')->middleware('permission:edit pedidos');
    Route::get('/pedidos/{pedido}', PedidosShow::class)->name('pedidos.show')->middleware('permission:view pedidos');

});

// Series de Documentos
Route::get('/series', \App\Livewire\Admin\Series\Index::class)->name('series.index');
Route::get('/series/crear', \App\Livewire\Admin\Series\Create::class)->name('series.create');
Route::get('/series/{serie}/editar', \App\Livewire\Admin\Series\Edit::class)->name('series.edit');

// Tasas de Cambio
Route::get('/tasas-cambio', \App\Livewire\Admin\ExchangeRates::class)->name('exchange-rates');

// Cajas
Route::get('/cajas', \App\Livewire\Admin\Cajas\Index::class)->name('cajas.index');
Route::get('/cajas/crear', \App\Livewire\Admin\Cajas\Create::class)->name('cajas.create');
Route::get('/cajas/{caja}', \App\Livewire\Admin\Cajas\Show::class)->name('cajas.show');
Route::get('/cajas/{caja}/export', [\App\Http\Controllers\Admin\CajaExportController::class, 'export'])->name('cajas.export');

// Notificaciones
Route::get('/notifications', \App\Livewire\Admin\Notifications\Index::class)->name('notifications.index');


// WhatsApp - Nuevas rutas separadas
Route::prefix('whatsapp')->as('whatsapp.')->group(function () {
    // Dashboard principal
    Route::get('/dashboard', \App\Livewire\Admin\Whatsapp\WhatsAppDashboard::class)->name('dashboard');

    // Gestión de conexión
    Route::get('/connection', \App\Livewire\Admin\Whatsapp\WhatsAppConnection::class)->name('connection');

    // Enviar mensajes
    Route::get('/send-messages', \App\Livewire\Admin\Whatsapp\WhatsAppSendMessages::class)->name('send-messages');

    // Plantillas
    Route::get('/templates', \App\Livewire\Admin\Whatsapp\WhatsAppTemplates::class)->name('templates.index');

    // Historial
    Route::get('/history', \App\Livewire\Admin\Whatsapp\WhatsAppHistory::class)->name('history');

    // Mensajes programados
    Route::get('/scheduled-messages', \App\Livewire\Admin\Whatsapp\WhatsAppScheduledMessages::class)->name('scheduled-messages');

    // Mantener rutas antiguas para compatibilidad temporal
    Route::get('/', \App\Livewire\Admin\Whatsapp\Index::class)->name('index');

    // Estadísticas
    Route::get('/statistics', \App\Livewire\Admin\Whatsapp\WhatsAppStatistics::class)->name('statistics');
});

// Exportador de Base de Datos
Route::get('/exportar-base-datos', \App\Livewire\Admin\DatabaseExport::class)->name('database-export');

// WhatsApp
Route::get('/whatsapp', \App\Livewire\Admin\Whatsapp\Index::class)->name('whatsapp.index');

Route::get('/empleados', EmpleadosIndex::class)->name('empleados.index');
Route::get('/empleados/create', EmpleadosCreate::class)->name('empleados.create');
Route::get('/empleados/dashboard', \App\Livewire\Admin\Empleados\Dashboard::class)->name('empleados.dashboard');
Route::get('/empleados/pedido/{codigo}', \App\Livewire\Admin\Empleados\PedidoDetalle::class)->name('empleados.pedido.detalle');
Route::get('/empleados/{empleado}/edit', EmpleadosEdit::class)->name('empleados.edit');
Route::get('/empleados/{empleado}', EmpleadosShow::class)->name('empleados.show');

// Historial de pedidos para empleados
Route::get('/pedidos/historico/{userId}', PedidosHistorico::class)->name('pedidos.historico');

// Registro de Actividad
Route::get('/activity-log', \App\Livewire\Admin\ActivityLog::class)->name('activity-log');

// Dashboard de Cajas y Tasas
Route::prefix('cajas-tasa')->group(function () {
    Route::get('/
    ', [\App\Http\Controllers\Admin\CajaTasaDashboardController::class, 'index'])
        ->name('cajas.dashboard');
    Route::post('/actualizar-tasa', [\App\Http\Controllers\Admin\CajaTasaDashboardController::class, 'ejecutarActualizacionTasa'])
        ->name('cajas.dashboard.actualizar-tasa');
    Route::post('/corte-caja', [\App\Http\Controllers\Admin\CajaTasaDashboardController::class, 'ejecutarCorteCaja'])
        ->name('cajas.dashboard.corte-caja');
    Route::post('/verificar-diaria', [\App\Http\Controllers\Admin\CajaTasaDashboardController::class, 'ejecutarVerificacionDiaria'])
        ->name('cajas.dashboard.verificar-diaria');
});


// Ventas
Route::middleware('permission:access ventas')->group(function () {
    Route::get('/ventas', \App\Livewire\Admin\Ventas\Index::class)->name('ventas.index');
    Route::get('/ventas/create', \App\Livewire\Admin\Ventas\Create::class)->name('ventas.create');
    Route::get('/ventas/{venta}/edit', \App\Livewire\Admin\Ventas\Edit::class)->name('ventas.edit');
    Route::get('/ventas/{venta}', \App\Livewire\Admin\Ventas\Detalle::class)->name('ventas.show');
});

// Notas de Crédito (Solo consulta)
Route::middleware('permission:access ventas')->group(function () {
    Route::get('/notas-credito', \App\Livewire\Admin\NotasCredito\Index::class)->name('notas-credito.index');
    Route::get('/notas-credito/create/{venta_id?}', \App\Livewire\Admin\NotasCredito\Create::class)->name('notas-credito.create');
    Route::get('/notas-credito/{notaCredito}', \App\Livewire\Admin\NotasCredito\Show::class)->name('notas-credito.show');
});

// Notas de Venta
Route::middleware('permission:access ventas')->group(function () {
    // Punto de Venta (POS)
Route::get('/pos', \App\Livewire\Admin\Pos\Index::class)->name('pos.index');
    Route::get('/notas-venta', \App\Livewire\Admin\NotasVenta\Index::class)->name('notas-venta.index');
    Route::get('/notas-venta/create', \App\Livewire\Admin\NotasVenta\Create::class)->name('notas-venta.create');
    Route::get('/notas-venta/{notaVenta}/edit', \App\Livewire\Admin\NotasVenta\Edit::class)->name('notas-venta.edit');
    Route::get('/notas-venta/{notaVenta}', \App\Livewire\Admin\NotasVenta\Show::class)->name('notas-venta.show');
});

// Cotizaciones
Route::middleware('permission:access ventas')->group(function () {
    Route::get('/cotizaciones', \App\Livewire\Admin\Cotizaciones\Index::class)->name('cotizaciones.index');
    Route::get('/cotizaciones/create', \App\Livewire\Admin\Cotizaciones\Create::class)->name('cotizaciones.create');
    Route::get('/cotizaciones/{cotizacion}/edit', \App\Livewire\Admin\Cotizaciones\Edit::class)->name('cotizaciones.edit');
    Route::get('/cotizaciones/{cotizacion}', \App\Livewire\Admin\Cotizaciones\Show::class)->name('cotizaciones.show');
});


Route::get('/template-customization', \App\Livewire\Admin\TemplateCustomization\Index::class)
    ->middleware(['auth'])
    ->name('template-customization');
Route::get('/monitoreo/database-backup', \App\Livewire\Admin\Monitoreo\DatabaseBackup::class)->name('monitoreo.database-backup');
Route::get('/monitoreo/database-import', \App\Livewire\Admin\Monitoreo\DatabaseImport::class)->name('monitoreo.database-import');

 // Aprobaciones de Movimientos de Caja
    Route::get('/pos/aprobaciones', Aprobaciones::class)
        ->name('pos.aprobaciones')
        ->middleware('caja.approval');





// Pantalla del Cliente (sin autenticación para poder mostrar en segundo monitor)
Route::get('/pos/pantalla-cliente', function () {
    return view('livewire.admin.pos.customer-display');
})->name('pos.customer-display');
