@yield('scripts')

<script>
    Livewire.on('reloadWhislist',function(event){
        Livewire.dispatch('reloadWhislistDetail')
    })
</script>
<script>
    Livewire.on('reloadCartDetail',function(event){
        Livewire.dispatch('reloadCartDetail')
    })
</script>

<script>
    // Función para mostrar notificaciones con estilo similar a Toastr
    function showNotify(message, type = 'success') {
        // Crear el contenedor de notificaciones si no existe
        let container = document.getElementById('notify-container');
        if (!container) {
            container = document.createElement('div');
            container.id = 'notify-container';
            container.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                z-index: 9999;
                width: 300px;
            `;
            document.body.appendChild(container);
        }

        // Crear la notificación
        const notifyId = 'notify_' + Date.now();
        const notify = document.createElement('div');
        notify.id = notifyId;
        notify.style.cssText = `
            margin-bottom: 10px;
            padding: 15px;
            border-radius: 4px;
            color: #fff;
            opacity: 0;
            transform: translateY(-20px);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        `;

        // Estilos según el tipo
        switch(type) {
            case 'success':
                notify.style.background = '#28a745';
                break;
            case 'error':
                notify.style.background = '#dc3545';
                break;
            case 'warning':
                notify.style.background = '#ffc107';
                notify.style.color = '#212529';
                break;
            case 'info':
                notify.style.background = '#17a2b8';
                break;
            default:
                notify.style.background = '#28a745';
        }

        notify.innerHTML = message;

        container.appendChild(notify);

        // Animar entrada
        setTimeout(() => {
            notify.style.opacity = '1';
            notify.style.transform = 'translateY(0)';
        }, 10);

        // Eliminar automáticamente después de 5 segundos
        setTimeout(() => {
            notify.style.opacity = '0';
            notify.style.transform = 'translateY(-20px)';
            setTimeout(() => {
                if (notify.parentNode) {
                    notify.parentNode.removeChild(notify);
                }
                // Eliminar contenedor si no hay más notificaciones
                if (container.children.length === 0) {
                    document.body.removeChild(container);
                }
            }, 300);
        }, 5000);
    }

    // Escuchar eventos de alerta de Livewire
    Livewire.on('alert', function (data) {
        if (typeof data === 'object' && data !== null) {
            // Handle both array and object formats
            const alertData = Array.isArray(data) ? data[0] : data;
            showNotify(alertData.text, alertData.icon);
        } else {
            console.error('Invalid alert data:', data);
        }
    });
</script>