<div>
    @section('content')
    <!-- Hero Section -->
    <section class="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-16">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-4xl font-bold mb-4">Nuestros Productos</h1>
            <p class="text-xl">Descubre nuestra amplia variedad de productos</p>
        </div>
    </section>

    <div class="container mx-auto px-4 py-8">
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Sidebar de Filtros -->
            <div class="lg:w-1/4">
                <div class="bg-white rounded-lg shadow-md p-6 sticky top-24">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold">Filtros</h3>
                        <button wire:click="limpiarFiltros"
                                class="text-blue-600 hover:text-blue-800 text-sm">
                            Limpiar todo
                        </button>
                    </div>

                    <!-- Búsqueda -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Buscar</label>
                        <input type="text"
                               wire:model.debounce.300ms="search"
                               placeholder="Buscar productos..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <!-- Categoría -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Categoría</label>
                        <select wire:model="categoria"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Todas las categorías</option>
                            @foreach($categorias as $cat)
                                <option value="{{ $cat }}">{{ $cat }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Rango de Precio -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Precio</label>
                        <div class="flex gap-2">
                            <input type="number"
                                   wire:model="precioMin"
                                   placeholder="Mín"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <input type="number"
                                   wire:model="precioMax"
                                   placeholder="Máx"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>

                    <!-- Ordenar -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Ordenar por</label>
                        <select wire:model="ordenarPor"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="name">Nombre</option>
                            <option value="price">Precio</option>
                            <option value="created_at">Más reciente</option>
                        </select>
                    </div>

                    <button wire:click="aplicarFiltros"
                            class="w-full bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition">
                        Aplicar Filtros
                    </button>
                </div>
            </div>

            <!-- Grid de Productos -->
            <div class="lg:w-3/4">
                <!-- Resultados y controles -->
                <div class="flex justify-between items-center mb-6">
                    <p class="text-gray-600">
                        Mostrando {{ $productos->firstItem() ?? 0 }} - {{ $productos->lastItem() ?? 0 }}
                        de {{ $productos->total() }} productos
                    </p>

                    <div class="flex items-center gap-2">
                        <span class="text-sm text-gray-600">Orden:</span>
                        <select wire:model="orden" class="px-3 py-1 border border-gray-300 rounded">
                            <option value="asc">Ascendente</option>
                            <option value="desc">Descendente</option>
                        </select>
                    </div>
                </div>

                @if($productos->isEmpty())
                    <div class="text-center py-12">
                        <svg class="w-24 h-24 text-gray-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M9.172 16.172a4 4 0 015.656 0M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 01-2-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        <h3 class="text-lg font-medium text-gray-900 mb-2">No se encontraron productos</h3>
                        <p class="text-gray-500">Intenta ajustar tus filtros de búsqueda</p>
                    </div>
                @else
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($productos as $producto)
                            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition">
                                <!-- Imagen del producto -->
                                <div class="h-48 bg-gray-200 relative">
                                    @if($producto->images && $producto->images->first())
                                        <img src="{{ str_replace('http://', 'https://', Storage::url($producto->images->first()->path)) }}"
                                             alt="{{ $producto->name }}"
                                             class="w-full h-full object-cover">
                                    @else
                                        <div class="w-full h-full flex items-center justify-center text-gray-400">
                                            <svg class="w-16 h-16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                </path>
                                            </svg>
                                        </div>
                                    @endif

                                    <!-- Stock badge -->
                                    @if($producto->quantity <= 0)
                                        <div class="absolute top-2 right-2 bg-red-500 text-white px-2 py-1 rounded text-xs">
                                            Agotado
                                        </div>
                                    @elseif($producto->quantity <= 5)
                                        <div class="absolute top-2 right-2 bg-yellow-500 text-white px-2 py-1 rounded text-xs">
                                            Últimas unidades
                                        </div>
                                    @endif
                                </div>

                                <!-- Información del producto -->
                                <div class="p-4">
                                    <h3 class="font-semibold text-lg mb-2 text-gray-800">{{ $producto->name }}</h3>
                                    <p class="text-gray-600 text-sm mb-3 line-clamp-2">{{ $producto->description }}</p>

                                    <div class="flex items-center mb-3">
                                        <div class="flex text-yellow-400">
                                            @for($i = 0; $i < 5; $i++)
                                                <svg class="w-4 h-4 fill-current {{ $i < ($producto->rating ?? 0) ? 'text-yellow-400' : 'text-gray-300' }}"
                                                     viewBox="0 0 20 20">
                                                    <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.939 5.955 6.572.955-4.756 4.635 1.123 6.545z"/>
                                                </svg>
                                            @endfor
                                        </div>
                                        <span class="text-sm text-gray-600 ml-2">({{ $producto->reviews_count ?? 0 }})</span>
                                    </div>

                                    <!-- Precio -->
                                    <div class="flex items-center justify-between mb-4">
                                        <div>
                                            <span class="text-2xl font-bold text-gray-900">${{ number_format($producto->price, 2) }}</span>
                                            @if($producto->discount_price)
                                                <span class="text-sm text-gray-500 line-through ml-2">${{ number_format($producto->discount_price, 2) }}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="flex justify-between items-center">
                                        @if($producto->quantity > 0)
                                            <button wire:click="addToCart({{ $producto->id }})"
                                                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                                                <i class="fas fa-cart-plus mr-1"></i>
                                                Agregar
                                            </button>
                                        @else
                                            <button disabled
                                                    class="bg-gray-300 text-gray-500 px-4 py-2 rounded-lg cursor-not-allowed">
                                                Agotado
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Paginación -->
                    <div class="mt-8">
                        {{ $productos->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
    @endsection
</div>
