<div>
    @section('title', 'Mis Favoritos')

    <section class="section bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <h2 class="mb-1">Mis Favoritos</h2>
                            <p class="text-muted mb-0">{{ $wishlists->total() }} productos guardados</p>
                        </div>

                        @if($wishlists->count() > 0)
                            <div class="btn-group" role="group">
                                <button type="button" class="btn {{ $viewMode === 'grid' ? 'btn-primary' : 'btn-outline-primary' }}"
                                        wire:click="setViewMode('grid')">
                                    <i class=" ri-circle-line "></i>
                                </button>
                                <button type="button" class="btn {{ $viewMode === 'list' ? 'btn-primary' : 'btn-outline-primary' }}"
                                        wire:click="setViewMode('list')">
                                    <i class=" ri-circle-line "></i>
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            @if($wishlists->count() > 0)
                <div class="row">
                    @foreach($wishlists as $wishlist)
                        @if($viewMode === 'grid')
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="card product-card h-100 shadow-sm">
                                    <div class="position-relative">
                                        <img src="/media/producto/{{ $wishlist->producto->image->path ?? '1746716467.webp' }}"
                                             alt="{{ $wishlist->producto->name }}"
                                             class="card-img-top"
                                             style="height: 200px; object-fit: cover;">

                                        <div class="position-absolute top-0 end-0 p-2">
                                            <button wire:click="removeFromWishlist({{ $wishlist->id }})"
                                                    class="btn btn-sm btn-danger rounded-circle">
                                                <i class=" ri-circle-line "></i>
                                            </button>
                                        </div>
                                    </div>

                                    <div class="card-body d-flex flex-column">
                                        <h6 class="card-title mb-2">{{ $wishlist->producto->name }}</h6>
                                        <p class="text-muted small mb-2">
                                            <i class=" ri-circle-line  me-1"></i>{{ $wishlist->producto->categoria->name }}
                                        </p>

                                        <div class="mt-auto">
                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <span class="h6 mb-0 text-primary">{{ money($wishlist->producto->price) }}</span>
                                                @if($wishlist->producto->precio_bs)
                                                    <small class="text-muted">{{ $wishlist->producto->precio_bs }} Bs</small>
                                                @endif
                                            </div>

                                            <div class="d-grid gap-2">
                                                <button wire:click="addToCart({{ $wishlist->producto->id }})"
                                                        class="btn btn-primary btn-sm">
                                                    <i class=" ri-circle-line  me-1"></i>
                                                    Añadir al carrito
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-12 mb-3">
                                <div class="card">
                                    <div class="row g-0">
                                        <div class="col-md-2">
                                            <img src="/media/producto/{{ $wishlist->producto->image->path ?? '1746716467.webp' }}"
                                                 alt="{{ $wishlist->producto->name }}"
                                                 class="img-fluid rounded-start h-100"
                                                 style="object-fit: cover; min-height: 120px;">
                                        </div>
                                        <div class="col-md-8">
                                            <div class="card-body">
                                                <h5 class="card-title">{{ $wishlist->producto->name }}</h5>
                                                <p class="text-muted">
                                                    <i class=" ri-circle-line  me-1"></i>{{ $wishlist->producto->categoria->name }}
                                                </p>
                                                <div class="d-flex align-items-center">
                                                    <span class="h5 mb-0 text-primary me-3">{{ money($wishlist->producto->price) }}</span>
                                                    @if($wishlist->producto->precio_bs)
                                                        <small class="text-muted">{{ $wishlist->producto->precio_bs }} Bs</small>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2 d-flex align-items-center justify-content-center">
                                            <div class="d-flex flex-column gap-2 p-3">
                                                <button wire:click="addToCart({{ $wishlist->producto->id }})"
                                                        class="btn btn-primary btn-sm">
                                                    <i class=" ri-circle-line "></i>
                                                </button>
                                                <button wire:click="removeFromWishlist({{ $wishlist->id }})"
                                                        class="btn btn-outline-danger btn-sm">
                                                    <i class=" ri-circle-line "></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>

                <!-- Paginación -->
                @if($wishlists->hasPages())
                    <div class="row">
                        <div class="col-12">
                            <div class="d-flex justify-content-center">
                                {{ $wishlists->links() }}
                            </div>
                        </div>
                    </div>
                @endif
            @else
                <div class="row">
                    <div class="col-12">
                        <div class="text-center py-5">
                            <i class=" ri-circle-line  display-1 text-muted mb-4"></i>
                            <h4>No tienes productos favoritos</h4>
                            <p class="text-muted mb-4">Explora nuestros productos y agrega los que más te gusten a favoritos</p>
                            <a href="/" class="btn btn-primary">
                                <i class=" ri-circle-line  me-2"></i>
                                Explorar productos
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
</div>
