<div>
    @if($showModal && $product)
        <div class="modal fade show quick-view-modal" tabindex="-1" style="display: block; background: rgba(0,0,0,0.75); z-index: 1050;" aria-modal="true" role="dialog" wire:ignore.self wire:click="closeModal">
            <div class="modal-dialog modal-xl modal-dialog-centered" @click.stop>
                <div class="modal-content quick-view-content border-0 shadow" style="animation: modalSlideIn 0.3s cubic-bezier(0.16, 1, 0.3, 1);">
                    <!-- Close Button -->
                    <button type="button" class="btn-close-custom" wire:click="closeModal" aria-label="Close">
                        <i class="ri-close-line"></i>
                    </button>

                    <div class="quick-view-wrapper">
                        <!-- Left Side - Gallery -->
                        <div class="quick-view-gallery">
                            @php
                                $galleryImages = collect();
                                if ($selectedVariant && $selectedVariant->image_path) {
                                    $galleryImages->push(['path' => $selectedVariant->image_path, 'type' => 'variant']);
                                }
                                if ($product->images && $product->images->isNotEmpty()) {
                                    foreach($product->images as $img) {
                                        $galleryImages->push(['path' => $img->path, 'type' => 'product']);
                                    }
                                }
                            @endphp

                            @if($galleryImages->isNotEmpty())
                                <!-- Main Image -->
                                <div class="main-image-container">
                                    <div class="swiper product-gallery-main"
                                         wire:key="main-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                        <div class="swiper-wrapper">
                                            @foreach($galleryImages as $index => $image)
                                                <div class="swiper-slide" wire:key="slide-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                    <div class="image-wrapper">
                                                        <img src="{{ asset('app/' . $image['path']) }}"
                                                             alt="{{ $product->name }}"
                                                             wire:key="img-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="swiper-button-next"></div>
                                        <div class="swiper-button-prev"></div>
                                    </div>
                                </div>

                                <!-- Thumbnails -->
                                @if($galleryImages->count() > 1)
                                    <div class="thumbnails-container"
                                         wire:key="thumbs-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                        <div class="swiper product-gallery-thumbs">
                                            <div class="swiper-wrapper">
                                                @foreach($galleryImages as $index => $image)
                                                    <div class="swiper-slide" wire:key="thumb-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                        <div class="thumb-wrapper">
                                                            <img src="{{ asset('app/' . $image['path']) }}"
                                                                 alt="{{ $product->name }}"
                                                                 class="{{ $index === 0 ? 'active' : '' }}">
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @else
                                <div class="no-image-container"
                                     wire:key="no-image-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                    <div class="no-image-content">
                                        <i class="ri-image-line"></i>
                                        <p>Sin imagen disponible</p>
                                    </div>
                                </div>
                            @endif
                        </div>

                        <!-- Right Side - Product Info -->
                        <div class="quick-view-info">
                            <!-- Product Header -->
                            <div class="product-header">
                                <div class="product-badges">
                                    <span class="badge badge-primary">
                                        <i class="ri-folder-line me-1"></i>{{ $product->categoria->nombre ?? 'Sin categoría' }}
                                    </span>
                                    <span class="badge badge-secondary">
                                        <i class="ri-price-tag-3-line me-1"></i>{{ $product->marca->nombre ?? 'Sin marca' }}
                                    </span>
                                </div>

                                <h1 class="product-title">{{ $product->name }}</h1>

                                <div class="product-rating">
                                    @php
                                        $rating = $product->rating ?? 4.5;
                                        $fullStars = floor($rating);
                                        $halfStar = $rating - $fullStars >= 0.5;
                                    @endphp
                                    <div class="stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= $fullStars)
                                                <i class="ri-star-fill"></i>
                                            @elseif($halfStar && $i == $fullStars + 1)
                                                <i class="ri-star-half-fill"></i>
                                            @else
                                                <i class="ri-star-line"></i>
                                            @endif
                                        @endfor
                                    </div>
                                    <span class="reviews-count">({{ $product->reviews_count ?? rand(10, 150) }} reseñas)</span>
                                </div>

                                @php
                                    $stock = $selectedVariant->stock ?? $product->stock ?? 100;
                                @endphp
                                <div class="stock-status {{ $stock <= 0 ? 'out-of-stock' : ($stock <= 5 ? 'low-stock' : 'in-stock') }}">
                                    @if($stock <= 0)
                                        <i class="ri-close-circle-line"></i>
                                        <span>Agotado</span>
                                    @elseif($stock <= 5)
                                        <i class="ri-error-warning-line"></i>
                                        <span>Pocas unidades ({{ $stock }})</span>
                                    @else
                                        <i class="ri-checkbox-circle-line"></i>
                                        <span>En stock</span>
                                    @endif
                                </div>
                            </div>

                            <!-- Price Section -->
                            <div class="price-section">
                                @php
                                    $exchangeRate = \App\Models\ExchangeRate::getLatestRate('USD');
                                    if ($selectedVariant) {
                                        if (isset($selectedVariant->price) && $selectedVariant->price > 0) {
                                            $finalPriceUsd = $selectedVariant->price;
                                        } else {
                                            $finalPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                        }
                                    } else {
                                        $finalPriceUsd = $product->price;
                                    }
                                    if ($selectedVariant) {
                                        if (isset($selectedVariant->precio_bs) && $selectedVariant->precio_bs > 0) {
                                            $finalPriceBs = $selectedVariant->precio_bs;
                                        } else {
                                            $variantPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                            $finalPriceBs = $variantPriceUsd * ($exchangeRate ?: 1);
                                        }
                                    } else {
                                        if (isset($product->precio_bs) && $product->precio_bs > 0) {
                                            $finalPriceBs = $product->precio_bs;
                                        } else {
                                            $finalPriceBs = $finalPriceUsd * ($exchangeRate ?: 1);
                                        }
                                    }
                                @endphp

                                <div class="price-display">
                                    @if($currency === 'bs' && is_venezuela_company())
                                        <div class="price-current">
                                            <span class="price-label">Precio:</span>
                                            <span class="price-value">Bs. {{ number_format($finalPriceBs * $exchangeRate, 2, ',', '.') }}</span>
                                        </div>
                                    @else
                                        <div class="price-current">
                                            <span class="price-label">Precio:</span>
                                            <span class="price-value">{{ format_money($finalPriceUsd) }}</span>
                                        </div>
                                    @endif
                                </div>

                                @if(is_venezuela_company())
                                    <div class="currency-toggle">
                                        <label class="currency-option {{ $currency === 'usd' ? 'active' : '' }}">
                                            <input type="radio" name="currency" value="usd" wire:model.live="currency" {{ $currency === 'usd' ? 'checked' : '' }}>
                                            <span>USD</span>
                                        </label>
                                        <label class="currency-option {{ $currency === 'bs' ? 'active' : '' }}">
                                            <input type="radio" name="currency" value="bs" wire:model.live="currency" {{ $currency === 'bs' ? 'checked' : '' }}>
                                            <span>Bs</span>
                                        </label>
                                    </div>
                                @endif
                            </div>

                            <!-- Variants -->
                            @if($product->variants && $product->variants->count() > 0)
                                <div class="variants-section">
                                    <h3 class="section-title">Variantes</h3>
                                    <div class="variants-grid">
                                        @foreach($product->variants as $variant)
                                            <button type="button"
                                                    class="variant-btn {{ $selectedVariant && $selectedVariant->id == $variant->id ? 'active' : '' }}"
                                                    wire:click="selectVariant({{ $variant->id }})"
                                                    wire:key="variant-{{ $variant->id }}">
                                                @php
                                                    $values = is_string($variant->values) ? json_decode($variant->values, true) : $variant->values;
                                                    if (is_array($values)) {
                                                        echo implode(', ', array_values($values));
                                                    } else {
                                                        echo $variant->values;
                                                    }
                                                @endphp
                                            </button>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <!-- Quantity Selector -->
                            <div class="quantity-section">
                                <h3 class="section-title">Cantidad</h3>
                                <div class="quantity-selector">
                                    <button class="qty-btn qty-minus" wire:click="decrementQuantity" {{ ($quantity ?? 1) <= 1 ? 'disabled' : '' }}>
                                        <i class="ri-subtract-line"></i>
                                    </button>
                                    <input type="text" class="qty-input" value="{{ $quantity ?? 1 }}" readonly>
                                    <button class="qty-btn qty-plus" wire:click="incrementQuantity" {{ $stock <= 0 ? 'disabled' : '' }}>
                                        <i class="ri-add-line"></i>
                                    </button>
                                </div>
                                @if($stock > 0 && $stock <= 10)
                                    <div class="stock-info">Máximo disponible: {{ $stock }}</div>
                                @endif
                            </div>

                            <!-- Action Buttons -->
                            <div class="actions-section">
                                @auth
                                    <button class="btn btn-primary btn-add-cart" wire:click="addToCart" {{ $stock <= 0 ? 'disabled' : '' }}>
                                        <i class="ri-shopping-cart-2-line me-2"></i>
                                        Añadir al Carrito
                                    </button>
                                    <button class="btn btn-outline-danger btn-wishlist" 
                                            wire:click="addWishlist({{ $product->id }})"
                                            title="{{ $fav->contains('producto_id', $product->id) ? 'Eliminar de Favoritos' : 'Añadir a Favoritos' }}">
                                        <i class="{{ $fav->contains('producto_id', $product->id) ? 'ri-heart-fill' : 'ri-heart-line' }}"></i>
                                    </button>
                                @endauth
                            </div>

                            <!-- Product Tabs -->
                            <div class="product-tabs-container">
                                <ul class="product-tabs">
                                    <li class="tab-item active">
                                        <button class="tab-link" data-tab="description">
                                            <i class="ri-file-text-line"></i>
                                            <span>Descripción</span>
                                        </button>
                                    </li>
                                    <li class="tab-item">
                                        <button class="tab-link" data-tab="specs">
                                            <i class="ri-list-check-2"></i>
                                            <span>Especificaciones</span>
                                        </button>
                                    </li>
                                    <li class="tab-item">
                                        <button class="tab-link" data-tab="reviews">
                                            <i class="ri-chat-3-line"></i>
                                            <span>Reseñas</span>
                                        </button>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="description">
                                        <p>{{ $product->description ?? 'Sin descripción disponible para este producto.' }}</p>
                                    </div>
                                    <div class="tab-pane" id="specs">
                                        @if($product->specifications ?? false)
                                            <ul class="specs-list">
                                                @foreach($product->specifications as $key => $value)
                                                    <li class="spec-item">
                                                        <span class="spec-label">{{ $key }}</span>
                                                        <span class="spec-value">{{ $value }}</span>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <p class="no-specs">No hay especificaciones disponibles.</p>
                                        @endif
                                    </div>
                                    <div class="tab-pane" id="reviews">
                                        <div class="reviews-placeholder">
                                            <i class="ri-chat-smile-2-line"></i>
                                            <p>Las reseñas estarán disponibles próximamente.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Related Products -->
                            @if($relatedProducts && $relatedProducts->count() > 0)
                                <div class="related-products-section">
                                    <h3 class="section-title">Productos Relacionados</h3>
                                    <div class="related-products-swiper" style="overflow: hidden;">
                                        <div class="swiper-wrapper">
                                            @foreach($relatedProducts as $related)
                                                <div class="swiper-slide">
                                                    <div class="related-product-card"
                                                         wire:click="selectRelatedProduct({{ $related->id }})"
                                                         wire:key="related-{{ $related->id }}">
                                                        <div class="related-product-image">
                                                            @if($related->images && $related->images->first())
                                                                <img src="{{ asset('app/' . $related->images->first()->path) }}"
                                                                     alt="{{ $related->name }}">
                                                            @else
                                                                <div class="no-image">
                                                                    <i class="ri-image-line"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="related-product-info">
                                                            <h4>{{ $related->name }}</h4>
                                                            @php
                                                                $relatedExchangeRate = \App\Models\ExchangeRate::getLatestRate('USD');
                                                                if (isset($related->precio_bs) && $related->precio_bs > 0) {
                                                                    $relatedPriceBs = $related->precio_bs;
                                                                } else {
                                                                    $relatedPriceBs = $related->price * ($relatedExchangeRate ?: 1);
                                                                }
                                                            @endphp
                                                            @if($currency === 'bs' && is_venezuela_company())
                                                                <p class="price">Bs. {{ number_format($relatedPriceBs * $exchangeRate, 2, ',', '.') }}</p>
                                                            @else
                                                                <p class="price">{{ format_money($related->price) }}</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="swiper-pagination related-products-pagination"></div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@section('styles')
<style>
    /* Modal Animation */
    @keyframes modalSlideIn {
        from {
            opacity: 0;
            transform: translateY(30px) scale(0.95);
        }
        to {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }

    /* Modal Base */
    .quick-view-modal {
        backdrop-filter: blur(8px);
    }

    .quick-view-content {
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    }

    /* Close Button */
    .btn-close-custom {
        position: absolute;
        top: 20px;
        right: 20px;
        z-index: 10;
        width: 40px;
        height: 40px;
        border: none;
        background: rgba(255, 255, 255, 0.95);
        border-radius: 50%;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: #333;
        transition: all 0.3s ease;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .btn-close-custom:hover {
        transform: rotate(90deg) scale(1.1);
        background: var(--bs-danger);
        color: white;
    }

    /* Main Wrapper */
    .quick-view-wrapper {
        display: flex;
        min-height: 600px;
    }

    /* Gallery Section */
    .quick-view-gallery {
        flex: 0 0 50%;
        background: #f8f9fa;
        padding: 40px;
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .main-image-container {
        flex: 1;
        border-radius: 16px;
        overflow: hidden;
        background: white;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .image-wrapper {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .image-wrapper img {
        max-width: 100%;
        max-height: 450px;
        object-fit: contain;
        transition: transform 0.3s ease;
    }

    .image-wrapper img:hover {
        transform: scale(1.05);
    }

    .thumbnails-container {
        height: 80px;
    }

    .thumb-wrapper {
        width: 100%;
        height: 100%;
        border-radius: 12px;
        overflow: hidden;
        cursor: pointer;
        border: 2px solid transparent;
        transition: all 0.3s ease;
    }

    .thumb-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .thumb-wrapper.active,
    .thumb-wrapper:hover {
        border-color: var(--bs-primary);
    }

    .no-image-container {
        flex: 1;
        border-radius: 16px;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .no-image-content {
        text-align: center;
        color: #999;
    }

    .no-image-content i {
        font-size: 64px;
        display: block;
        margin-bottom: 16px;
    }

    /* Info Section */
    .quick-view-info {
        flex: 0 0 50%;
        padding: 40px;
        display: flex;
        flex-direction: column;
        gap: 24px;
        overflow-y: auto;
        max-height: 600px;
    }

    /* Product Header */
    .product-header {
        padding-bottom: 20px;
        border-bottom: 1px solid #eee;
    }

    .product-badges {
        display: flex;
        gap: 10px;
        margin-bottom: 16px;
        flex-wrap: wrap;
    }

    .badge {
        padding: 8px 16px;
        border-radius: 20px;
        font-weight: 500;
        font-size: 13px;
    }

    .badge-primary {
        background: var(--bs-primary);
        color: white;
    }

    .badge-secondary {
        background: #6c757d;
        color: white;
    }

    .product-title {
        font-size: 28px;
        font-weight: 700;
        margin: 0 0 12px 0;
        color: #212529;
        line-height: 1.3;
    }

    .product-rating {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
    }

    .stars {
        display: flex;
        gap: 2px;
    }

    .stars i {
        font-size: 18px;
        color: #ffc107;
    }

    .reviews-count {
        font-size: 14px;
        color: #6c757d;
    }

    .stock-status {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 500;
    }

    .stock-status.in-stock {
        background: #d4edda;
        color: #155724;
    }

    .stock-status.low-stock {
        background: #fff3cd;
        color: #856404;
    }

    .stock-status.out-of-stock {
        background: #f8d7da;
        color: #721c24;
    }

    /* Price Section */
    .price-section {
        padding: 20px;
        background: #f8f9fa;
        border-radius: 12px;
    }

    .price-display {
        display: flex;
        align-items: baseline;
        gap: 12px;
        margin-bottom: 16px;
    }

    .price-label {
        font-size: 14px;
        color: #6c757d;
        font-weight: 500;
    }

    .price-value {
        font-size: 32px;
        font-weight: 700;
        color: var(--bs-primary);
    }

    .currency-toggle {
        display: flex;
        gap: 8px;
        background: white;
        padding: 4px;
        border-radius: 10px;
    }

    .currency-option {
        flex: 1;
        padding: 8px;
        text-align: center;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 500;
        position: relative;
    }

    .currency-option input {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }

    .currency-option.active {
        background: var(--bs-primary);
        color: white;
    }

    /* Variants Section */
    .variants-section {
        margin-bottom: 8px;
    }

    .section-title {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 12px;
        color: #212529;
    }

    .variants-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    .variant-btn {
        padding: 10px 20px;
        border: 2px solid #dee2e6;
        background: white;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 500;
        font-size: 14px;
    }

    .variant-btn:hover {
        border-color: var(--bs-primary);
        background: rgba(var(--bs-primary-rgb), 0.05);
    }

    .variant-btn.active {
        border-color: var(--bs-primary);
        background: var(--bs-primary);
        color: white;
    }

    /* Quantity Section */
    .quantity-section {
        margin-bottom: 8px;
    }

    .quantity-selector {
        display: flex;
        align-items: center;
        gap: 0;
        border-radius: 10px;
        overflow: hidden;
        width: fit-content;
    }

    .qty-btn {
        width: 44px;
        height: 44px;
        border: none;
        background: #f8f9fa;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        transition: all 0.3s ease;
    }

    .qty-btn:hover:not(:disabled) {
        background: var(--bs-primary);
        color: white;
    }

    .qty-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .qty-input {
        width: 60px;
        height: 44px;
        border: none;
        background: white;
        text-align: center;
        font-weight: 600;
        font-size: 16px;
    }

    .stock-info {
        margin-top: 8px;
        font-size: 13px;
        color: #6c757d;
    }

    /* Actions Section */
    .actions-section {
        display: flex;
        gap: 12px;
        margin-bottom: 8px;
    }

    .btn-add-cart {
        flex: 1;
        padding: 14px 24px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .btn-add-cart:hover:not(:disabled) {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(var(--bs-primary-rgb), 0.4);
    }

    .btn-wishlist {
        width: 54px;
        height: 54px;
        border-radius: 12px;
        font-size: 20px;
        transition: all 0.3s ease;
    }

    .btn-wishlist:hover {
        transform: scale(1.1);
    }

    /* Tabs Section */
    .product-tabs-container {
        margin-top: 16px;
    }

    .product-tabs {
        display: flex;
        gap: 8px;
        margin-bottom: 16px;
        border-bottom: 2px solid #eee;
        padding-bottom: 8px;
    }

    .tab-item {
        list-style: none;
    }

    .tab-link {
        display: flex;
        align-items: center;
        gap: 6px;
        padding: 10px 16px;
        border: none;
        background: none;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        color: #6c757d;
        border-radius: 8px;
        transition: all 0.3s ease;
    }

    .tab-link:hover {
        color: var(--bs-primary);
        background: rgba(var(--bs-primary-rgb), 0.05);
    }

    .tab-item.active .tab-link {
        color: var(--bs-primary);
        background: var(--bs-primary);
        color: white;
    }

    .tab-content {
        padding: 16px;
        background: #f8f9fa;
        border-radius: 12px;
    }

    .tab-pane {
        display: none;
    }

    .tab-pane.active {
        display: block;
        animation: fadeIn 0.3s ease;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .specs-list {
        list-style: none;
        padding: 0;
    }

    .spec-item {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .spec-label {
        color: #6c757d;
        font-weight: 500;
    }

    .spec-value {
        color: #212529;
        font-weight: 600;
    }

    .no-specs {
        color: #6c757d;
        text-align: center;
        padding: 20px;
    }

    .reviews-placeholder {
        text-align: center;
        padding: 40px 20px;
        color: #6c757d;
    }

    .reviews-placeholder i {
        font-size: 48px;
        display: block;
        margin-bottom: 12px;
    }

    /* Related Products */
    .related-products-section {
        margin-top: 16px;
    }

    .related-products-swiper {
        padding-bottom: 40px;
    }

    .related-product-card {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .related-product-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .related-product-image {
        width: 140px;
        height: 140px;
        border-radius: 10px;
        overflow: hidden;
        background: #f8f9fa;
        margin-bottom: 12px;
    }

    .related-product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .related-product-image .no-image {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #999;
    }

    .related-product-info h4 {
        font-size: 14px;
        font-weight: 600;
        margin: 0 0 8px 0;
        color: #212529;
        line-height: 1.4;
    }

    .related-product-info .price {
        font-size: 16px;
        font-weight: 700;
        color: var(--bs-primary);
        margin: 0;
    }

    /* Swiper Customization */
    .product-gallery-main .swiper-button-next,
    .product-gallery-main .swiper-button-prev {
        width: 44px;
        height: 44px;
        background: rgba(255, 255, 255, 0.95);
        border-radius: 50%;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .product-gallery-main .swiper-button-next::after,
    .product-gallery-main .swiper-button-prev::after {
        font-size: 18px;
        font-weight: bold;
        color: #333;
    }

    .related-products-pagination .swiper-pagination-bullet {
        width: 8px;
        height: 8px;
        background: #ddd;
        opacity: 1;
        transition: all 0.3s ease;
    }

    .related-products-pagination .swiper-pagination-bullet-active {
        background: var(--bs-primary);
        width: 24px;
        border-radius: 4px;
    }

    /* Responsive */
    @media (max-width: 991px) {
        .quick-view-wrapper {
            flex-direction: column;
        }

        .quick-view-gallery,
        .quick-view-info {
            flex: 0 0 100%;
        }

        .quick-view-gallery {
            padding: 20px;
        }

        .quick-view-info {
            padding: 20px;
            max-height: none;
        }

        .product-title {
            font-size: 24px;
        }
    }

    @media (max-width: 576px) {
        .quick-view-content {
            border-radius: 16px;
        }

        .quick-view-gallery,
        .quick-view-info {
            padding: 16px;
        }

        .product-title {
            font-size: 20px;
        }

        .price-value {
            font-size: 24px;
        }

        .actions-section {
            flex-direction: column;
        }

        .btn-add-cart,
        .btn-wishlist {
            width: 100%;
        }
    }
</style>
@endsection

@section('scripts')
@include('livewire.front.quick-view-js')
@endsection
