<div>
    @if($showModal && $product)
        <div class="modal fade show quick-view-modal" tabindex="-1" style="display: block; background: rgba(0,0,0,0.7); z-index: 1050;" aria-modal="true" role="dialog" wire:ignore.self wire:click="closeModal">
            <div class="modal-dialog modal-xl modal-dialog-centered" @click.stop>
                <div class="modal-content quick-view-content border-0 shadow-lg" style="animation: slideInUp 0.4s cubic-bezier(0.4, 0, 0.2, 1);">
                    <div class="modal-header border-0 pb-0 px-4 pt-4">
                        <div class="d-flex align-items-center gap-2">
                            <div class="avatar-sm bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center">
                                <i class="ri-eye-line text-primary fs-5"></i>
                            </div>
                            <div>
                                <h6 class="mb-0 fw-semibold">Vista Rápida</h6>
                                <small class="text-muted fs-12">Detalles del producto</small>
                            </div>
                        </div>
                        <button type="button" class="btn btn-icon btn-ghost-secondary rounded-circle" wire:click="closeModal" aria-label="Close" style="width: 38px; height: 38px;">
                            <i class="ri-close-line fs-5"></i>
                        </button>
                    </div>
                    <div class="modal-body pt-2 px-4 pb-4">
                        <div class="row g-4">
                            <!-- Galería de imágenes con Swiper -->
                            <div class="col-lg-6">
                                <div class="product-gallery position-relative" wire:ignore.self>
                                    @php
                                        $galleryImages = collect();
                                        if ($selectedVariant && $selectedVariant->image_path) {
                                            $galleryImages->push(['path' => $selectedVariant->image_path, 'type' => 'variant']);
                                        }
                                        if ($product->images && $product->images->isNotEmpty()) {
                                            foreach($product->images as $img) {
                                                $galleryImages->push(['path' => $img->path, 'type' => 'product']);
                                            }
                                        }
                                    @endphp

                                    @if($galleryImages->isNotEmpty())
                                        <!-- Main Swiper -->
                                        <div class="swiper product-gallery-main rounded-3 overflow-hidden mb-3 bg-light"
                                             wire:key="main-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                            <div class="swiper-wrapper">
                                                @foreach($galleryImages as $index => $image)
                                                    <div class="swiper-slide" wire:key="slide-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                        <div class="d-flex align-items-center justify-content-center" style="height: 420px;">
                                                            <img src="{{ asset('app/' . $image['path']) }}"
                                                                 class="img-fluid"
                                                                 style="max-height: 100%; object-fit: contain;"
                                                                 alt="{{ $product->name }}"
                                                                 wire:key="img-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div class="swiper-button-next"></div>
                                            <div class="swiper-button-prev"></div>
                                        </div>

                                        <!-- Thumbnails Swiper -->
                                        @if($galleryImages->count() > 1)
                                            <div class="swiper product-gallery-thumbs"
                                                 wire:key="thumbs-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                                <div class="swiper-wrapper">

                                                </div>
                                            </div>
                                        @endif
                                    @else
                                        <div class="bg-light rounded-3 d-flex align-items-center justify-content-center" style="height: 420px;"
                                             wire:key="no-image-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                            <div class="text-center text-muted">
                                                <div class="avatar-lg mx-auto mb-3">
                                                    <div class="avatar-title bg-light rounded-circle">
                                                        <i class="ri-image-line fs-2"></i>
                                                    </div>
                                                </div>
                                                <p class="mb-0">Sin imagen disponible</p>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Información del producto -->
                            <div class="col-lg-6">
                                <!-- Categoría y marca -->
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <span class="badge bg-primary-subtle text-primary px-3 py-2 rounded-pill">
                                        <i class="ri-folder-line me-1"></i>{{ $product->categoria->nombre ?? 'Sin categoría' }}
                                    </span>
                                    <span class="badge bg-info-subtle text-info px-3 py-2 rounded-pill">
                                        <i class="ri-price-tag-3-line me-1"></i>{{ $product->marca->nombre ?? 'Sin marca' }}
                                    </span>
                                </div>

                                <!-- Nombre del producto -->
                                <h3 class="mb-3 fw-bold">{{ $product->name }}</h3>

                                <!-- Rating visual -->
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <div class="rating-stars">
                                        @php
                                            $rating = $product->rating ?? 4.5;
                                            $fullStars = floor($rating);
                                            $halfStar = $rating - $fullStars >= 0.5;
                                        @endphp
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= $fullStars)
                                                <i class="ri-star-fill text-warning fs-5"></i>
                                            @elseif($halfStar && $i == $fullStars + 1)
                                                <i class="ri-star-half-fill text-warning fs-5"></i>
                                            @else
                                                <i class="ri-star-line text-muted fs-5"></i>
                                            @endif
                                        @endfor
                                    </div>
                                    <span class="text-muted fs-13">({{ $product->reviews_count ?? rand(10, 150) }} reseñas)</span>
                                </div>

                                <!-- Badge de stock -->
                                @php
                                    $stock = $selectedVariant->stock ?? $product->stock ?? 100;
                                @endphp
                                <div class="mb-3">
                                    @if($stock <= 0)
                                        <span class="badge bg-danger-subtle text-danger px-3 py-2 rounded-pill">
                                            <i class="ri-close-circle-line me-1"></i>Agotado
                                        </span>
                                    @elseif($stock <= 5)
                                        <span class="badge bg-warning-subtle text-warning px-3 py-2 rounded-pill">
                                            <i class="ri-error-warning-line me-1"></i>Pocas unidades ({{ $stock }})
                                        </span>
                                    @else
                                        <span class="badge bg-success-subtle text-success px-3 py-2 rounded-pill">
                                            <i class="ri-checkbox-circle-line me-1"></i>En stock
                                        </span>
                                    @endif
                                </div>

                                <!-- Precio -->
                                <div class="mb-4 p-4 bg-light bg-opacity-50 rounded-3">
                                    @php
                                        $exchangeRate = \App\Models\ExchangeRate::getLatestRate('USD');
                                        if ($selectedVariant) {
                                            if (isset($selectedVariant->price) && $selectedVariant->price > 0) {
                                                $finalPriceUsd = $selectedVariant->price;
                                            } else {
                                                $finalPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                            }
                                        } else {
                                            $finalPriceUsd = $product->price;
                                        }
                                        if ($selectedVariant) {
                                            if (isset($selectedVariant->precio_bs) && $selectedVariant->precio_bs > 0) {
                                                $finalPriceBs = $selectedVariant->precio_bs;
                                            } else {
                                                $variantPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                                $finalPriceBs = $variantPriceUsd * ($exchangeRate ?: 1);
                                            }
                                        } else {
                                            if (isset($product->precio_bs) && $product->precio_bs > 0) {
                                                $finalPriceBs = $product->precio_bs;
                                            } else {
                                                $finalPriceBs = $finalPriceUsd * ($exchangeRate ?: 1);
                                            }
                                        }
                                    @endphp

                                    <div class="d-flex align-items-center justify-content-between">
                                        <div>
                                            @if($currency === 'bs' && is_venezuela_company())
                                                <span class="h2 text-primary fw-bold mb-0">
                                                    Bs. {{ number_format($finalPriceBs * $exchangeRate, 2, ',', '.') }}
                                                </span>
                                            @else
                                                <span class="h2 text-primary fw-bold mb-0">
                                                    {{ format_money($finalPriceUsd) }}
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Selector de moneda -->
                                        @if(is_venezuela_company())
                                            <div class="btn-group btn-group-sm" role="group">
                                                <input type="radio" class="btn-check" name="currency" id="currency-usd-qv" autocomplete="off"
                                                       wire:model.live="currency" value="usd" {{ $currency === 'usd' ? 'checked' : '' }}>
                                                <label class="btn btn-outline-primary" for="currency-usd-qv">
                                                    <i class="ri-money-dollar-circle-line me-1"></i>USD
                                                </label>

                                                <input type="radio" class="btn-check" name="currency" id="currency-bs-qv" autocomplete="off"
                                                       wire:model.live="currency" value="bs" {{ $currency === 'bs' ? 'checked' : '' }}>
                                                <label class="btn btn-outline-primary" for="currency-bs-qv">
                                                    <i class="ri-money-cny-circle-line me-1"></i>Bs
                                                </label>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- Selector de variantes -->
                                @if($product->variants && $product->variants->count() > 0)
                                    <div class="mb-4">
                                        <label class="form-label fw-semibold mb-2">
                                            <i class="ri-palette-line me-1"></i>Variantes disponibles:
                                        </label>
                                        <div class="d-flex flex-wrap gap-2">
                                            @foreach($product->variants as $variant)
                                                <button type="button"
                                                        class="btn btn-sm {{ $selectedVariant && $selectedVariant->id == $variant->id ? 'btn-primary' : 'btn-outline-secondary' }} rounded-pill px-3"
                                                        wire:click="selectVariant({{ $variant->id }})"
                                                        wire:key="variant-{{ $variant->id }}">
                                                    @php
                                                        $values = is_string($variant->values) ? json_decode($variant->values, true) : $variant->values;
                                                        if (is_array($values)) {
                                                            echo implode(', ', array_values($values));
                                                        } else {
                                                            echo $variant->values;
                                                        }
                                                    @endphp
                                                </button>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif

                                <!-- Selector de cantidad -->
                                <div class="mb-4">
                                    <label class="form-label fw-semibold mb-2">
                                        <i class="ri-shopping-basket-line me-1"></i>Cantidad:
                                    </label>
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="input-group" style="width: 140px;">
                                            <button class="btn btn-outline-secondary" type="button" wire:click="decrementQuantity" {{ ($quantity ?? 1) <= 1 ? 'disabled' : '' }}>
                                                <i class="ri-subtract-line"></i>
                                            </button>
                                            <input type="text" class="form-control text-center fw-bold" value="{{ $quantity ?? 1 }}" readonly>
                                            <button class="btn btn-outline-secondary" type="button" wire:click="incrementQuantity" {{ $stock <= 0 ? 'disabled' : '' }}>
                                                <i class="ri-add-line"></i>
                                            </button>
                                        </div>
                                        @if($stock > 0 && $stock <= 10)
                                            <span class="text-muted fs-13">Máximo disponible: {{ $stock }}</span>
                                        @endif
                                    </div>
                                </div>

                                <!-- Botones de acción -->
                                @auth
                                    <div class="d-flex gap-2 mb-4">
                                        <button class="btn btn-primary flex-grow-1 py-3 fw-semibold" wire:click="addToCart" {{ $stock <= 0 ? 'disabled' : '' }}>
                                            <i class="ri-shopping-cart-2-line me-2"></i>
                                            Añadir al Carrito
                                        </button>
                                        <button class="btn {{ $fav->contains('producto_id', $product->id) ? 'btn-danger' : 'btn-outline-danger' }} px-4"
                                                wire:click="addWishlist({{ $product->id }})"
                                                title="{{ $fav->contains('producto_id', $product->id) ? 'Eliminar de Favoritos' : 'Añadir a Favoritos' }}">
                                            <i class="{{ $fav->contains('producto_id', $product->id) ? 'ri-heart-fill' : 'ri-heart-line' }} fs-5"></i>
                                        </button>
                                    </div>
                                @endauth

                                <!-- Tabs de información -->
                                <div class="product-tabs">
                                    <ul class="nav nav-tabs nav-tabs-custom" id="productTabs" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="desc-tab" data-bs-toggle="tab" data-bs-target="#desc-content" type="button" role="tab">
                                                <i class="ri-file-text-line me-1"></i>Descripción
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="specs-tab" data-bs-toggle="tab" data-bs-target="#specs-content" type="button" role="tab">
                                                <i class="ri-list-check-2 me-1"></i>Especificaciones
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews-content" type="button" role="tab">
                                                <i class="ri-chat-3-line me-1"></i>Reseñas
                                            </button>
                                        </li>
                                    </ul>
                                    <div class="tab-content p-3 border border-top-0 rounded-bottom" id="productTabsContent">
                                        <!-- Descripción -->
                                        <div class="tab-pane fade show active" id="desc-content" role="tabpanel">
                                            <p class="text-muted mb-0">{{ $product->description ?? 'Sin descripción disponible para este producto.' }}</p>
                                        </div>
                                        <!-- Especificaciones -->
                                        <div class="tab-pane fade" id="specs-content" role="tabpanel">
                                            @if($product->specifications ?? false)
                                                <ul class="list-unstyled mb-0">
                                                    @foreach($product->specifications as $key => $value)
                                                        <li class="d-flex justify-content-between py-2 border-bottom">
                                                            <span class="text-muted">{{ $key }}</span>
                                                            <span class="fw-medium">{{ $value }}</span>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @else
                                                <p class="text-muted mb-0">
                                                    <i class="ri-information-line me-1"></i>
                                                    No hay especificaciones disponibles.
                                                </p>
                                            @endif
                                        </div>
                                        <!-- Reseñas -->
                                        <div class="tab-pane fade" id="reviews-content" role="tabpanel">
                                            <div class="text-center py-3">
                                                <div class="rating-stars mb-2">
                                                    @for($i = 1; $i <= 5; $i++)
                                                        <i class="ri-star-fill text-warning fs-4"></i>
                                                    @endfor
                                                </div>
                                                <p class="text-muted mb-0">
                                                    <i class="ri-chat-smile-2-line me-1"></i>
                                                    Las reseñas estarán disponibles próximamente.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Productos relacionados -->
                        @if($relatedProducts && $relatedProducts->count() > 0)
                            <div class="mt-4 pt-4 border-top">
                                <h6 class="mb-3 fw-semibold">
                                    <i class="ri-links-line me-1"></i>Productos relacionados
                                </h6>
                                <div class="swiper related-products-swiper" style="overflow: hidden;">
                                    <div class="swiper-wrapper">
                                        @foreach($relatedProducts as $related)
                                            <div class="swiper-slide" style="width: 160px;">
                                                <div class="card border-0 shadow-sm hover-card h-100"
                                                     style="cursor: pointer; transition: transform 0.2s;"
                                                     wire:click="selectRelatedProduct({{ $related->id }})"
                                                     wire:key="related-{{ $related->id }}">
                                                    <div class="position-relative" style="height: 140px; overflow: hidden;">
                                                        @if($related->images && $related->images->first())
                                                            <img src="{{ asset('app/' . $related->images->first()->path) }}"
                                                                 class="card-img-top w-100 h-100"
                                                                 style="object-fit: cover;"
                                                                 alt="{{ $related->name }}">
                                                        @else
                                                            <div class="bg-light h-100 d-flex align-items-center justify-content-center">
                                                                <i class="ri-image-line text-muted fs-3"></i>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="card-body p-2">
                                                        <p class="card-text small text-truncate mb-1 fw-medium">{{ $related->name }}</p>
                                                        @php
                                                            $relatedExchangeRate = \App\Models\ExchangeRate::getLatestRate('USD');
                                                            if (isset($related->precio_bs) && $related->precio_bs > 0) {
                                                                $relatedPriceBs = $related->precio_bs;
                                                            } else {
                                                                $relatedPriceBs = $related->price * ($relatedExchangeRate ?: 1);
                                                            }
                                                        @endphp
                                                        @if($currency === 'bs' && is_venezuela_company())
                                                            <p class="text-primary mb-0 small fw-bold">
                                                                Bs. {{ number_format($relatedPriceBs * $exchangeRate, 2, ',', '.') }}
                                                            </p>
                                                        @else
                                                            <p class="text-primary mb-0 small fw-bold">
                                                                {{ format_money($related->price) }}
                                                            </p>
                                                        @endif
                                                      </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="swiper-pagination related-products-pagination"></div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@section('styles')

<style>
    /* Animación de entrada del modal */
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .quick-view-content {
        border-radius: 16px;
        overflow: hidden;
    }

    /* Swiper customization */
    .product-gallery-main .swiper-button-next,
    .product-gallery-main .swiper-button-prev {
        width: 40px;
        height: 40px;
        background: rgba(255,255,255,0.9);
        border-radius: 50%;
        box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        transition: all 0.3s ease;
    }

    .product-gallery-main .swiper-button-next:hover,
    .product-gallery-main .swiper-button-prev:hover {
        background: white;
        transform: scale(1.1);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }

    .product-gallery-main .swiper-button-next::after,
    .product-gallery-main .swiper-button-prev::after {
        font-size: 16px;
        font-weight: bold;
        color: #333;
    }

    .product-gallery-thumbs .swiper-slide {
        opacity: 0.6;
        transition: opacity 0.2s;
    }

    .product-gallery-thumbs .swiper-slide-thumb-active {
        opacity: 1;
    }

    .product-gallery-thumbs .swiper-slide-thumb-active .thumb-wrapper {
        border-color: var(--bs-primary) !important;
        border-width: 2px !important;
    }

    /* Tabs styling */
    .nav-tabs-custom .nav-link {
        border: none;
        color: #6c757d;
        padding: 0.75rem 1rem;
        font-size: 0.875rem;
        font-weight: 500;
    }

    .nav-tabs-custom .nav-link.active {
        color: var(--bs-primary);
        background: transparent;
        border-bottom: 2px solid var(--bs-primary);
    }

    .nav-tabs-custom .nav-link:hover:not(.active) {
        color: var(--bs-primary);
        border-color: transparent;
    }

    /* Scrollbar styling */
    .related-products-scroll::-webkit-scrollbar {
        height: 6px;
    }

    .related-products-scroll::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    .related-products-scroll::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 10px;
    }

    .related-products-scroll::-webkit-scrollbar-thumb:hover {
        background: #999;
    }

    /* Hover effects */
    .hover-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
    }

    /* Rating stars */
    .rating-stars i {
        font-size: 1rem;
    }

    /* Quantity input */
    .input-group .btn {
        border-radius: 0;
    }
    .input-group .btn:first-child {
        border-radius: 6px 0 0 6px;
    }
    .input-group .btn:last-child {
        border-radius: 0 6px 6px 0;
    }

    /* Stock badges */
    .badge {
        font-weight: 500;
    }

    /* Carrusel de productos relacionados */
    .related-products-swiper {
        padding-bottom: 30px;
    }

    .related-products-swiper .swiper-slide {
        width: 160px;
        height: auto;
    }

    .related-products-pagination {
        bottom: 0 !important;
    }

    .related-products-pagination .swiper-pagination-bullet {
        width: 8px;
        height: 8px;
        background: #ddd;
        opacity: 1;
        transition: all 0.3s ease;
    }

    .related-products-pagination .swiper-pagination-bullet-active {
        background: var(--bs-primary);
        width: 20px;
        border-radius: 4px;
    }

    /* Avatar sizes */
    .avatar-sm {
        width: 32px;
        height: 32px;
    }

    .avatar-lg {
        width: 64px;
        height: 64px;
    }

    .avatar-title {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    /* Button icon */
    .btn-icon {
        width: 38px;
        height: 38px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .btn-ghost-secondary {
        background: transparent;
        border: 1px solid transparent;
        color: #6c757d;
    }

    .btn-ghost-secondary:hover {
        background: rgba(108, 117, 125, 0.1);
        color: #495057;
    }

    /* Font sizes */
    .fs-12 {
        font-size: 0.75rem !important;
    }

    .fs-13 {
        font-size: 0.8125rem !important;
    }
</style>
@endsection

@section('scripts')
@include('livewire.front.quick-view-js')
