<div>
    @if($showModal && $product)
        <div class="quick-view-backdrop" wire:ignore.self wire:click="closeModal">
            <div class="quick-view-container" @click.stop>
                <!-- Close Button -->
                <button class="quick-view-close" wire:click="closeModal">
                    <i class="ri-close-line"></i>
                </button>

                <div class="quick-view-grid">
                    <!-- Left: Gallery -->
                    <div class="">
                        @php
                            $galleryImages = collect();
                            if ($selectedVariant && $selectedVariant->image_path) {
                                $galleryImages->push(['path' => $selectedVariant->image_path, 'type' => 'variant']);
                            }
                            if ($product->images && $product->images->isNotEmpty()) {
                                foreach($product->images as $img) {
                                    $galleryImages->push(['path' => $img->path, 'type' => 'product']);
                                }
                            }
                        @endphp

                        @if($galleryImages->isNotEmpty())
                            <!-- Main Image -->
                            <div class="main-image-wrapper">
                                <div class="swiper product-gallery-main"
                                     wire:key="main-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                    <div class="swiper-wrapper">
                                        @foreach($galleryImages as $index => $image)
                                            <div class="swiper-slide" wire:key="slide-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                <div class="image-container">
                                                    <img src="{{ asset('app/' . $image['path']) }}"
                                                         alt="{{ $product->name }}"
                                                         class="img-fluid"
                                                         wire:key="img-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>
                            </div>

                            <!-- Thumbnails -->
                            @if($galleryImages->count() > 1)
                                <div class="thumbnails-wrapper"
                                     wire:key="thumbs-swiper-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                    <div class="swiper product-gallery-thumbs">
                                        <div class="swiper-wrapper">
                                            @foreach($galleryImages as $index => $image)
                                                <div class="swiper-slide" wire:key="thumb-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}-{{ $index }}">
                                                    <div class="thumb-item {{ $index === 0 ? 'active' : '' }}">
                                                        <img src="{{ asset('app/' . $image['path']) }}"
                                                             alt="{{ $product->name }}"
                                                             class="{{ $index === 0 ? 'active' : '' }}">
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @else
                            <div class="no-image-placeholder"
                                 wire:key="no-image-{{ $product->id }}-{{ $selectedVariant ? $selectedVariant->id : '0' }}">
                                <div class="no-image-content">
                                    <i class="ri-image-2-line"></i>
                                    <p>Sin imagen disponible</p>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Right: Product Info -->
                    <div class="quick-view-info-section">
                        <!-- Product Meta -->
                        <div class="product-meta">
                            <span class="meta-tag category">
                                <i class="ri-folder-line"></i>
                                {{ $product->categoria->nombre ?? 'Sin categoría' }}
                            </span>
                            <span class="meta-tag brand">
                                <i class="ri-price-tag-3-line"></i>
                                {{ $product->marca->nombre ?? 'Sin marca' }}
                            </span>
                        </div>

                        <!-- Product Title -->
                        <h1 class="product-name">{{ $product->name }}</h1>

                        <!-- Rating -->
                        <div class="product-rating">
                            @php
                                $rating = $product->rating ?? 4.5;
                                $fullStars = floor($rating);
                                $halfStar = $rating - $fullStars >= 0.5;
                            @endphp
                            <div class="stars-container">
                                @for($i = 1; $i <= 5; $i++)
                                    @if($i <= $fullStars)
                                        <i class="ri-star-fill"></i>
                                    @elseif($halfStar && $i == $fullStars + 1)
                                        <i class="ri-star-half-fill"></i>
                                    @else
                                        <i class="ri-star-line"></i>
                                    @endif
                                @endfor
                            </div>
                            <span class="reviews-text">({{ $product->reviews_count ?? rand(10, 150) }} reseñas)</span>
                        </div>

                        <!-- Stock Status -->
                        @php
                            $stock = $selectedVariant->stock ?? $product->stock ?? 100;
                        @endphp
                        <div class="stock-indicator {{ $stock <= 0 ? 'out-of-stock' : ($stock <= 5 ? 'low-stock' : 'in-stock') }}">
                            @if($stock <= 0)
                                <i class="ri-close-circle-line"></i>
                                <span>Agotado</span>
                            @elseif($stock <= 5)
                                <i class="ri-error-warning-line"></i>
                                <span>Últimas {{ $stock }} unidades</span>
                            @else
                                <i class="ri-checkbox-circle-line"></i>
                                <span>En stock</span>
                            @endif
                        </div>

                        <!-- Price -->
                        <div class="price-container">
                            @php
                                $exchangeRate = \App\Models\ExchangeRate::getLatestRate('USD');
                                if ($selectedVariant) {
                                    if (isset($selectedVariant->price) && $selectedVariant->price > 0) {
                                        $finalPriceUsd = $selectedVariant->price;
                                    } else {
                                        $finalPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                    }
                                } else {
                                    $finalPriceUsd = $product->price;
                                }
                                if ($selectedVariant) {
                                    if (isset($selectedVariant->precio_bs) && $selectedVariant->precio_bs > 0) {
                                        $finalPriceBs = $selectedVariant->precio_bs;
                                    } else {
                                        $variantPriceUsd = $selectedVariant->price_adjustment ?? $product->price;
                                        $finalPriceBs = $variantPriceUsd * ($exchangeRate ?: 1);
                                    }
                                } else {
                                    if (isset($product->precio_bs) && $product->precio_bs > 0) {
                                        $finalPriceBs = $product->precio_bs;
                                    } else {
                                        $finalPriceBs = $finalPriceUsd * ($exchangeRate ?: 1);
                                    }
                                }
                            @endphp

                            <div class="price-display">
                                @if($currency === 'bs' && is_venezuela_company())
                                    <div class="price-current">
                                        <span class="price-label">Precio:</span>
                                        <span class="price-value">Bs. {{ number_format($finalPriceBs * $exchangeRate, 2, ',', '.') }}</span>
                                    </div>
                                @else
                                    <div class="price-current">
                                        <span class="price-label">Precio:</span>
                                        <span class="price-value">{{ format_money($finalPriceUsd) }}</span>
                                    </div>
                                @endif
                            </div>


                        </div>

                        <!-- Variant Selection -->
                        @if($product->variants && $product->variants->isNotEmpty())
                            <div class="variant-section">
                                <h4 class="variant-title">Variante</h4>
                                <div class="variant-options">
                                    @foreach($product->variants as $variant)
                                        <div class="variant-option {{ $selectedVariant && $selectedVariant->id === $variant->id ? 'active' : '' }}"
                                             wire:click="selectVariant({{ $variant->id }})">
                                            <span>{{ $variant->name ?? 'Variante ' . $loop->iteration }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        <!-- Quantity Selector -->
                        <div class="quantity-section">
                            <h4 class="quantity-title">Cantidad</h4>
                            <div class="quantity-controls">
                                <button class="quantity-btn" wire:click="decrementQuantity">
                                    <i class="ri-subtract-line"></i>
                                </button>
                                <input type="number" class="quantity-input" wire:model.live="quantity" min="1" max="{{ $stock }}">
                                <button class="quantity-btn" wire:click="incrementQuantity">
                                    <i class="ri-add-line"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="action-buttons">
                            <button class="btn btn-primary btn-add-cart"
                                    wire:click="addToCart"
                                    wire:loading.attr="disabled"
                                    wire:target="addToCart">
                                <span wire:loading wire:target="addToCart" class="spinner-border spinner-border-sm me-2"></span>
                                <i class="ri-shopping-cart-2-line me-2"></i>
                                <span>Agregar al Carrito</span>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
    .quick-view-backdrop {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.8);
        backdrop-filter: blur(5px);
        z-index: 1050;
        display: flex;
        align-items: center;
        justify-content: center;
        animation: fadeIn 0.3s ease-out;
    }

    .quick-view-container {
        width: 95%;
        max-width: 1200px;
        max-height: 90vh;
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        overflow: hidden;
        animation: slideIn 0.4s cubic-bezier(0.16, 1, 0.3, 1);
    }

    .quick-view-close {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(0, 0, 0, 0.1);
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: #666;
        transition: all 0.3s ease;
        z-index: 10;
    }

    .quick-view-close:hover {
        background: rgba(0, 0, 0, 0.2);
        transform: rotate(90deg);
    }

    .quick-view-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 0;
        overflow-y: auto;
        max-height: 90vh;
    }



    .main-image-wrapper {
        flex: 1;
        min-height: 400px;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }

    .image-container {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #fff;
    }

    .image-container img {
        max-width: 100%;
        max-height: 100%;
        object-fit: contain;
        transition: transform 0.3s ease;
    }

    .image-container:hover img {
        transform: scale(1.05);
    }

    .thumbnails-wrapper {
        height: 80px;
    }

    .thumb-item {
        height: 80px;
        border-radius: 8px;
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .thumb-item:hover,
    .thumb-item.active {
        border-color: var(--bs-primary);
        transform: translateY(-2px);
    }

    .thumb-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .no-image-placeholder {
        flex: 1;
        min-height: 400px;
        border-radius: 12px;
        background: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }

    .no-image-content {
        text-align: center;
        color: #999;
    }

    .no-image-content i {
        font-size: 64px;
        margin-bottom: 16px;
        display: block;
    }

    .quick-view-info-section {
        padding: 40px;
        display: flex;
        flex-direction: column;
        gap: 24px;
        overflow-y: auto;
    }

    .product-meta {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }

    .meta-tag {
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .meta-tag.category {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #fff;
    }

    .meta-tag.brand {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        color: #fff;
    }

    .product-name {
        font-size: 32px;
        font-weight: 700;
        margin: 0;
        line-height: 1.2;
        color: #212529;
    }

    .product-rating {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .stars-container {
        display: flex;
        gap: 4px;
        font-size: 20px;
    }

    .stars-container i {
        color: #ffc107;
    }

    .reviews-text {
        color: #6c757d;
        font-size: 14px;
    }

    .stock-indicator {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 500;
    }

    .stock-indicator.in-stock {
        background: rgba(25, 135, 84, 0.1);
        color: #198754;
    }

    .stock-indicator.low-stock {
        background: rgba(255, 193, 7, 0.1);
        color: #ffc107;
    }

    .stock-indicator.out-of-stock {
        background: rgba(220, 53, 69, 0.1);
        color: #dc3545;
    }

    .price-container {
        padding: 24px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 12px;
        color: #fff;
    }

    .price-display {
        display: flex;
        align-items: baseline;
        gap: 12px;
        margin-bottom: 16px;
    }

    .price-label {
        font-size: 14px;
        opacity: 0.9;
    }

    .price-value {
        font-size: 36px;
        font-weight: 700;
    }

    .currency-switcher {
        display: flex;
        gap: 4px;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
        padding: 4px;
        border-radius: 12px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .currency-option {
        flex: 1;
        text-align: center;
        padding: 10px 16px;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        font-weight: 600;
        font-size: 14px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        position: relative;
    }

    .currency-option:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(255, 255, 255, 0.2);
        transform: translateY(-2px);
    }

    .currency-option.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-color: transparent;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        color: #ffffff;
    }

    .currency-option input[type="radio"] {
        position: absolute;
        opacity: 0;
        cursor: pointer;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
    }

    .currency-option.active {
        background: #fff;
        color: var(--bs-primary);
    }

    .currency-option input {
        display: none;
    }

    .variant-section {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .variant-title {
        font-size: 16px;
        font-weight: 600;
        margin: 0;
        color: #212529;
    }

    .variant-options {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .variant-option {
        padding: 10px 20px;
        border: 2px solid #dee2e6;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 500;
        color: #495057;
    }

    .variant-option:hover {
        border-color: var(--bs-primary);
        background: rgba(13, 110, 253, 0.05);
    }

    .variant-option.active {
        border-color: var(--bs-primary);
        background: var(--bs-primary);
        color: #fff;
    }

    .quantity-section {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .quantity-title {
        font-size: 16px;
        font-weight: 600;
        margin: 0;
        color: #212529;
    }

    .quantity-controls {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .quantity-btn {
        width: 48px;
        height: 48px;
        border: 2px solid #dee2e6;
        border-radius: 8px;
        background: #fff;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #495057;
        transition: all 0.3s ease;
    }

    .quantity-btn:hover {
        border-color: var(--bs-primary);
        color: var(--bs-primary);
        background: rgba(13, 110, 253, 0.05);
    }

    .quantity-input {
        width: 80px;
        height: 48px;
        border: 2px solid #dee2e6;
        border-radius: 8px;
        text-align: center;
        font-size: 18px;
        font-weight: 600;
        color: #212529;
    }

    .quantity-input:focus {
        outline: none;
        border-color: var(--bs-primary);
    }

    .action-buttons {
        display: flex;
        gap: 12px;
    }

    .btn-add-cart {
        flex: 2;
        height: 52px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-wishlist {
        flex: 1;
        height: 52px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .description-section {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .description-title {
        font-size: 16px;
        font-weight: 600;
        margin: 0;
        color: #212529;
    }

    .description-content {
        padding: 16px;
        background: #f8f9fa;
        border-radius: 8px;
        color: #6c757d;
        line-height: 1.6;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }

    @keyframes slideIn {
        from {
            opacity: 0;
            transform: translateY(30px) scale(0.95);
        }
        to {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }

    @media (max-width: 992px) {
        .quick-view-grid {
            grid-template-columns: 1fr;
        }

        .quick-view-gallery-section {
            padding: 24px;
        }

        .quick-view-info-section {
            padding: 24px;
        }

        .product-name {
            font-size: 24px;
        }

        .action-buttons {
            flex-direction: column;
        }
    }
</style>
@endpush

@section('scripts')
@include('livewire.front.quick-view-js')
@endsection
