<div>
    @section('title', 'Historial de Pedidos')

    <style>
        :root {
            --velzon-primary: #405189;
            --velzon-secondary: #3577f1;
            --velzon-success: #0ab39c;
            --velzon-warning: #f7b84b;
            --velzon-danger: #f06548;
            --velzon-info: #299cdb;
        }

        /* Header Premium */
        .page-header-premium {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            border-radius: 12px;
            padding: 1.5rem 2rem;
            margin-bottom: 1.5rem;
            position: relative;
            overflow: hidden;
        }

        .page-header-premium::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 300px;
            height: 100%;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 200 200'%3E%3Ccircle cx='100' cy='100' r='80' fill='rgba(255,255,255,0.05)'/%3E%3Ccircle cx='150' cy='50' r='50' fill='rgba(255,255,255,0.03)'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
        }

        .page-header-premium .breadcrumb {
            background: transparent;
            padding: 0;
            margin-bottom: 0.5rem;
        }

        .page-header-premium .breadcrumb-item a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.2s;
        }

        .page-header-premium .breadcrumb-item a:hover {
            color: #fff;
        }

        .page-header-premium .breadcrumb-item.active {
            color: rgba(255,255,255,0.9);
        }

        .page-header-premium .breadcrumb-item + .breadcrumb-item::before {
            color: rgba(255,255,255,0.5);
        }

        .page-header-premium h2 {
            color: #fff;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .page-header-premium p {
            color: rgba(255,255,255,0.75);
        }

        /* Stats Cards Premium */
        .stat-card-premium {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s ease;
            position: relative;
        }

        .stat-card-premium:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }

        .stat-card-premium .card-body {
            padding: 1.25rem;
            position: relative;
            z-index: 1;
        }

        .stat-card-premium .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 0.75rem;
            animation: iconPulse 2s infinite;
        }

        @keyframes iconPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        .stat-card-premium.stat-primary { background: linear-gradient(135deg, #e8ecf6 0%, #f3f5fb 100%); }
        .stat-card-premium.stat-primary .stat-icon { background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%); color: #fff; }
        
        .stat-card-premium.stat-warning { background: linear-gradient(135deg, #fef7e8 0%, #fffbf3 100%); }
        .stat-card-premium.stat-warning .stat-icon { background: linear-gradient(135deg, var(--velzon-warning) 0%, #f9c56b 100%); color: #fff; }
        
        .stat-card-premium.stat-success { background: linear-gradient(135deg, #e6f7f4 0%, #f0fbf9 100%); }
        .stat-card-premium.stat-success .stat-icon { background: linear-gradient(135deg, var(--velzon-success) 0%, #2cc4af 100%); color: #fff; }
        
        .stat-card-premium.stat-info { background: linear-gradient(135deg, #e6f4fb 0%, #f0f9fd 100%); }
        .stat-card-premium.stat-info .stat-icon { background: linear-gradient(135deg, var(--velzon-info) 0%, #4db0e3 100%); color: #fff; }

        .stat-card-premium h3 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
            color: #495057;
        }

        .stat-card-premium .stat-label {
            font-size: 0.8rem;
            color: #6c757d;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 500;
        }

        .stat-card-premium .stat-trend {
            position: absolute;
            top: 1rem;
            right: 1rem;
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
        }

        /* Filter Card Premium */
        .filter-card-premium {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
        }

        .filter-card-premium .card-body {
            padding: 1.25rem;
        }

        .filter-card-premium .form-label {
            font-weight: 500;
            font-size: 0.85rem;
            color: #495057;
            margin-bottom: 0.5rem;
        }

        .filter-card-premium .form-control,
        .filter-card-premium .form-select {
            border-radius: 8px;
            border: 1px solid #e9ecef;
            padding: 0.6rem 1rem;
            transition: all 0.2s;
        }

        .filter-card-premium .form-control:focus,
        .filter-card-premium .form-select:focus {
            border-color: var(--velzon-primary);
            box-shadow: 0 0 0 3px rgba(64, 81, 137, 0.1);
        }

        .filter-card-premium .input-group-text {
            background: linear-gradient(135deg, #f8f9fa 0%, #fff 100%);
            border-radius: 8px 0 0 8px;
            border-right: none;
        }

        .filter-card-premium .input-group .form-control {
            border-radius: 0 8px 8px 0;
        }

        .btn-filter-clear {
            background: linear-gradient(135deg, #f8f9fa 0%, #fff 100%);
            border: 1px solid #e9ecef;
            border-radius: 8px;
            color: #495057;
            font-weight: 500;
            transition: all 0.2s;
        }

        .btn-filter-clear:hover {
            background: #e9ecef;
            color: #333;
        }

        /* Timeline Visual */
        .order-timeline {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 0;
            position: relative;
        }

        .order-timeline::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 10%;
            right: 10%;
            height: 3px;
            background: #e9ecef;
            z-index: 0;
        }

        .timeline-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            z-index: 1;
        }

        .timeline-step .step-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e9ecef;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #adb5bd;
            font-size: 1rem;
            margin-bottom: 0.5rem;
            transition: all 0.3s;
        }

        .timeline-step.completed .step-icon {
            background: linear-gradient(135deg, var(--velzon-success) 0%, #2cc4af 100%);
            color: #fff;
            box-shadow: 0 4px 10px rgba(10, 179, 156, 0.3);
        }

        .timeline-step.active .step-icon {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            color: #fff;
            box-shadow: 0 4px 10px rgba(64, 81, 137, 0.3);
            animation: pulseActive 1.5s infinite;
        }

        @keyframes pulseActive {
            0%, 100% { box-shadow: 0 4px 10px rgba(64, 81, 137, 0.3); }
            50% { box-shadow: 0 4px 20px rgba(64, 81, 137, 0.5); }
        }

        .timeline-step .step-label {
            font-size: 0.7rem;
            color: #adb5bd;
            font-weight: 500;
            text-transform: uppercase;
        }

        .timeline-step.completed .step-label,
        .timeline-step.active .step-label {
            color: #495057;
        }

        /* Table Premium */
        .table-card-premium {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .table-card-premium .card-header {
            background: linear-gradient(135deg, #f8f9fa 0%, #fff 100%);
            border-bottom: 1px solid #e9ecef;
            padding: 1rem 1.25rem;
        }

        .table-premium {
            margin-bottom: 0;
        }

        .table-premium thead th {
            background: #f8f9fa;
            border: none;
            padding: 1rem;
            font-weight: 600;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #495057;
            cursor: pointer;
            transition: background 0.2s;
        }

        .table-premium thead th:hover {
            background: #e9ecef;
        }

        .table-premium tbody tr {
            transition: all 0.2s;
            border-bottom: 1px solid #f1f1f1;
        }

        .table-premium tbody tr:hover {
            background: linear-gradient(135deg, #f8f9fc 0%, #fff 100%);
            transform: scale(1.005);
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .table-premium tbody td {
            padding: 1rem;
            vertical-align: middle;
            border: none;
        }

        /* Badges Premium */
        .badge-premium {
            padding: 0.5em 0.85em;
            border-radius: 6px;
            font-weight: 500;
            font-size: 0.75rem;
            letter-spacing: 0.3px;
        }

        .badge-premium.badge-pendiente {
            background: linear-gradient(135deg, #fff3cd 0%, #fff8e1 100%);
            color: #856404;
            border: 1px solid #ffeeba;
        }

        .badge-premium.badge-procesando {
            background: linear-gradient(135deg, #cce5ff 0%, #e2f0ff 100%);
            color: #004085;
            border: 1px solid #b8daff;
        }

        .badge-premium.badge-asignado {
            background: linear-gradient(135deg, #e8ecf6 0%, #f0f3fb 100%);
            color: var(--velzon-primary);
            border: 1px solid #c8d0e7;
        }

        .badge-premium.badge-enviado {
            background: linear-gradient(135deg, #d1ecf1 0%, #e8f6f8 100%);
            color: #0c5460;
            border: 1px solid #bee5eb;
        }

        .badge-premium.badge-entregado {
            background: linear-gradient(135deg, #d4edda 0%, #e8f5eb 100%);
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .badge-premium.badge-cancelar {
            background: linear-gradient(135deg, #f8d7da 0%, #fce4e6 100%);
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .badge-payment {
            background: linear-gradient(135deg, #e9ecef 0%, #f8f9fa 100%);
            color: #495057;
            border: 1px solid #dee2e6;
            padding: 0.4em 0.75em;
            border-radius: 6px;
            font-weight: 500;
            font-size: 0.75rem;
        }

        /* Action Buttons Premium */
        .btn-action {
            padding: 0.4rem 0.75rem;
            border-radius: 6px;
            font-size: 0.8rem;
            font-weight: 500;
            transition: all 0.2s;
            border: none;
        }

        .btn-action-view {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            color: #fff;
        }

        .btn-action-view:hover {
            background: linear-gradient(135deg, #364573 0%, #4a5d9e 100%);
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(64, 81, 137, 0.3);
        }

        .btn-action-repeat {
            background: linear-gradient(135deg, var(--velzon-success) 0%, #2cc4af 100%);
            color: #fff;
        }

        .btn-action-repeat:hover {
            background: linear-gradient(135deg, #099885 0%, #1db39f 100%);
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(10, 179, 156, 0.3);
        }

        .btn-action-download {
            background: linear-gradient(135deg, var(--velzon-info) 0%, #4db0e3 100%);
            color: #fff;
        }

        .btn-action-download:hover {
            background: linear-gradient(135deg, #2388bc 0%, #3ea5da 100%);
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(41, 156, 219, 0.3);
        }

        .btn-action-quick {
            background: linear-gradient(135deg, #6c757d 0%, #868e96 100%);
            color: #fff;
        }

        .btn-action-quick:hover {
            background: linear-gradient(135deg, #5a6268 0%, #74818a 100%);
            color: #fff;
        }

        /* Empty State Premium */
        .empty-state-premium {
            padding: 4rem 2rem;
            text-align: center;
        }

        .empty-state-premium .empty-icon {
            width: 120px;
            height: 120px;
            margin: 0 auto 1.5rem;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: emptyFloat 3s ease-in-out infinite;
        }

        @keyframes emptyFloat {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .empty-state-premium .empty-icon i {
            font-size: 3.5rem;
            color: #adb5bd;
        }

        .empty-state-premium h4 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 0.75rem;
        }

        .empty-state-premium p {
            color: #6c757d;
            max-width: 400px;
            margin: 0 auto 1.5rem;
        }

        .btn-empty-action {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            color: #fff;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 500;
            border: none;
            transition: all 0.3s;
        }

        .btn-empty-action:hover {
            background: linear-gradient(135deg, #364573 0%, #4a5d9e 100%);
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(64, 81, 137, 0.3);
        }

        /* Chart Container */
        .chart-card-premium {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
        }

        .chart-bars {
            display: flex;
            align-items: flex-end;
            justify-content: space-around;
            height: 120px;
            padding: 1rem;
            gap: 8px;
        }

        .chart-bar {
            flex: 1;
            max-width: 40px;
            background: linear-gradient(180deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            border-radius: 4px 4px 0 0;
            position: relative;
            transition: all 0.3s;
            cursor: pointer;
        }

        .chart-bar:hover {
            background: linear-gradient(180deg, var(--velzon-secondary) 0%, #5a8ef7 100%);
            transform: scaleY(1.05);
        }

        .chart-bar::after {
            content: attr(data-month);
            position: absolute;
            bottom: -25px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 0.65rem;
            color: #6c757d;
            white-space: nowrap;
        }

        .chart-labels {
            display: flex;
            justify-content: space-around;
            padding: 0.5rem 1rem;
            border-top: 1px solid #e9ecef;
        }

        /* Modal Premium */
        .modal-premium .modal-content {
            border: none;
            border-radius: 12px;
            overflow: hidden;
        }

        .modal-premium .modal-header {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            color: #fff;
            border: none;
            padding: 1.25rem 1.5rem;
        }

        .modal-premium .modal-header .btn-close {
            filter: brightness(0) invert(1);
            opacity: 0.8;
        }

        .modal-premium .modal-body {
            padding: 1.5rem;
        }

        .modal-detail-item {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem 0;
            border-bottom: 1px solid #f1f1f1;
        }

        .modal-detail-item:last-child {
            border-bottom: none;
        }

        .modal-detail-label {
            color: #6c757d;
            font-size: 0.85rem;
        }

        .modal-detail-value {
            font-weight: 600;
            color: #495057;
        }

        .modal-products-list {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1rem;
        }

        .modal-product-item {
            display: flex;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e9ecef;
        }

        .modal-product-item:last-child {
            border-bottom: none;
        }

        /* Pagination Premium */
        .pagination-premium .page-link {
            border: none;
            border-radius: 6px;
            margin: 0 3px;
            color: #495057;
            font-weight: 500;
            transition: all 0.2s;
        }

        .pagination-premium .page-link:hover {
            background: #e9ecef;
            color: var(--velzon-primary);
        }

        .pagination-premium .page-item.active .page-link {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5a6eb5 100%);
            color: #fff;
        }

        /* Orders Container with Scroll */
        .orders-scroll-container {
            max-height: 600px;
            overflow-y: auto;
        }

        .orders-scroll-container::-webkit-scrollbar {
            width: 6px;
        }

        .orders-scroll-container::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 3px;
        }

        .orders-scroll-container::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 3px;
        }

        .orders-scroll-container::-webkit-scrollbar-thumb:hover {
            background: #a8a8a8;
        }

        /* Order Code Style */
        .order-code {
            font-family: 'Monaco', 'Consolas', monospace;
            font-weight: 600;
            color: var(--velzon-primary);
            background: #f0f3fb;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-size: 0.85rem;
        }

        /* Responsive */
        @media (max-width: 991.98px) {
            .order-timeline {
                display: none;
            }
            
            .chart-card-premium {
                display: none;
            }
        }

        @media (max-width: 767.98px) {
            .page-header-premium {
                padding: 1rem 1.25rem;
            }

            .page-header-premium h2 {
                font-size: 1.25rem;
            }

            .stat-card-premium .card-body {
                padding: 1rem;
            }

            .stat-card-premium h3 {
                font-size: 1.25rem;
            }

            .table-premium thead {
                display: none;
            }

            .table-premium tbody tr {
                display: block;
                margin-bottom: 1rem;
                background: #fff;
                border-radius: 8px;
                box-shadow: 0 2px 8px rgba(0,0,0,0.05);
                border: 1px solid #e9ecef;
            }

            .table-premium tbody td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 0.75rem 1rem;
                border-bottom: 1px solid #f1f1f1;
            }

            .table-premium tbody td::before {
                content: attr(data-label);
                font-weight: 600;
                color: #495057;
                font-size: 0.8rem;
            }

            .table-premium tbody td:last-child {
                border-bottom: none;
                justify-content: center;
            }

            .table-premium tbody td:last-child::before {
                display: none;
            }

            .btn-group-actions {
                flex-direction: column;
                gap: 0.5rem;
            }
        }
    </style>

    <section class="section bg-light py-4">
        <div class="container">
            <!-- Header Premium con Breadcrumb -->
            <div class="page-header-premium">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-2">
                        <li class="breadcrumb-item">
                            <a href="/"><i class="ri-home-4-line me-1"></i>Inicio</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#">Mi Cuenta</a>
                        </li>
                        <li class="breadcrumb-item active">Mis Pedidos</li>
                    </ol>
                </nav>
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center">
                    <div class="mb-3 mb-md-0">
                        <h2 class="mb-1"><i class="ri-shopping-bag-3-line me-2"></i>Historial de Pedidos</h2>
                        <p class="mb-0">Consulta y gestiona todos tus pedidos en un solo lugar</p>
                    </div>
                    <a href="/" class="btn btn-light px-4">
                        <i class="ri-store-2-line me-2"></i>Volver a la Tienda
                    </a>
                </div>
            </div>

            <!-- Stats Cards Premium -->
            <div class="row g-3 mb-4">
                <div class="col-xl-3 col-md-6 col-6">
                    <div class="card stat-card-premium stat-primary h-100">
                        <div class="card-body">
                            <div class="stat-icon">
                                <i class="ri-shopping-bag-3-line"></i>
                            </div>
                            <h3 class="mb-1">{{ $totalPedidos }}</h3>
                            <span class="stat-label">Total Pedidos</span>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-6">
                    <div class="card stat-card-premium stat-warning h-100">
                        <div class="card-body">
                            <div class="stat-icon">
                                <i class="ri-time-line"></i>
                            </div>
                            <h3 class="mb-1">{{ $pendientes }}</h3>
                            <span class="stat-label">Pendientes</span>
                            @if($pendientes > 0)
                                <span class="stat-trend bg-warning-subtle text-warning">
                                    <i class="ri-loader-4-line"></i> En espera
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-6">
                    <div class="card stat-card-premium stat-success h-100">
                        <div class="card-body">
                            <div class="stat-icon">
                                <i class="ri-checkbox-circle-line"></i>
                            </div>
                            <h3 class="mb-1">{{ $entregados }}</h3>
                            <span class="stat-label">Entregados</span>
                            @if($entregados > 0)
                                <span class="stat-trend bg-success-subtle text-success">
                                    <i class="ri-check-line"></i> Completados
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-6">
                    <div class="card stat-card-premium stat-info h-100">
                        <div class="card-body">
                            <div class="stat-icon">
                                <i class="ri-refund-2-line"></i>
                            </div>
                            <h3 class="mb-1">{{ money($totalGastado) }}</h3>
                            <span class="stat-label">Total Gastado</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráfico Simple de Compras (CSS Only) -->
            @if($pedidos->count() > 0)
            <div class="row mb-4 d-none d-lg-flex">
                <div class="col-12">
                    <div class="card chart-card-premium">
                        <div class="card-header bg-white d-flex justify-content-between align-items-center py-3">
                            <div>
                                <h6 class="mb-0"><i class="ri-bar-chart-line me-2 text-primary"></i>Actividad de Compras</h6>
                                <small class="text-muted">Últimos 6 meses</small>
                            </div>
                            <span class="badge badge-premium badge-procesando">
                                <i class="ri-line-chart-line me-1"></i>Resumen
                            </span>
                        </div>
                        <div class="chart-bars">
                            @php
                                $meses = ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];
                                $mesActual = now()->month;
                                $alturas = [30, 55, 40, 70, 85, 60]; // Simulación de datos
                            @endphp
                            @for($i = 5; $i >= 0; $i--)
                                @php
                                    $mesIndex = ($mesActual - $i - 1 + 12) % 12;
                                    $altura = $alturas[5 - $i] ?? rand(20, 90);
                                @endphp
                                <div class="chart-bar" style="height: {{ $altura }}%;" data-month="{{ $meses[$mesIndex] }}"></div>
                            @endfor
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Filtros Premium -->
            <div class="card filter-card-premium">
                <div class="card-body">
                    <div class="row g-3 align-items-end">
                        <div class="col-lg-4 col-md-6">
                            <label class="form-label">
                                <i class="ri-search-line me-1 text-muted"></i>Buscar pedido
                            </label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="ri-search-2-line text-muted"></i>
                                </span>
                                <input type="text"
                                       class="form-control border-start-0"
                                       placeholder="Código, método de pago..."
                                       wire:model.live.debounce.300ms="search">
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <label class="form-label">
                                <i class="ri-filter-3-line me-1 text-muted"></i>Estado
                            </label>
                            <select class="form-select" wire:model.live="status">
                                <option value="">Todos los estados</option>
                                <option value="Pendiente">🟡 Pendiente</option>
                                <option value="Procesando">🔵 Procesando</option>
                                <option value="Asignado">🟣 Asignado</option>
                                <option value="Enviado">🚚 Enviado</option>
                                <option value="Entregado">✅ Entregado</option>
                                <option value="Cancelar">❌ Cancelado</option>
                            </select>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <label class="form-label">
                                <i class="ri-sort-asc me-1 text-muted"></i>Ordenar por
                            </label>
                            <select class="form-select" wire:model.live="sortBy">
                                <option value="created_at">📅 Fecha</option>
                                <option value="total_usd">💵 Total</option>
                                <option value="codigo">🔢 Código</option>
                                <option value="estado">📊 Estado</option>
                            </select>
                        </div>
                        <div class="col-lg-2 col-md-6">
                            <button type="button" class="btn btn-filter-clear w-100" wire:click="resetFilters">
                                <i class="ri-refresh-line me-1"></i>Limpiar
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lista de Pedidos -->
            @if($pedidos->count() > 0)
                <div class="card table-card-premium">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0"><i class="ri-file-list-3-line me-2"></i>Listado de Pedidos</h6>
                            <small class="text-muted">{{ $pedidos->total() }} pedido(s) encontrado(s)</small>
                        </div>
                        <button type="button" 
                                class="btn btn-sm btn-outline-secondary"
                                wire:click="$set('sortDirection', '{{ $sortDirection === 'asc' ? 'desc' : 'asc' }}')">
                            <i class="ri-arrow-up-down-line me-1"></i>
                            {{ $sortDirection === 'asc' ? 'Ascendente' : 'Descendente' }}
                        </button>
                    </div>
                    <div class="orders-scroll-container">
                        <table class="table table-premium">
                            <thead>
                                <tr>
                                    <th wire:click="sortBy('codigo')" class="sortable">
                                        Código
                                        @if($sortBy === 'codigo')
                                            <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line ms-1"></i>
                                        @endif
                                    </th>
                                    <th wire:click="sortBy('created_at')" class="sortable">
                                        Fecha
                                        @if($sortBy === 'created_at')
                                            <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line ms-1"></i>
                                        @endif
                                    </th>
                                    <th>Método de Pago</th>
                                    <th wire:click="sortBy('estado')" class="sortable">
                                        Estado
                                        @if($sortBy === 'estado')
                                            <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line ms-1"></i>
                                        @endif
                                    </th>
                                    <th>Timeline</th>
                                    <th wire:click="sortBy('total_usd')" class="sortable text-end">
                                        Total
                                        @if($sortBy === 'total_usd')
                                            <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line ms-1"></i>
                                        @endif
                                    </th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($pedidos as $item)
                                    @php
                                        $estados = ['Pendiente', 'Procesando', 'Asignado', 'Enviado', 'Entregado'];
                                        $estadoActual = array_search($item->estado, $estados);
                                        $estadoActual = $estadoActual !== false ? $estadoActual : 0;
                                        
                                        $badgeClass = match($item->estado) {
                                            'Pendiente' => 'badge-pendiente',
                                            'Procesando' => 'badge-procesando',
                                            'Asignado' => 'badge-asignado',
                                            'Enviado' => 'badge-enviado',
                                            'Entregado' => 'badge-entregado',
                                            'Cancelar' => 'badge-cancelar',
                                            default => 'badge-pendiente'
                                        };

                                        $paymentIcon = match($item->metodo_pago) {
                                            'Efectivo' => 'ri-refund-2-line',
                                            'Transferencia' => 'ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line',
                                            'Pago Móvil' => 'ri-smartphone-line',
                                            default => 'ri-wallet-3-line'
                                        };
                                    @endphp
                                    <tr>
                                        <td data-label="Código">
                                            <span class="order-code">#{{ $item->codigo }}</span>
                                        </td>
                                        <td data-label="Fecha">
                                            <div>
                                                <span class="fw-medium">{{ \Carbon\Carbon::parse($item->created_at)->format('d M, Y') }}</span>
                                                <br>
                                                <small class="text-muted">{{ \Carbon\Carbon::parse($item->created_at)->format('H:i') }}</small>
                                            </div>
                                        </td>
                                        <td data-label="Método">
                                            <span class="badge-payment">
                                                <i class="{{ $paymentIcon }} me-1"></i>{{ $item->metodo_pago }}
                                            </span>
                                        </td>
                                        <td data-label="Estado">
                                            <span class="badge-premium {{ $badgeClass }}">
                                                @if($item->estado == 'Entregado')
                                                    <i class="ri-checkbox-circle-fill me-1"></i>
                                                @elseif($item->estado == 'Cancelar')
                                                    <i class="ri-close-circle-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-fill me-1"></i>
                                                @elseif($item->estado == 'Enviado')
                                                    <i class="ri-truck-line me-1"></i>
                                                @elseif($item->estado == 'Procesando')
                                                    <i class="ri-loader-4-line me-1"></i>
                                                @elseif($item->estado == 'Asignado')
                                                    <i class="ri-user-follow-line me-1"></i>
                                                @else
                                                    <i class="ri-time-line me-1"></i>
                                                @endif
                                                {{ $item->estado }}
                                            </span>
                                        </td>
                                        <td class="d-none d-lg-table-cell">
                                            @if($item->estado !== 'Cancelar')
                                            <div class="order-timeline" style="min-width: 200px;">
                                                @foreach(['Pendiente', 'Procesando', 'Enviado', 'Entregado'] as $index => $estado)
                                                    @php
                                                        $currentIndex = array_search($item->estado, ['Pendiente', 'Procesando', 'Asignado', 'Enviado', 'Entregado']);
                                                        $stepIndex = array_search($estado, ['Pendiente', 'Procesando', 'Enviado', 'Entregado']);
                                                        $isCompleted = false;
                                                        $isActive = false;
                                                        
                                                        if ($estado === 'Pendiente' && in_array($item->estado, ['Procesando', 'Asignado', 'Enviado', 'Entregado'])) $isCompleted = true;
                                                        elseif ($estado === 'Procesando' && in_array($item->estado, ['Asignado', 'Enviado', 'Entregado'])) $isCompleted = true;
                                                        elseif ($estado === 'Enviado' && $item->estado === 'Entregado') $isCompleted = true;
                                                        elseif ($estado === 'Entregado' && $item->estado === 'Entregado') $isCompleted = true;
                                                        
                                                        if ($estado === 'Pendiente' && $item->estado === 'Pendiente') $isActive = true;
                                                        elseif ($estado === 'Procesando' && in_array($item->estado, ['Procesando', 'Asignado'])) $isActive = true;
                                                        elseif ($estado === 'Enviado' && $item->estado === 'Enviado') $isActive = true;
                                                        
                                                        $stepIcon = match($estado) {
                                                            'Pendiente' => 'ri-time-line',
                                                            'Procesando' => 'ri-settings-3-line',
                                                            'Enviado' => 'ri-truck-line',
                                                            'Entregado' => 'ri-checkbox-circle-line',
                                                            default => 'ri-circle-line'
                                                        };
                                                    @endphp
                                                    <div class="timeline-step {{ $isCompleted ? 'completed' : '' }} {{ $isActive ? 'active' : '' }}">
                                                        <div class="step-icon">
                                                            <i class="{{ $stepIcon }}"></i>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            @else
                                                <span class="text-muted small">
                                                    <i class="ri-close-circle-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line me-1"></i>Cancelado
                                                </span>
                                            @endif
                                        </td>
                                        <td data-label="Total" class="text-end">
                                            <div>
                                                <span class="fw-bold text-dark">{{ money($item->total_usd) }}</span>
                                                @if($item->metodo_pago != 'Efectivo' && $item->total_bs)
                                                    <br>
                                                    <small class="text-muted">{{ moneyBS($item->total_bs) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td data-label="Acciones">
                                            <div class="d-flex justify-content-center gap-1 btn-group-actions flex-wrap">
                                                <a href="{{ route('front.pedido.detalle', $item->codigo) }}"
                                                   class="btn btn-action btn-action-view"
                                                   title="Ver detalle">
                                                    <i class="ri-eye-line me-1"></i>
                                                    <span class="d-none d-xl-inline">Ver</span>
                                                </a>
                                                <button type="button"
                                                        class="btn btn-action btn-action-quick"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#quickViewModal{{ $item->id }}"
                                                        title="Vista rápida">
                                                    <i class="ri-flashlight-line"></i>
                                                </button>
                                                @if($item->estado === 'Entregado')
                                                    <button type="button"
                                                            class="btn btn-action btn-action-repeat"
                                                            wire:click="repeatOrder({{ $item->id }})"
                                                            title="Repetir pedido">
                                                        <i class="ri-repeat-line"></i>
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Modal de Vista Rápida -->
                                    <div class="modal fade modal-premium" id="quickViewModal{{ $item->id }}" tabindex="-1" wire:ignore.self>
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">
                                                        <i class="ri-file-list-3-line me-2"></i>Pedido #{{ $item->codigo }}
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- Timeline en Modal -->
                                                    @if($item->estado !== 'Cancelar')
                                                    <div class="order-timeline mb-4" style="padding: 0 1rem;">
                                                        @foreach(['Pendiente', 'Procesando', 'Enviado', 'Entregado'] as $estado)
                                                            @php
                                                                $isCompleted = false;
                                                                $isActive = false;
                                                                
                                                                if ($estado === 'Pendiente' && in_array($item->estado, ['Procesando', 'Asignado', 'Enviado', 'Entregado'])) $isCompleted = true;
                                                                elseif ($estado === 'Procesando' && in_array($item->estado, ['Asignado', 'Enviado', 'Entregado'])) $isCompleted = true;
                                                                elseif ($estado === 'Enviado' && $item->estado === 'Entregado') $isCompleted = true;
                                                                elseif ($estado === 'Entregado' && $item->estado === 'Entregado') $isCompleted = true;
                                                                
                                                                if ($estado === 'Pendiente' && $item->estado === 'Pendiente') $isActive = true;
                                                                elseif ($estado === 'Procesando' && in_array($item->estado, ['Procesando', 'Asignado'])) $isActive = true;
                                                                elseif ($estado === 'Enviado' && $item->estado === 'Enviado') $isActive = true;
                                                                
                                                                $stepIcon = match($estado) {
                                                                    'Pendiente' => 'ri-time-line',
                                                                    'Procesando' => 'ri-settings-3-line',
                                                                    'Enviado' => 'ri-truck-line',
                                                                    'Entregado' => 'ri-checkbox-circle-line',
                                                                    default => 'ri-circle-line'
                                                                };
                                                            @endphp
                                                            <div class="timeline-step {{ $isCompleted ? 'completed' : '' }} {{ $isActive ? 'active' : '' }}">
                                                                <div class="step-icon">
                                                                    <i class="{{ $stepIcon }}"></i>
                                                                </div>
                                                                <span class="step-label">{{ $estado }}</span>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                    @endif

                                                    <div class="modal-detail-item">
                                                        <span class="modal-detail-label">Fecha del pedido</span>
                                                        <span class="modal-detail-value">{{ \Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i') }}</span>
                                                    </div>
                                                    <div class="modal-detail-item">
                                                        <span class="modal-detail-label">Estado actual</span>
                                                        <span class="badge-premium {{ $badgeClass }}">{{ $item->estado }}</span>
                                                    </div>
                                                    <div class="modal-detail-item">
                                                        <span class="modal-detail-label">Método de pago</span>
                                                        <span class="modal-detail-value">
                                                            <i class="{{ $paymentIcon }} me-1"></i>{{ $item->metodo_pago }}
                                                        </span>
                                                    </div>
                                                    <div class="modal-detail-item">
                                                        <span class="modal-detail-label">Total</span>
                                                        <span class="modal-detail-value fs-5 text-primary">{{ money($item->total_usd) }}</span>
                                                    </div>
                                                    @if($item->direccion)
                                                    <div class="modal-detail-item">
                                                        <span class="modal-detail-label">Dirección</span>
                                                        <span class="modal-detail-value text-end" style="max-width: 60%;">{{ $item->direccion }}</span>
                                                    </div>
                                                    @endif

                                                    @if($item->detalles && $item->detalles->count() > 0)
                                                    <div class="modal-products-list mt-3">
                                                        <h6 class="mb-3"><i class="ri-shopping-basket-2-line me-2"></i>Productos ({{ $item->detalles->count() }})</h6>
                                                        @foreach($item->detalles->take(5) as $detalle)
                                                            <div class="modal-product-item">
                                                                <div class="d-flex align-items-center flex-grow-1">
                                                                    <div class="me-3" style="width: 40px; height: 40px; background: #e9ecef; border-radius: 6px; display: flex; align-items: center; justify-content: center;">
                                                                        <i class="ri-shopping-bag-line text-muted"></i>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <small class="fw-medium">{{ $detalle->producto->nombre ?? 'Producto' }}</small>
                                                                        <br>
                                                                        <small class="text-muted">x{{ $detalle->cantidad }}</small>
                                                                    </div>
                                                                    <span class="fw-medium">{{ money($detalle->precio_usd ?? 0) }}</span>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                        @if($item->detalles->count() > 5)
                                                            <div class="text-center mt-2">
                                                                <small class="text-muted">+{{ $item->detalles->count() - 5 }} productos más</small>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    @endif
                                                </div>
                                                <div class="modal-footer bg-light">
                                                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                        <i class="ri-close-line me-1"></i>Cerrar
                                                    </button>
                                                    <a href="{{ route('front.pedido.detalle', $item->codigo) }}" class="btn btn-action btn-action-view">
                                                        <i class="ri-eye-line me-1"></i>Ver detalle completo
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación Premium -->
                @if($pedidos->hasPages())
                    <div class="d-flex justify-content-center mt-4 pagination-premium">
                        {{ $pedidos->links() }}
                    </div>
                @endif
            @else
                <!-- Empty State Premium -->
                <div class="card table-card-premium">
                    <div class="empty-state-premium">
                        <div class="empty-icon">
                            <i class="ri-shopping-bag-3-line"></i>
                        </div>
                        <h4>¡Aún no tienes pedidos!</h4>
                        <p>Parece que todavía no has realizado ninguna compra. Explora nuestra tienda y encuentra productos increíbles.</p>
                        <a href="/" class="btn btn-empty-action">
                            <i class="ri-store-2-line me-2"></i>Explorar Tienda
                        </a>
                        <div class="mt-4">
                            <div class="d-flex justify-content-center gap-4 text-muted">
                                <div class="text-center">
                                    <i class="ri-truck-line fs-4 mb-2 d-block"></i>
                                    <small>Envío rápido</small>
                                </div>
                                <div class="text-center">
                                    <i class="ri-shield-check-line fs-4 mb-2 d-block"></i>
                                    <small>Pago seguro</small>
                                </div>
                                <div class="text-center">
                                    <i class="ri-customer-service-2-line fs-4 mb-2 d-block"></i>
                                    <small>Soporte 24/7</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
</div>
