<div>
    @include('livewire.front.modals')

    <!-- Swiper slider header -->
    <section class="py-0 text-white">
    <div class="container-fluid px-0">
        <div class="swiper header-swiper">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="slide-content position-relative">
                        <img src="{{ asset('app/carousel/slide1.png') }}" alt="Bienvenidos" class="w-100" class="img-fluid">

                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="slide-content position-relative">
                        <img src="{{ asset('app/carousel/img2.jpg') }}" alt="Promociones" class="w-100" class="img-fluid">

                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="slide-content position-relative">
                        <img src="{{ asset('app/carousel/img3.jpg') }}" alt="Calidad" class="w-100" class="img-fluid">

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

    <!-- Products Section -->
    <section class="py-5">
        <div class="container">
            <!-- Stats Section -->
            <div class="row mb-5">
                <div class="col-12">
                    <div class="row g-4 text-center">
                        <div class="col-6 col-md-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <i class="ri-shopping-bag-line text-primary mb-3" style="font-size: 2.5rem;"></i>
                                    <h4 class="fw-bold text-primary">{{ $productos->total() }}</h4>
                                    <p class="text-muted mb-0">Productos</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-md-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <i class="ri-folder-line text-success mb-3" style="font-size: 2.5rem;"></i>
                                    <h4 class="fw-bold text-success">{{ $categorias->count() }}</h4>
                                    <p class="text-muted mb-0">Categorías</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-md-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <i class="ri-star-line text-warning mb-3" style="font-size: 2.5rem;"></i>
                                    <h4 class="fw-bold text-warning">4.9</h4>
                                    <p class="text-muted mb-0">Valoración</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-md-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <i class="ri-truck-line text-info mb-3" style="font-size: 2.5rem;"></i>
                                    <h4 class="fw-bold text-info">24h</h4>
                                    <p class="text-muted mb-0">Envío</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Best Selling Products -->
            @if($bestSellingProducts->count() > 0)
            <div class="mb-5" wire:ignore>
                <div class="text-center mb-5">
                    <span class="badge bg-primary-subtle text-primary px-3 py-2 rounded-pill mb-3">
                        <i class="ri-fire-line me-2"></i>Más Populares
                    </span>
                    <h2 class="fw-bold mb-3">Productos Más Vendidos</h2>
                    <p class="text-muted lead">Los favoritos de nuestros clientes con las mejores valoraciones</p>
                </div>
                <!-- Swiper -->
                <div class="swiper best-selling-slider" dir="ltr">
                    <div class="swiper-wrapper">
                        @foreach($bestSellingProducts as $product)
                        <div class="swiper-slide">
                            <div class="product-card-wrapper">
                                <div class="card">
                                    <div class="position-relative overflow-hidden">
                                        @if($product->images && $product->images->first())
                                            <img src="{{ asset('app/' . $product->images->first()->path) }}"
                                                 class="card-img img-fluid" alt="{{ $product->name }}" style="height: 180px; object-fit: cover;">
                                        @else
                                            <div class="card-img-top d-flex align-items-center justify-content-center bg-light product-image-placeholder" style="height: 180px;">
                                                <i class="ri-image-line text-muted" style="font-size: 2rem;"></i>
                                            </div>
                                        @endif
                                        <div class="product-badge">
                                            <span class="badge bg-gradient bg-danger text-white px-2 py-1 rounded-pill" style="font-size: 0.75rem;">
                                                <i class="ri-trophy-line me-1"></i>#{{ $loop->iteration }}
                                            </span>
                                        </div>
                                        <div class="product-overlay">
                                            <div class="d-flex gap-1">
                                                <button class="btn btn-white btn-sm rounded-circle" title="Vista rápida" style="width: 30px; height: 30px;">
                                                    <i class="ri-eye-line"></i>
                                                </button>
                                                <button class="btn btn-white btn-sm rounded-circle" title="Favoritos" style="width: 30px; height: 30px;">
                                                    <i class="ri-heart-line"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body p-3">
                                        <h6 class="card-title mb-2" style="font-size: 0.9rem; font-weight: 600;">{{ Str::limit($product->name, 35) }}</h6>
                                        <p class="text-muted small mb-2">{{ $product->categoria->nombre ?? 'Sin categoría' }}</p>

                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                </div>
            </div>
            @endif

            <!-- Search and Filters -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="input-group">
                        <span class="input-group-text bg-primary text-white border-primary">
                            <i class="ri-search-line"></i>
                        </span>
                        <input type="text" class="form-control border-primary" placeholder="Buscar productos..."
                               wire:model.live.debounce.300ms="search">
                        @if($search)
                        <button class="btn btn-outline-danger" wire:click="$set('search', '')">
                            <i class="ri-close-line"></i>
                        </button>
                        @endif
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select border-primary" wire:model.live="categoriaId">
                        <option value="">Todas las categorías</option>
                        @foreach($categorias as $categoria)
                            <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                @if(is_venezuela_company())
                    <select class="form-select border-primary" wire:model.live="currency">
                        <option value="usd" {{ $currency === 'usd' ? 'checked' : '' }}>USD</option>
                        <option value="bs" {{ $currency === 'bs' ? 'checked' : '' }}>BS</option>

                    </select>
                @endif
                </div>
            </div>

            <!-- Products Grid -->
            <div class="row g-4">
                @forelse ($productos->where('status', 1) as $product)
                    <div class="col-6 col-md-4 col-lg-3">
                        <div class="card h-100">
                            <div class="position-relative">
                                @if($product->images && $product->images->first())
                                    <img src="{{ asset('app/' . $product->images->first()->path) }}"
                                         class="card-img img-fluid" alt="{{ $product->name }}">
                                @else
                                    <div class="card-img-top d-flex align-items-center justify-content-center bg-light" style="height: 200px;">
                                        <i class="ri-image-line text-muted" style="font-size: 2rem;"></i>
                                    </div>
                                @endif
                                @if($product->quantity <= 0)
                                    <span class="badge bg-danger position-absolute top-0 end-0 m-2">Agotado</span>
                                @elseif($product->quantity <= 5)
                                    <span class="badge bg-warning position-absolute top-0 end-0 m-2">Pocas unidades</span>
                                @endif
                            </div>
                            <div class="card-body d-flex flex-column">
                                <h6 class="card-title">{{ Str::limit($product->name, 50) }}</h6>
                                <p class="text-muted small mb-2">{{ $product->categoria->nombre ?? 'Sin categoría' }}</p>
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-bold text-primary">
                                            @if($currency === 'usd')
                                                {{ format_money($product->price) }}
                                            @else
                                                @php
                                                    $exchangeRate = \App\Models\ExchangeRate::getLatestRate('USD') ?: 36;
                                                    $priceBs = $product->precio_bs * $exchangeRate;
                                                @endphp
                                                {{ format_money($priceBs) }}
                                            @endif
                                        </span>
                                        @if($product->quantity > 0)
                                            <small class="text-success">Disponible</small>
                                        @else
                                            <small class="text-danger">Agotado</small>
                                        @endif
                                    </div>
                                    <div class="d-flex gap-1">
                                        @auth
                                            <button wire:click="addCart({{ $product->id }})"
                                                    class="btn btn-primary btn-sm flex-fill"
                                                    @if($product->quantity <= 0) disabled @endif>
                                                <i class="ri-shopping-cart-line me-1"></i>
                                                {{ $product->quantity <= 0 ? 'Agotado' : 'Comprar' }}
                                            </button>
                                            <button wire:click="quickView({{ $product->id }})"
                                                    class="btn btn-outline-primary btn-sm">
                                                <i class="ri-eye-line"></i>
                                            </button>
                                        @else
                                            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft"
                                               class="btn btn-warning btn-sm w-100">
                                                <i class="ri-login-box-line me-1"></i>Iniciar sesión
                                            </a>
                                        @endauth
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12">
                        <div class="text-center py-5">
                            <i class="ri-box-3-line text-muted" style="font-size: 4rem;"></i>
                            <h5 class="mt-3">No hay productos disponibles</h5>
                            <p class="text-muted">Pronto tendremos nuevos productos para ti</p>
                        </div>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($productos->hasPages())
                <div class="mt-4 d-flex justify-content-center">
                    {{ $productos->links('livewire.pagination') }}
                </div>
            @endif
        </div>
    </section>

    <!-- Latest Customers Section -->
    <section class="py-5 bg-gradient-light" wire:ignore>
        <div class="container">
            <div class="text-center mb-5">
                <span class="badge bg-success-subtle text-success px-3 py-2 rounded-pill mb-3">
                    <i class="ri-team-line me-2"></i>Comunidad
                </span>
                <h2 class="fw-bold mb-3">Confiado <span class="text-primary">por</span> Nuestros Clientes</h2>
                <p class="text-muted lead">Más de <strong>{{ $latestCustomers->count() ?? 0 }}+</strong> clientes satisfechos confían en nosotros</p>
            </div>
            @if(isset($latestCustomers) && $latestCustomers->count() > 0)
            <!-- Swiper -->
            <div class="swiper trusted-client-slider" dir="ltr">
                <div class="swiper-wrapper">
                    @foreach($latestCustomers as $customer)
                    <div class="swiper-slide">
                        <div class="customer-card-wrapper">
                            <div class="card customer-card h-100 border-0 shadow">
                                <div class="card-body text-center p-3">
                                    <div class="customer-avatar-wrapper mb-3">
                                        @php
                                            $initials = strtoupper(substr($customer->name, 0, 1) . substr(strstr($customer->name, ' '), 1, 1));
                                            $colors = ['bg-primary', 'bg-success', 'bg-info', 'bg-warning', 'bg-danger', 'bg-secondary'];
                                            $color = $colors[array_rand($colors)];
                                        @endphp
                                        <div class="avatar-circle-large {{ $color }}">
                                            {{ $initials ?: substr($customer->name, 0, 2) }}
                                        </div>
                                        <div class="customer-status">
                                            <span class="badge bg-success rounded-pill">
                                                <i class="ri-check-line me-1"></i>Verificado
                                            </span>
                                        </div>
                                    </div>
                                    <h5 class="card-title mb-1 fw-bold text-dark">{{ Str::limit($customer->name, 25) }}</h5>
                                    <p class="text-muted mb-2 small">
                                        <i class="ri-map-pin-line me-1 text-primary"></i>Cliente Premium
                                    </p>

                                    <div class="customer-rating mb-2">
                                        <div class="d-flex justify-content-center align-items-center">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="ri-star-fill text-warning me-1 small"></i>
                                            @endfor
                                            <span class="text-muted ms-1 small">(5.0)</span>
                                        </div>
                                    </div>
                                    <p class="customer-date text-success fw-semibold small mb-0">
                                        <i class="ri-calendar-line me-1"></i>Desde {{ $customer->created_at->format('M Y') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>

            </div>
            @else
            <div class="text-center py-5">
                <div class="empty-state">
                    <i class="ri-user-line text-muted" style="font-size: 4rem;"></i>
                    <h4 class="mt-3 text-muted">Aún no hay clientes registrados</h4>
                    <p class="text-muted">Sé el primero en unirte a nuestra comunidad</p>
                    <button class="btn btn-primary btn-lg rounded-pill mt-3">
                        <i class="ri-user-add-line me-2"></i>Registrarse Ahora
                    </button>
                </div>
            </div>
            @endif
        </div>
    </section>

    <!-- Enhanced Contact Section -->
    <section class="py-5 bg-dark text-white" id="contacto">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="text-center mb-5">
                        <h2 class="fw-bold text-white mb-3">Contáctanos</h2>
                        <p class="text-white-50 lead">Estamos aquí para ayudarte. Envíanos un mensaje y te responderemos pronto.</p>
                    </div>

                    <div class="row g-4 mb-5">
                        <div class="col-md-4">
                            <div class="contact-info-card text-center p-4">
                                <div class="contact-icon mb-3">
                                    <i class="ri-phone-line text-success" style="font-size: 2.5rem;"></i>
                                </div>
                                <h5 class="text-white mb-2">Teléfono</h5>
                                <p class="text-white-50 mb-0">+58 412-1234567</p>
                                <small class="text-success">Lun - Sáb: 8am - 6pm</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="contact-info-card text-center p-4">
                                <div class="contact-icon mb-3">
                                    <i class="ri-mail-line text-primary" style="font-size: 2.5rem;"></i>
                                </div>
                                <h5 class="text-white mb-2">Email</h5>
                                <p class="text-white-50 mb-0">info@tienda.com</p>
                                <small class="text-primary">Respuesta en 24h</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="contact-info-card text-center p-4">
                                <div class="contact-icon mb-3">
                                    <i class="ri-map-pin-line text-warning" style="font-size: 2.5rem;"></i>
                                </div>
                                <h5 class="text-white mb-2">Ubicación</h5>
                                <p class="text-white-50 mb-0">Caracas, Venezuela</p>
                                <small class="text-warning">Envío nacional</small>
                            </div>
                        </div>
                    </div>

                    <div class="contact-form-wrapper">
                        <livewire:front.contact-message.index />
                    </div>

                    <!-- Social Media & Additional Info -->
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <div class="social-section text-center text-md-start">
                                <h5 class="text-white mb-3">Síguenos en redes sociales</h5>
                                <div class="d-flex justify-content-center justify-content-md-start gap-3">
                                    <a href="#" class="btn btn-outline-light btn-social">
                                        <i class="ri-facebook-fill"></i>
                                    </a>
                                    <a href="#" class="btn btn-outline-light btn-social">
                                        <i class="ri-instagram-line"></i>
                                    </a>
                                    <a href="#" class="btn btn-outline-light btn-social">
                                        <i class="ri-whatsapp-line"></i>
                                    </a>
                                    <a href="#" class="btn btn-outline-light btn-social">
                                        <i class="ri-twitter-x-line"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="quick-info text-center text-md-end">
                                <h5 class="text-white mb-3">Información rápida</h5>
                                <div class="d-flex flex-column gap-2">
                                    <span class="text-white-50">
                                        <i class="ri-time-line me-2 text-info"></i>Tiempo de respuesta: 2-4 horas
                                    </span>
                                    <span class="text-white-50">
                                        <i class="ri-customer-service-2-line me-2 text-success"></i>Soporte disponible 24/7
                                    </span>
                                    <span class="text-white-50">
                                        <i class="ri-shield-check-line me-2 text-warning"></i>Comunicación segura
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <livewire:components.theme-toggle />

    @push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">
    <style>
        .hero-banner {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }





    .currency-option {
        position: relative;
        cursor: pointer;
        padding: 8px 20px;
        border-radius: 8px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .currency-option:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(255, 255, 255, 0.2);
        transform: translateY(-2px);
    }

    .currency-option.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-color: transparent;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    }

    .currency-option input[type="radio"] {
        position: absolute;
        opacity: 0;
        cursor: pointer;
    }

    .currency-option span {
        font-weight: 600;
        font-size: 14px;
        color: #ffffff;
        letter-spacing: 0.5px;
        text-transform: uppercase;
    }

    .currency-option.active span {
        color: #ffffff;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

        .card {
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
            border-radius: 12px;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            border-color: #007bff;
        }

        .customer-card {
            transition: all 0.3s ease;
            border-radius: 15px;
        }

        .customer-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
        }

        .avatar-circle {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            font-weight: bold;
            color: white;
            margin: 0 auto;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .contact-info-card {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
        }

        .contact-info-card:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-5px);
        }

        .contact-icon {
            transition: transform 0.3s ease;
        }

        .contact-info-card:hover .contact-icon {
            transform: scale(1.1);
        }

        .contact-form-wrapper {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 20px;
            padding: 2rem;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Override Livewire Contact Component Styles for Dark Theme */
        .contact-form-wrapper .contact-message-container {
            background: transparent !important;
            padding: 0 !important;
        }

        .contact-form-wrapper .card {
            background: transparent !important;
            border: none !important;
            box-shadow: none !important;
        }

        .contact-form-wrapper .card-body {
            background: transparent !important;
        }

        .contact-form-wrapper .contact-image-placeholder {
            background: rgba(255, 255, 255, 0.1) !important;
            border-radius: 15px;
        }

        .contact-form-wrapper .form-control {
            background: rgba(255, 255, 255, 0.1) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            color: white !important;
            border-radius: 10px !important;
        }

        .contact-form-wrapper .form-control:focus {
            background: rgba(255, 255, 255, 0.15) !important;
            border-color: #28a745 !important;
            box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.25) !important;
            color: white !important;
        }

        .contact-form-wrapper .form-control::placeholder {
            color: rgba(255, 255, 255, 0.6) !important;
        }

        .contact-form-wrapper .form-label {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
        }

        .contact-form-wrapper .text-primary {
            color: #28a745 !important;
        }

        .contact-form-wrapper .text-muted {
            color: rgba(255, 255, 255, 0.6) !important;
        }

        .contact-form-wrapper .text-dark {
            color: rgba(255, 255, 255, 0.9) !important;
        }

        .contact-form-wrapper .btn-primary {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
            border: none !important;
            color: white !important;
        }

        .contact-form-wrapper .btn-primary:hover {
            background: linear-gradient(135deg, #20c997 0%, #28a745 100%) !important;
            transform: translateY(-2px);
        }

        .contact-form-wrapper .alert {
            background: rgba(255, 255, 255, 0.1) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            color: white !important;
        }

        .contact-form-wrapper .border-top {
            border-color: rgba(255, 255, 255, 0.2) !important;
        }

        .btn-social {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .btn-social:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        .social-section, .quick-info {
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Swiper Styles for Trusted Clients */
        .trusted-client-slider {
            overflow: hidden;
        }

        .trusted-client-slider .swiper-slide {
            width: auto;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .client-images {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
        }

        .trusted-client-slider .customer-card {
            transition: all 0.3s ease;
            border-radius: 15px;
        }

        .trusted-client-slider .customer-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
        }

        /* Best Selling Products Swiper */
        .best-selling-slider {
            overflow: hidden;
            padding: 20px 0;
        }

        .best-selling-slider .swiper-slide {
            height: auto;
        }

        .product-card-wrapper {
            padding: 10px;
        }

        .product-card {
            transition: all 0.4s ease;
            border-radius: 20px;
            overflow: hidden;
            max-width: 350px;
            margin: 0 auto;
        }

        .product-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15) !important;
        }

        .product-image {
            height: 250px;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .product-image-placeholder {
            height: 250px;
        }

        .product-card:hover .product-image {
            transform: scale(1.05);
        }

        .product-badge {
            position: absolute;
            top: 15px;
            left: 15px;
            z-index: 3;
        }

        .product-overlay {
            position: absolute;
            top: 15px;
            right: 15px;
            opacity: 0;
            transition: all 0.3s ease;
        }

        .product-card:hover .product-overlay {
            opacity: 1;
        }

        .rating {
            font-size: 0.9rem;
        }

        .price-section {
            background: linear-gradient(135deg, #f8f9ff 0%, #e3f2fd 100%);
            border-radius: 15px;
            padding: 15px;
        }

        .sales-badge {
            background: rgba(40, 167, 69, 0.1);
            border-radius: 25px;
            padding: 8px 16px;
            display: inline-flex;
            align-items: center;
        }

        /* Customers Section */
        .bg-gradient-light {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }

        .trusted-client-slider {
            overflow: hidden;
            padding: 20px 0;
        }

        .trusted-client-slider .swiper-slide {
            height: auto;
        }

        .customer-card-wrapper {
            padding: 5px;
        }

        .customer-card {
            transition: all 0.4s ease;
            border-radius: 15px;
            max-width: 250px;
            margin: 0 auto;
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
        }

        .customer-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15) !important;
        }

        .customer-avatar-wrapper {
            position: relative;
            display: inline-block;
        }

        .avatar-circle-large {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.4rem;
            font-weight: bold;
            color: white;
            margin: 0 auto;
            box-shadow: 0 6px 15px rgba(0,0,0,0.15);
            border: 3px solid white;
        }

        .customer-status {
            position: absolute;
            bottom: -5px;
            right: -5px;
        }

        .stat-item {
            padding: 10px;
            background: rgba(0,123,255,0.05);
            border-radius: 10px;
            margin: 5px;
        }

        .customer-rating {
            background: rgba(255,193,7,0.1);
            border-radius: 25px;
            padding: 8px 16px;
        }

        .empty-state {
            padding: 60px 20px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        /* Swiper Pagination */
        .swiper-pagination-bullet {
            background: #007bff;
            opacity: 0.3;
        }

        .swiper-pagination-bullet-active {
            opacity: 1;
            transform: scale(1.2);
        }

        /* Best Selling Products Slider - Tamaño uniforme */
        .best-selling-slider .swiper-slide {
            height: auto;
        }

        .best-selling-slider .product-card-wrapper {
            height: 100%;
        }

        .best-selling-slider .card {
            transition: all 0.3s ease;
            border-radius: 12px;
            overflow: hidden;
        }

        .best-selling-slider .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
        }

        .best-selling-slider .card-title {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            min-height: 2.4rem;
        }

        .best-selling-slider .card-body {
            background: #fff;
            border-radius: 0 0 12px 12px;
        }

        .best-selling-slider .product-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.6);
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .best-selling-slider .card:hover .product-overlay {
            opacity: 1;
        }
    </style>
    @endpush

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Trusted Client Slider
            if (document.querySelector('.trusted-client-slider')) {
                new Swiper('.trusted-client-slider', {
                    slidesPerView: 'auto',
                    spaceBetween: 10,
                    loop: true,
                    autoplay: {
                        delay: 3500,
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: '.trusted-client-slider .swiper-pagination',
                        clickable: true,
                    },
                    breakpoints: {
                        320: {
                            slidesPerView: 1,
                            spaceBetween: 10,
                        },
                        640: {
                            slidesPerView: 2,
                            spaceBetween: 10,
                        },
                        768: {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        1024: {
                            slidesPerView: 4,
                            spaceBetween: 10,
                        },
                        1200: {
                            slidesPerView: 5,
                            spaceBetween: 10,
                        },
                        1400: {
                            slidesPerView: 6,
                            spaceBetween: 10,
                        }
                    }
                });
            }

            // Initialize Best Selling Products Slider
            if (document.querySelector('.best-selling-slider')) {
                new Swiper('.best-selling-slider', {
                    slidesPerView: 'auto',
                    spaceBetween: 15,
                    loop: true,
                    autoplay: {
                        delay: 4000,
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: '.best-selling-slider .swiper-pagination',
                        clickable: true,
                    },
                    breakpoints: {
                        320: {
                            slidesPerView: 2,
                            spaceBetween: 10,
                        },
                        480: {
                            slidesPerView: 3,
                            spaceBetween: 12,
                        },
                        768: {
                            slidesPerView: 4,
                            spaceBetween: 15,
                        },
                        1024: {
                            slidesPerView: 5,
                            spaceBetween: 15,
                        },
                        1200: {
                            slidesPerView: 6,
                            spaceBetween: 15,
                        }
                    }
                });
            }
            // Initialize Best Selling Products Slider
           if (document.querySelector('.header-swiper')) {
                new Swiper('.header-swiper', {
                    loop: true,
                    autoplay: {
                        delay: 3000,
                        disableOnInteraction: false,
                    },

                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    speed: 3000,
                });
            }
        });

    </script>
    @endpush
</div>
