<div class="layout-width">
    <div class="navbar-header">
        <div class="d-flex align-items-center">
            <!-- LOGO -->
            <div class="navbar-brand-box horizontal-logo">
                <a href="/" class="logo logo-dark d-flex align-items-center text-decoration-none">
                    <div class="logo-icon me-2">
                        <i class="ri-store-2-line text-primary" style="font-size: 2rem;"></i>
                    </div>
                    <div class="logo-text">
                        <h4 class="mb-0 text-dark fw-bold">{{ env('APP_NAME') }}</h4>
                        <small class="text-muted">Tu tienda online</small>
                    </div>
                </a>
            </div>

            <!-- Navigation Menu -->
            <nav class="navbar-nav ms-4 d-none d-lg-flex">
                <ul class="nav nav-pills">
                    <li class="nav-item">
                        <a class="nav-link" href="/">
                            <i class="ri-home-4-line me-1"></i>Inicio
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/#marketplace">
                            <i class="ri-shopping-bag-3-line me-1"></i>Productos
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contacto">
                            <i class="ri-customer-service-2-line me-1"></i>Contacto
                        </a>
                    </li>
                </ul>
            </nav>
        </div>

        <div class="d-flex align-items-center">
            <!-- Currency Selector -->
            <div class="dropdown me-2">
                <button class="btn btn-outline-secondary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="ri-money-dollar-circle-line me-1"></i>
                    <span class="d-none d-sm-inline">{{ session('currency', 'USD') }}</span>
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#" onclick="Livewire.dispatch('setCurrency', { currency: 'USD' })">USD - Dólar</a></li>
                    <li><a class="dropdown-item" href="#" onclick="Livewire.dispatch('setCurrency', { currency: 'VES' })">VES - Bolívar</a></li>
                </ul>
            </div>

            @if (Auth::check())
            <!-- Wishlist -->
            <div class="dropdown me-2">
                <button type="button" class="btn btn-outline-danger btn-sm position-relative"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ri-heart-3-line"></i>
                    @php
                        $wishlistCount = auth()->user()->wishlists()->count();
                    @endphp
                    @if($wishlistCount > 0)
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 0.6rem;">
                            {{ $wishlistCount }}
                        </span>
                    @endif
                </button>
                <div class="dropdown-menu dropdown-menu-end p-3" style="min-width: 320px; max-height: 400px; overflow-y: auto;">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="mb-0"><i class="ri-heart-3-fill text-danger me-1"></i>Lista de Deseos</h6>
                        <span class="badge bg-primary">{{ $wishlistCount }}</span>
                    </div>
                    @livewire('front.wishlist.index')
                </div>
            </div>

            <!-- Cart -->
            <div class="me-2">
                @livewire('front.mini-cart')
            </div>

            <!-- User Menu -->
            <div class="dropdown header-item">
                <button type="button" class="btn btn-outline-primary d-flex align-items-center"
                        data-bs-toggle="dropdown" aria-expanded="false">
                    <div class="avatar-sm me-2">
                        <div class="avatar-title rounded-circle bg-primary text-white">
                            {{ strtoupper(substr(Auth::user()->name, 0, 2)) }}
                        </div>
                    </div>
                    <div class="d-none d-md-block text-start">
                        <span class="fw-medium">{{ Str::limit(Auth::user()->name, 15) }}</span>
                        <br>
                        <small class="text-muted">Cliente</small>
                    </div>
                    <i class="ri-arrow-down-s-line ms-1"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <div class="dropdown-header">
                        <h6 class="mb-0">¡Hola {{ Auth::user()->name }}!</h6>
                        <small class="text-muted">{{ Auth::user()->email }}</small>
                    </div>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="/front/pedido/historico">
                        <i class="ri-shopping-bag-3-line text-primary me-2"></i>
                        <span>Mis Pedidos</span>
                        @php
                            $pedidosCount = \App\Models\Pedido::where('userId', Auth::id())->count();
                        @endphp
                        @if($pedidosCount > 0)
                            <span class="badge bg-primary ms-auto">{{ $pedidosCount }}</span>
                        @endif
                    </a>
                    <a class="dropdown-item" href="#">
                        <i class="ri-user-settings-line text-info me-2"></i>
                        <span>Mi Perfil</span>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item text-danger" href="#" wire:click='logout()'>
                        <i class="ri-logout-box-r-line me-2"></i>
                        <span>Cerrar Sesión</span>
                    </a>
                </div>
            </div>
            @else
            <!-- Guest Actions -->
            <div class="d-flex gap-2">
                <button class="btn btn-outline-primary" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft">
                    <i class="ri-login-box-line me-1"></i>
                    <span class="d-none d-sm-inline">Iniciar Sesión</span>
                </button>
                <button class="btn btn-primary" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight">
                    <i class="ri-user-add-line me-1"></i>
                    <span class="d-none d-sm-inline">Registrarse</span>
                </button>
            </div>
            @endif

            <!-- Mobile Menu Toggle -->
            <button class="btn btn-outline-secondary d-lg-none ms-2" type="button" data-bs-toggle="collapse" data-bs-target="#mobileNav">
                <i class="ri-menu-3-line"></i>
            </button>
        </div>
    </div>

    <!-- Mobile Navigation -->
    <div class="collapse d-lg-none" id="mobileNav">
        <div class="navbar-nav p-3 border-top">
            <a class="nav-link" href="/">
                <i class="ri-home-4-line me-2"></i>Inicio
            </a>
            <a class="nav-link" href="/#marketplace">
                <i class="ri-shopping-bag-3-line me-2"></i>Productos
            </a>
            <a class="nav-link" href="#contacto">
                <i class="ri-customer-service-2-line me-2"></i>Contacto
            </a>
        </div>
    </div>
</div>

@push('styles')
<style>
    .navbar-header {
        padding: 1rem 0;
        border-bottom: 1px solid #e9ecef;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
    }

    .logo-icon {
        transition: transform 0.3s ease;
    }

    .logo:hover .logo-icon {
        transform: scale(1.1);
    }

    .nav-pills .nav-link {
        color: #6c757d;
        border-radius: 20px;
        padding: 0.5rem 1rem;
        transition: all 0.3s ease;
        margin: 0 0.25rem;
    }

    .nav-pills .nav-link:hover {
        background-color: #f8f9fa;
        color: #007bff;
        transform: translateY(-1px);
    }

    .avatar-sm {
        width: 32px;
        height: 32px;
    }

    .avatar-title {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .dropdown-menu {
        border: none;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        border-radius: 12px;
    }

    .dropdown-item {
        padding: 0.75rem 1rem;
        border-radius: 8px;
        margin: 0.25rem;
        transition: all 0.2s ease;
    }

    .dropdown-item:hover {
        background-color: #f8f9fa;
        transform: translateX(5px);
    }

    @media (max-width: 768px) {
        .navbar-header {
            padding: 0.75rem 0;
        }

        .logo-text h4 {
            font-size: 1.1rem;
        }

        .logo-text small {
            font-size: 0.7rem;
        }
    }
</style>
@endpush
