<div class="theme-toggle">
    <button wire:click="toggleTheme" class="theme-btn" title="{{ $isDark ? 'Modo Claro' : 'Modo Oscuro' }}">
        @if($isDark)
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z" clip-rule="evenodd"></path>
            </svg>
        @else
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path>
            </svg>
        @endif
    </button>
    
    <style>
    .theme-toggle {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 1000;
    }
    
    .theme-btn {
        background: white;
        color: #1a202c;
        padding: 12px;
        border-radius: 50%;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        border: 1px solid #e2e8f0;
        transition: all 0.3s;
        cursor: pointer;
    }
    
    .theme-btn:hover {
        box-shadow: 0 6px 20px rgba(0,0,0,0.2);
        transform: translateY(-1px);
    }
    
    [data-theme="dark"] .theme-btn {
        background: #2d3748;
        color: #f7fafc;
        border-color: #4a5568;
    }
    
    :root {
        --bg-primary: #ffffff;
        --text-primary: #1a202c;
    }
    
    [data-theme="dark"] {
        --bg-primary: #1a202c;
        --text-primary: #f7fafc;
    }
    
    body {
        background-color: var(--bg-primary);
        color: var(--text-primary);
        transition: background-color 0.3s, color 0.3s;
    }
    </style>
    
    <script>
    document.addEventListener('livewire:init', () => {
        Livewire.on('theme-changed', (event) => {
            document.documentElement.setAttribute('data-theme', event.theme);
            localStorage.setItem('theme', event.theme);
        });
        
        const savedTheme = localStorage.getItem('theme') || 'light';
        document.documentElement.setAttribute('data-theme', savedTheme);
    });
    </script>
</div>