<div class="ai-chatbot">
    <!-- Chat Toggle Button -->
    <button wire:click="toggleChat" class="chat-toggle {{ $isOpen ? 'active' : '' }}">
        @if($isOpen)
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        @else
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
            </svg>
        @endif
    </button>

    <!-- Chat Window -->
    @if($isOpen)
        <div class="chat-window">
            <div class="chat-header">
                <div class="bot-info">
                    <div class="bot-avatar">🤖</div>
                    <div>
                        <h4>Asistente IA</h4>
                        <span class="status">En línea</span>
                    </div>
                </div>
            </div>

            <div class="chat-messages" id="chatMessages">
                @foreach($messages as $message)
                    <div class="message {{ $message['type'] }}">
                        @if($message['type'] === 'bot')
                            <div class="bot-avatar">🤖</div>
                        @endif
                        <div class="message-content">
                            <div class="message-text">{!! nl2br(e($message['message'])) !!}</div>
                            <div class="message-time">{{ $message['time'] }}</div>
                        </div>
                    </div>
                @endforeach

                @if($isTyping)
                    <div class="message bot typing">
                        <div class="bot-avatar">🤖</div>
                        <div class="message-content">
                            <div class="typing-indicator">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="chat-input">
                <form wire:submit.prevent="sendMessage">
                    <input 
                        type="text" 
                        wire:model="currentMessage" 
                        placeholder="Escribe tu mensaje..."
                        class="message-input"
                        autocomplete="off"
                    >
                    <button type="submit" class="send-btn" {{ empty($currentMessage) ? 'disabled' : '' }}>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"></path>
                        </svg>
                    </button>
                </form>
            </div>
        </div>
    @endif
</div>

<style>
.ai-chatbot {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 1000;
}

.chat-toggle {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
    transition: all 0.3s ease;
}

.chat-toggle:hover {
    transform: scale(1.1);
    box-shadow: 0 6px 25px rgba(0,0,0,0.4);
}

.chat-window {
    position: absolute;
    bottom: 80px;
    right: 0;
    width: 350px;
    height: 500px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.3);
    display: flex;
    flex-direction: column;
    overflow: hidden;
}

.chat-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 15px;
}

.bot-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.bot-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background: rgba(255,255,255,0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
}

.status {
    font-size: 12px;
    opacity: 0.8;
}

.chat-messages {
    flex: 1;
    padding: 15px;
    overflow-y: auto;
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.message {
    display: flex;
    gap: 10px;
}

.message.user {
    flex-direction: row-reverse;
}

.message.user .message-content {
    background: #667eea;
    color: white;
    margin-left: 40px;
}

.message.bot .message-content {
    background: #f1f5f9;
    color: #334155;
    margin-right: 40px;
}

.message-content {
    max-width: 80%;
    padding: 10px 15px;
    border-radius: 18px;
    position: relative;
}

.message-text {
    font-size: 14px;
    line-height: 1.4;
}

.message-time {
    font-size: 11px;
    opacity: 0.7;
    margin-top: 5px;
}

.typing-indicator {
    display: flex;
    gap: 4px;
    padding: 10px 0;
}

.typing-indicator span {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: #94a3b8;
    animation: typing 1.4s infinite ease-in-out;
}

.typing-indicator span:nth-child(2) {
    animation-delay: 0.2s;
}

.typing-indicator span:nth-child(3) {
    animation-delay: 0.4s;
}

@keyframes typing {
    0%, 60%, 100% {
        transform: translateY(0);
    }
    30% {
        transform: translateY(-10px);
    }
}

.chat-input {
    padding: 15px;
    border-top: 1px solid #e2e8f0;
}

.chat-input form {
    display: flex;
    gap: 10px;
}

.message-input {
    flex: 1;
    padding: 10px 15px;
    border: 1px solid #e2e8f0;
    border-radius: 25px;
    outline: none;
    font-size: 14px;
}

.message-input:focus {
    border-color: #667eea;
}

.send-btn {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #667eea;
    color: white;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s;
}

.send-btn:hover:not(:disabled) {
    background: #5a67d8;
}

.send-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

@media (max-width: 768px) {
    .chat-window {
        width: 300px;
        height: 400px;
    }
}
</style>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('scroll-to-bottom', () => {
        setTimeout(() => {
            const chatMessages = document.getElementById('chatMessages');
            if (chatMessages) {
                chatMessages.scrollTop = chatMessages.scrollHeight;
            }
        }, 100);
    });
});
</script>