<div>
    <div class="container py-3">
        <div class="row g-3">
            <div class="col-lg-7">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-primary text-white border-0">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-0 fw-bold">
                                <i class="ri-shopping-bag-2-line me-2"></i>{{ ucfirst($tipoOperacion) }} con Lector
                            </h6>
                            <div>
                                <span class="badge bg-white text-primary">{{ count($cart) }} items</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label small fw-bold">Scanner de Código de Barras</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-barcode-line"></i></span>
                                <input type="text" class="form-control" placeholder="Escanee el código de barras"
                                       wire:model.defer="barcode" wire:keydown.enter="handleBarcodeScan(barcode)"
                                       data-barcode-input>
                                <button class="btn btn-outline-secondary" type="button" onclick="document.querySelector('[data-barcode-input]').focus()">
                                    <i class="ri-focus-3-line"></i>
                                </button>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label small fw-bold">Buscar Productos</label>
                            <input type="text" class="form-control" placeholder="Nombre, código o descripción"
                                   wire:model.debounce.300ms="searchTerm" wire:input="searchProducts">
                        </div>

                        @if(!empty($searchResults))
                            <div class="list-group mb-3">
                                @foreach($searchResults as $result)
                                    <button class="list-group-item list-group-item-action d-flex align-items-center" wire:click="selectProduct({{ $result->id }})">
                                        <div class="flex-grow-1">
                                            <div class="fw-bold">{{ $result->nombre }}</div>
                                            <div class="text-muted small">Código: {{ $result->codigo }}</div>
                                        </div>
                                        <div class="ms-3 text-success fw-bold">{{ format_money($result->precio_venta) }}</div>
                                    </button>
                                @endforeach
                            </div>
                        @endif

                        <div class="products-catalog" style="height: 45vh; overflow-y: auto;">
                            <!-- Aquí puede ir el catálogo de productos similar al POS -->
                            <div class="text-muted text-center py-5">Catálogo no implementado en esta vista. Use la búsqueda y el escaneo.</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-5">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-header bg-gradient-primary text-white border-0">
                        <h6 class="mb-0 fw-bold"><i class="ri-shopping-cart-2-line me-2"></i>Carrito</h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="cart-items" style="height: 45vh; overflow-y: auto;">
                            @forelse($cart as $index => $item)
                                <div class="cart-item border-bottom p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <div class="fw-bold">{{ $item['nombre'] }}</div>
                                            <div class="text-muted small">Código: {{ $item['codigo'] }}</div>
                                            <div class="d-flex align-items-center gap-2">
                                                <span class="fw-bold text-success">{{ format_money($item['precio_unitario']) }}</span>
                                                <span class="text-muted small">x {{ $item['cantidad'] }}</span>
                                                <span class="ms-auto fw-bold text-primary fs-6">{{ format_money($item['subtotal']) }}</span>
                                            </div>
                                        </div>
                                        <div class="ms-3">
                                            <div class="input-group input-group-sm">
                                                <button class="btn btn-outline-primary" wire:click="decrementCartItem({{ $index }})"><i class="ri-subtract-line"></i></button>
                                                <input type="text" class="form-control text-center" value="{{ $item['cantidad'] }}" readonly>
                                                <button class="btn btn-outline-primary" wire:click="incrementCartItem({{ $index }})"><i class="ri-add-line"></i></button>
                                            </div>
                                            <button class="btn btn-outline-danger btn-sm w-100 mt-2" wire:click="removeFromCart({{ $index }})">
                                                <i class="ri-delete-bin-line"></i> Quitar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-5 text-muted">
                                    Carrito vacío. Escanee o busque productos para agregar.
                                </div>
                            @endforelse
                        </div>

                        <div class="cart-summary bg-light p-3 border-top">
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">Subtotal:</span>
                                <span class="fw-bold">{{ format_money($total) }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">IVA (0%):</span>
                                <span class="fw-bold">{{ format_money(0) }}</span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="h5 mb-0 fw-bold">Total:</span>
                                <span class="h4 mb-0 fw-bold text-success">{{ format_money($total) }}</span>
                            </div>
                        </div>

                        <div class="sale-config p-3 border-top">
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="form-label small fw-bold">Documento</label>
                                    <select class="form-select form-select-sm" wire:model="tipoDocumento">
                                        <option value="boleta">Boleta</option>
                                        <option value="factura">Factura</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label class="form-label small fw-bold">Serie</label>
                                    <select class="form-select form-select-sm" wire:model="serieSeleccionada">
                                        <option value="">Seleccionar...</option>
                                        @foreach($seriesDisponibles as $serie)
                                            <option value="{{ $serie->id }}">{{ $serie->serie }} (Próximo: {{ str_pad($serie->correlativo_actual + 1, 8, '0', STR_PAD_LEFT) }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label small fw-bold">Método de Pago</label>
                                <select class="form-select" wire:model="metodoPago">
                                    <option value="efectivo">💵 Efectivo</option>
                                    <option value="tarjeta">💳 Tarjeta</option>
                                    <option value="transferencia">🏦 Transferencia</option>
                                    <option value="pago_movil">📱 Pago Móvil</option>
                                    <option value="punto_de_venta">🏪 Punto de Venta</option>
                                </select>
                            </div>

                            @if ($metodoPago === 'efectivo')
                                <div class="mb-3">
                                    <label class="form-label small fw-bold">Monto Recibido</label>
                                    <div class="input-group">
                                        <span class="input-group-text">{{ get_current_currency_symbol() }}</span>
                                        <input type="number" class="form-control" wire:model="montoPagado" step="0.01" min="{{ $total }}" placeholder="{{ $total }}">
                                    </div>
                                    @if ($montoCambio > 0)
                                        <div class="alert alert-success mt-2 py-2">
                                            <div class="d-flex justify-content-between">
                                                <span><i class="ri-money-dollar-circle-line me-1"></i>Cambio:</span>
                                                <strong>{{ format_money($montoCambio) }}</strong>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif

                            <div class="hardware-controls mb-3 p-2 bg-white rounded border">
                                <div class="row g-2">
                                    <div class="col-6">
                                        <button class="btn btn-sm btn-outline-primary w-100" wire:click="printTicket" title="Imprimir ticket" {{ count($cart) === 0 ? 'disabled' : '' }}>
                                            <i class="ri-printer-line me-1"></i>Ticket
                                        </button>
                                    </div>
                                    <div class="col-6">
                                        <button class="btn btn-sm btn-outline-warning w-100" wire:click="openCashDrawer" title="Abrir cajón">
                                            <i class="ri-money-dollar-circle-line me-1"></i>Cajón
                                        </button>
                                    </div>
                                </div>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" wire:model="printerEnabled" id="printerEnabled">
                                    <label class="form-check-label small" for="printerEnabled">Impresora habilitada</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" wire:model="cashDrawerEnabled" id="cashDrawerEnabled">
                                    <label class="form-check-label small" for="cashDrawerEnabled">Cajón automático</label>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" wire:model="customerDisplayEnabled" id="customerDisplayEnabled">
                                    <label class="form-check-label small" for="customerDisplayEnabled">Pantalla cliente</label>
                                </div>
                            </div>

                            <div class="d-grid gap-2">
                                <button class="btn btn-success btn-lg" wire:click="procesarVenta" {{ count($cart) === 0 ? 'disabled' : '' }}>
                                    <i class="ri-shopping-cart-2-line me-2"></i>
                                    Procesar {{ ucfirst($tipoOperacion) }} ({{ format_money($total) }})
                                </button>
                                <button class="btn btn-outline-danger" wire:click="cancelSale" {{ count($cart) === 0 ? 'disabled' : '' }}>
                                    <i class="ri-close-line me-2"></i>Cancelar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('livewire.admin.pos.hardware-scripts')
</div>
