<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Gestión de Ventas</h1>
            <p class="mb-0 text-muted">Administra y controla todas las ventas POS</p>
        </div>
        <a href="{{ route('admin.ventas.create') }}" class="btn btn-primary">
            <i class="ri-add-line me-2"></i>Nueva Venta POS
        </a>
    </div>

    <!-- Estadísticas Cards -->
    <div class="row g-3 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-primary bg-opacity-10 rounded-3 p-3">
                                <i class="ri-shopping-cart-line text-primary fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Total Ventas</h6>
                            <h3 class="mb-0">{{ number_format($this->totalVentas) }}</h3>
                            <small class="text-success"><i class="ri-arrow-up-line"></i> Período actual</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-success bg-opacity-10 rounded-3 p-3">
                                <i class="ri-money-dollar-circle-line text-success fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Monto Total</h6>
                            <h3 class="mb-0">{{ format_money($this->totalMonto) }}</h3>
                            <small class="text-success"><i class="ri-arrow-up-line"></i> {{ $this->fechaInicio }} - {{ $this->fechaFin }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-info bg-opacity-10 rounded-3 p-3">
                                <i class="ri-calendar-line text-info fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Ventas Hoy</h6>
                            <h3 class="mb-0">{{ number_format($this->ventasHoy) }}</h3>
                            <small class="text-info">{{ format_money($this->montoHoy) }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-warning bg-opacity-10 rounded-3 p-3">
                                <i class="ri-line-chart-line text-warning fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Promedio por Venta</h6>
                            <h3 class="mb-0">{{ format_money($this->promedioVenta) }}</h3>
                            <small class="text-warning">{{ number_format($this->ventasMes) }} ventas este mes</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-0 pb-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Filtros de Búsqueda</h5>
                <button wire:click="limpiarFiltros" class="btn btn-outline-secondary btn-sm">
                    <i class="ri-refresh-line me-1"></i>Limpiar
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Buscar</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0">
                            <i class="ri-search-line text-muted"></i>
                        </span>
                        <input type="text" wire:model.live.debounce.300ms="search"
                               class="form-control border-start-0"
                               placeholder="Código o documento...">
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Inicio</label>
                    <input type="date" wire:model.live="fechaInicio" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Fin</label>
                    <input type="date" wire:model.live="fechaFin" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Estado</label>
                    <select wire:model.live="estado" class="form-select">
                        <option value="">Todos</option>
                        @foreach($estados as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Método de Pago</label>
                    <select wire:model.live="metodoPago" class="form-select">
                        <option value="">Todos</option>
                        @foreach($metodosPago as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Ventas -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Listado de Ventas</h5>
                <div class="text-muted small">
                    {{ $ventas->firstItem() ?? 0 }} - {{ $ventas->lastItem() ?? 0 }} de {{ $ventas->total() }} ventas
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($ventas->isEmpty())
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="ri-shopping-cart-line text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <h5 class="text-muted">No se encontraron ventas</h5>
                    <p class="text-muted mb-0">Ajusta los filtros o crea una nueva venta</p>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Venta</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Cliente</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Documento</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Método Pago</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Total</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Estado</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center pe-4">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($ventas as $venta)
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
                                            <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                <i class="ri-receipt-line text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $venta->codigo }}</div>
                                                <small class="text-muted">{{ $venta->created_at->format('d/m/Y H:i') }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-user-line text-muted me-2"></i>
                                            <span>{{ $venta->cliente->name ?? 'Cliente general' }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-semibold">{{ strtoupper($venta->tipo_documento) }}</span>
                                            <small class="text-muted">{{ $venta->numero_documento ?? '-' }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $iconClass = match($venta->metodo_pago) {
                                                'efectivo' => 'ri-money-dollar-circle-line text-success',
                                                'transferencia' => 'ri-bank-line text-info',
                                                'pago_movil' => 'ri-smartphone-line text-primary',
                                                'tarjeta' => 'ri-bank-card-line text-warning',
                                                'punto_de_venta' => 'ri-calculator-line text-secondary',
                                                default => 'ri-question-line text-muted'
                                            };
                                        @endphp
                                        <div class="d-flex align-items-center">
                                            <i class="{{ $iconClass }} me-2"></i>
                                            <span>{{ ucfirst(str_replace('_', ' ', $venta->metodo_pago)) }}</span>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <span class="fw-bold text-dark">{{ format_money($venta->total) }}</span>
                                    </td>
                                    <td class="text-center">
                                        @switch($venta->estado)
                                            @case('pagado')
                                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-2 py-1">
                                                    <i class="ri-check-line me-1"></i>Pagado
                                                </span>
                                                @break
                                            @case('pendiente')
                                                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-2 py-1">
                                                    <i class="ri-time-line me-1"></i>Pendiente
                                                </span>
                                                @break
                                            @case('cancelado')
                                                <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-2 py-1">
                                                    <i class="ri-close-line me-1"></i>Anulado
                                                </span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td class="text-center pe-4">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.ventas.show', $venta->id) }}"
                                               class="btn btn-outline-primary btn-sm"
                                               title="Ver detalle">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            @if($venta->estado !== 'cancelado')
                                                <a href="{{ route('admin.notas-credito.create', ['venta_id' => $venta->id]) }}"
                                                   class="btn btn-outline-warning btn-sm"
                                                   title="Crear nota de crédito">
                                                    <i class="ri-file-text-line"></i>
                                                </a>
                                                <button wire:click="confirmarAnulacion({{ $venta->id }})"
                                                        class="btn btn-outline-danger btn-sm"
                                                        title="Anular venta"
                                                        onclick="return confirm('¿Estás seguro de anular esta venta?')">
                                                    <i class="ri-close-line"></i>
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if($ventas->hasPages())
                    <div class="card-footer bg-white border-0">
                        {{ $ventas->links() }}
                    </div>
                @endif
            @endif
        </div>
    </div>
</div>
