<div>
    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="user-profile-header-banner">
                    <img src="{{ asset('materialize/assets/img/pages/profile-banner.png') }}" alt="Banner image" class="rounded-top">
                </div>
                <div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
                    <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                        @if($user->avatar)
                            <img src="{{ Storage::url($user->avatar) }}" alt="user image" class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img">
                        @else
                            <div class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img bg-light d-flex justify-content-center align-items-center">
                                <i class=" ri-circle-line "></i>
                            </div>
                        @endif
                    </div>
                    <div class="flex-grow-1 mt-3 mt-sm-5">
                        <div class="d-flex align-items-md-end align-items-sm-start align-items-center flex-md-row flex-column flex-sm-row flex-column justify-content-between mx-4 mx-sm-0">
                            <div class="user-profile-info">
                                <h4>{{ $user->name }}</h4>
                                <ul class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
                                    <li class="list-inline-item">
                                        <i class=" ri-circle-line  me-1"></i>
                                        <span class="text-muted">{{ $user->email }}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Nav tabs -->
     <ul class="nav nav-pills flex-column flex-sm-row mb-4">
        <li class="nav-item">
            <a class="nav-link " href="/admin/profile">
                <i class="ri-user-line me-1"></i> Información Personal
            </a>
        </li>
        <li class="nav-item ">
            <a class="nav-link active" href="javascript:void(0);">
                <i class="ri-lock-line me-1"></i> Cambio de contraseña
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.users.history', $user->id) }}">
                <i class="ri-history-line me-1"></i> Historial
            </a>
        </li>
    </ul>

    <!-- Change Password Form -->
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header text-center">
                    <div class="avatar avatar-xl mx-auto mb-3">
                        <div class="avatar-initial bg-primary rounded-circle">
                            <i class="ri-lock-password-line fs-2"></i>
                        </div>
                    </div>
                    <h4 class="mb-1">Cambiar Contraseña</h4>
                    <p class="text-muted mb-0">Mantén tu cuenta segura con una contraseña fuerte</p>
                </div>
                <div class="card-body p-4">
                    <form wire:submit.prevent="updatePassword">
                        <div class="mb-3">
                            <label class="form-label fw-medium" for="current_password">
                                <i class="ri-key-line me-1"></i>Contraseña Actual
                            </label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-lock-line"></i></span>
                                <input
                                    type="password"
                                    class="form-control @error('current_password') is-invalid @enderror"
                                    id="current_password"
                                    wire:model="current_password"
                                    placeholder="Ingresa tu contraseña actual"
                                />
                            </div>
                            @error('current_password') <div class="text-danger mt-1"><small>{{ $message }}</small></div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-medium" for="password">
                                <i class="ri-lock-2-line me-1"></i>Nueva Contraseña
                            </label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-shield-line"></i></span>
                                <input
                                    type="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    id="password"
                                    wire:model="password"
                                    placeholder="Mínimo 8 caracteres"
                                />
                            </div>
                            @error('password') <div class="text-danger mt-1"><small>{{ $message }}</small></div> @enderror
                            <div class="form-text">
                                <i class="ri-information-line me-1"></i>Debe contener al menos 8 caracteres
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-medium" for="password_confirmation">
                                <i class="ri-check-double-line me-1"></i>Confirmar Contraseña
                            </label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-shield-check-line"></i></span>
                                <input
                                    type="password"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    id="password_confirmation"
                                    wire:model="password_confirmation"
                                    placeholder="Repite la nueva contraseña"
                                />
                            </div>
                            @error('password_confirmation') <div class="text-danger mt-1"><small>{{ $message }}</small></div> @enderror
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" wire:loading.attr="disabled">
                                <span wire:loading.remove>
                                    <i class="ri-save-line me-2"></i>Actualizar Contraseña
                                </span>
                                <span wire:loading>
                                    <i class="ri-loader-4-line me-2 spinner-border spinner-border-sm"></i>Actualizando...
                                </span>
                            </button>
                            <a href="{{ route('admin.users.profile') }}" class="btn btn-outline-secondary">
                                <i class="ri-arrow-left-line me-2"></i>Volver al Perfil
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <!-- Password Strength Indicator -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="ri-shield-star-line me-2"></i>Fortaleza de Contraseña</h6>
                </div>
                <div class="card-body">
                    <div class="password-requirements">
                        <div class="requirement-item mb-2">
                            <i class="ri-check-line text-success me-2"></i>
                            <span class="text-muted">Al menos 8 caracteres</span>
                        </div>
                        <div class="requirement-item mb-2">
                            <i class="ri-check-line text-success me-2"></i>
                            <span class="text-muted">Incluye letras mayúsculas y minúsculas</span>
                        </div>
                        <div class="requirement-item mb-2">
                            <i class="ri-check-line text-success me-2"></i>
                            <span class="text-muted">Contiene números</span>
                        </div>
                        <div class="requirement-item">
                            <i class="ri-check-line text-success me-2"></i>
                            <span class="text-muted">Incluye símbolos especiales</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security Tips -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="ri-lightbulb-line me-2"></i>Consejos de Seguridad</h6>
                </div>
                <div class="card-body">
                    <div class="security-tips">
                        <div class="tip-item d-flex align-items-start mb-3">
                            <div class="avatar avatar-sm me-3">
                                <div class="avatar-initial bg-success rounded">
                                    <i class="ri-shield-check-line"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Contraseña Única</h6>
                                <small class="text-muted">No reutilices contraseñas de otras cuentas</small>
                            </div>
                        </div>
                        <div class="tip-item d-flex align-items-start mb-3">
                            <div class="avatar avatar-sm me-3">
                                <div class="avatar-initial bg-info rounded">
                                    <i class="ri-eye-off-line"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Mantén la Privacidad</h6>
                                <small class="text-muted">Nunca compartas tu contraseña con otros</small>
                            </div>
                        </div>
                        <div class="tip-item d-flex align-items-start mb-3">
                            <div class="avatar avatar-sm me-3">
                                <div class="avatar-initial bg-warning rounded">
                                    <i class="ri-refresh-line"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Actualiza Regularmente</h6>
                                <small class="text-muted">Cambia tu contraseña cada 3-6 meses</small>
                            </div>
                        </div>
                        <div class="tip-item d-flex align-items-start">
                            <div class="avatar avatar-sm me-3">
                                <div class="avatar-initial bg-primary rounded">
                                    <i class="ri-smartphone-line"></i>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Habilita 2FA</h6>
                                <small class="text-muted">Añade autenticación de dos factores</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link rel="stylesheet" href="/materialize/assets/vendor/css/pages/page-profile.css" />
@endpush
